/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.registries;

import com.hbm.datagen.LanguageProvider;
import com.hbm.datagen.loot.BlockLootGen;
import com.hbm.datagen.model.BlockStateGen;
import com.hbm.datagen.model.ItemModelGen;
import com.hbm.item.CreativeTabVariantItem;
import com.hbm.item.HBMItems;
import com.hbm.registries.ModBlocks;
import com.hbm.registries.RegistryHelper;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class WrapperRegistry<T>
implements Supplier<T> {
    RegistryObject<T> registryObject;
    String localizedName;
    String genNameWay = "orderly_gen";

    @Override
    public T get() {
        return (T)this.registryObject.get();
    }

    public ResourceLocation getId() {
        return this.registryObject.getId();
    }

    @Nullable
    public ResourceKey<T> getKey() {
        return this.registryObject.getKey();
    }

    public static class BlockBuilder
    extends Builder<Block> {
        String genModelWay = "basic_model";
        String lootWay = "drop_self";
        ResourceKey<CreativeModeTab> creativeKey;
        BiConsumer<Block, BlockStateGen> modelGen;
        Function<Block, BlockItem> blockItem;

        public BlockBuilder(String name, Supplier<? extends Block> sup) {
            super(name, sup);
        }

        public BlockBuilder tab(ResourceKey<CreativeModeTab> tabKey) {
            this.creativeKey = tabKey;
            return this;
        }

        public BlockBuilder model(BiConsumer<Block, BlockStateGen> modelGen) {
            this.genModelWay = "model_standalone";
            this.modelGen = modelGen;
            return this;
        }

        public BlockBuilder model(String genModelWay) {
            this.genModelWay = genModelWay;
            return this;
        }

        public BlockBuilder loot(String lootWay) {
            this.lootWay = lootWay;
            return this;
        }

        public BlockBuilder loc(String genNameWay) {
            this.genNameWay = genNameWay;
            return this;
        }

        public BlockBuilder item(Function<Block, BlockItem> blockItem) {
            this.blockItem = blockItem;
            return this;
        }

        @Override
        public RegistryObject<Block> build() {
            WrappedBlockRegistry blockRegistry = new WrappedBlockRegistry();
            blockRegistry.registryObject = ModBlocks.BLOCKS.register(this.name, this.sup);
            HBMItems.ITEMS.register(this.name, this.blockItem != null ? () -> this.blockItem.apply((Block)blockRegistry.get()) : () -> new BlockItem((Block)blockRegistry.get(), new Item.Properties()));
            blockRegistry.creativeKey = this.creativeKey;
            blockRegistry.genModelWay = this.genModelWay;
            blockRegistry.genNameWay = this.genNameWay;
            blockRegistry.modelFactory = this.modelGen;
            blockRegistry.lootWay = this.lootWay;
            if (blockRegistry.genNameWay != null && blockRegistry.genNameWay.equals("literally") && this.localizedName != null) {
                blockRegistry.localizedName = this.localizedName;
            }
            ModBlocks.blockList.add(blockRegistry);
            return blockRegistry.registryObject;
        }
    }

    public static class WrappedBlockRegistry
    extends WrapperRegistry<Block> {
        ResourceKey<CreativeModeTab> creativeKey;
        String genModelWay = "basic_model";
        String lootWay = "drop_self";
        BiConsumer<Block, BlockStateGen> modelFactory;

        public void languageSupport(LanguageProvider provider) {
            switch (this.genNameWay) {
                case "literally": {
                    provider.add((Block)this.get(), this.localizedName);
                    break;
                }
                case "orderly_gen": {
                    provider.add((Block)this.get(), RegistryHelper.generateOrderlyName(this.getId().m_135815_()));
                    break;
                }
                case "reverse_gen": {
                    provider.add((Block)this.get(), RegistryHelper.generateReversedName(this.getId().m_135815_()));
                    break;
                }
                case "orderly_gen_except_first": {
                    provider.add((Block)this.get(), RegistryHelper.generateOrderlyExceptFirstName(this.getId().m_135815_()));
                    break;
                }
                default: {
                    provider.add((Block)this.get(), this.genNameWay);
                }
            }
        }

        public void creativeTabSupport(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == this.creativeKey) {
                event.getEntries().put((Object)new ItemStack((ItemLike)this.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        public void modelSupport(BlockStateGen provider) {
            switch (this.genModelWay) {
                default: 
            }
            if (this.modelFactory instanceof BiConsumer) {
                this.modelFactory.accept((Block)this.get(), provider);
            }
        }

        public void lootSupport(BlockLootGen provider) {
            switch (this.lootWay) {
                case "drop_self": {
                    provider.m_245724_((Block)this.registryObject.get());
                    break;
                }
                case "drop_none": {
                    provider.m_247577_((Block)this.registryObject.get(), BlockLootSubProvider.m_246386_());
                }
            }
        }
    }

    public static class ItemBuilder
    extends Builder<Item> {
        ResourceKey<CreativeModeTab> creativeKey;
        String genModelWay = "basic_model";
        Consumer<ItemModelGen> modelGen;
        String propertyName;
        Supplier<Boolean> condition;

        public ItemBuilder(String name, Supplier<? extends Item> sup) {
            super(name, sup);
        }

        public ItemBuilder tab(ResourceKey<CreativeModeTab> tabKey) {
            this.creativeKey = tabKey;
            return this;
        }

        public ItemBuilder model(Consumer<ItemModelGen> modelGen) {
            this.genModelWay = "model_standalone";
            this.modelGen = modelGen;
            return this;
        }

        public ItemBuilder model(String genModelWay) {
            this.genModelWay = genModelWay;
            return this;
        }

        public ItemBuilder withConfigTexture(String propertyName, Supplier<Boolean> condition) {
            this.propertyName = propertyName;
            this.condition = condition;
            this.genModelWay = "model_dynamic";
            return this;
        }

        public ItemBuilder loc(String genNameWay) {
            this.genNameWay = genNameWay;
            return this;
        }

        @Override
        public RegistryObject<Item> build() {
            WrappedItemRegistry itemRegistry = new WrappedItemRegistry();
            itemRegistry.registryObject = HBMItems.ITEMS.register(this.name, this.sup);
            itemRegistry.creativeKey = this.creativeKey;
            itemRegistry.genModelWay = this.genModelWay;
            itemRegistry.genNameWay = this.genNameWay;
            itemRegistry.modelFactory = this.modelGen;
            if (itemRegistry.genNameWay != null && itemRegistry.genNameWay.equals("literally") && this.localizedName != null) {
                itemRegistry.localizedName = this.localizedName;
            }
            HBMItems.itemList.add(itemRegistry);
            return itemRegistry.registryObject;
        }
    }

    private static abstract class Builder<T> {
        final String name;
        final Supplier<? extends T> sup;
        String genNameWay = "orderly_gen";
        String localizedName;

        Builder(String name, Supplier<? extends T> sup) {
            this.name = name;
            this.sup = sup;
        }

        public abstract RegistryObject<T> build();
    }

    public static class WrappedItemRegistry
    extends WrapperRegistry<Item> {
        ResourceKey<CreativeModeTab> creativeKey;
        String genModelWay = "basic_model";
        Consumer<ItemModelGen> modelFactory;

        public void languageSupport(LanguageProvider provider) {
            switch (this.genNameWay) {
                case "literally": {
                    provider.add((Item)this.get(), this.localizedName);
                    break;
                }
                case "orderly_gen": {
                    provider.add((Item)this.get(), RegistryHelper.generateOrderlyName(this.getId().m_135815_()));
                    break;
                }
                case "reverse_gen": {
                    provider.add((Item)this.get(), RegistryHelper.generateReversedName(this.getId().m_135815_()));
                    break;
                }
                case "orderly_gen_except_first": {
                    provider.add((Item)this.get(), RegistryHelper.generateOrderlyExceptFirstName(this.getId().m_135815_()));
                    break;
                }
                default: {
                    provider.add((Item)this.get(), this.genNameWay);
                }
            }
        }

        public void creativeTabSupport(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == this.creativeKey) {
                Item item = (Item)this.get();
                if (item instanceof CreativeTabVariantItem) {
                    CreativeTabVariantItem variantItem = (CreativeTabVariantItem)item;
                    variantItem.fillCreativeTab(event);
                } else {
                    event.getEntries().put((Object)new ItemStack((ItemLike)item), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        }

        public void modelSupport(ItemModelGen provider) {
            switch (this.genModelWay) {
                case "basic_model": {
                    provider.basicItem((Item)this.get());
                    break;
                }
                case "spawn_egg_model": {
                    provider.withExistingParent(this.localizedName, "minecraft:item/template_spawn_egg");
                    break;
                }
                case "model_standalone": {
                    if (this.modelFactory == null) break;
                    this.modelFactory.accept(provider);
                    break;
                }
            }
        }
    }
}

