/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.render.entity.AtomicBombExplosionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class AtomicBombExplosionRenderer
extends EntityRenderer<AtomicBombExplosionEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hbm", "textures/models/explosion/tomblast.png");
    private static final int SEGMENTS = 16;
    private static final int LAYERS = 5;
    private static final float HEIGHT_BASE = 20.0f;
    private static final float DEPTH = 20.0f;

    public AtomicBombExplosionRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
    }

    public void render(AtomicBombExplosionEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        double scale = Math.max(1.0, (double)((float)entity.f_19797_ + partialTick));
        float angleStep = 0.3926991f;
        float playerTicks = Minecraft.m_91087_().f_91074_ != null ? (float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTick : (float)entity.f_19797_ + partialTick;
        float movement = -playerTicks * 0.05f;
        for (int segment = 0; segment < 16; ++segment) {
            double baseAngle = angleStep * (float)segment;
            double nextAngle = baseAngle + (double)angleStep;
            double cos0 = Math.cos(baseAngle);
            double sin0 = Math.sin(baseAngle);
            double cos1 = Math.cos(nextAngle);
            double sin1 = Math.sin(nextAngle);
            for (int layer = 0; layer < 5; ++layer) {
                double modifier = 1.0 - (double)layer * 0.025;
                double topY = 20.0 + (double)layer * 10.0;
                double offset = layer == 0 ? 1.0 : 1.0 / (double)layer;
                float vTop = (float)(1.0 + offset + (double)movement);
                float vBottom = (float)(offset + (double)movement);
                float x0 = (float)(cos0 * scale * modifier);
                float z0 = (float)(sin0 * scale * modifier);
                float x1 = (float)(cos1 * scale * modifier);
                float z1 = (float)(sin1 * scale * modifier);
                AtomicBombExplosionRenderer.addVertex(consumer, matrix, x0, (float)topY, z0, 0.0f, vTop, 0.0f);
                AtomicBombExplosionRenderer.addVertex(consumer, matrix, x0, -20.0f, z0, 0.0f, vBottom, 1.0f);
                AtomicBombExplosionRenderer.addVertex(consumer, matrix, x1, -20.0f, z1, 1.0f, vBottom, 1.0f);
                AtomicBombExplosionRenderer.addVertex(consumer, matrix, x1, (float)topY, z1, 1.0f, vTop, 0.0f);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private static void addVertex(VertexConsumer consumer, Matrix4f matrix, float x, float y, float z, float u, float v, float alpha) {
        consumer.m_252986_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(AtomicBombExplosionEntity entity) {
        return TEXTURE;
    }
}

