/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.render.ModRenderTypes;
import com.hbm.render.entity.FiveHundredKgExplosionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class FiveHundredKgExplosionRenderer
extends EntityRenderer<FiveHundredKgExplosionEntity> {
    private static final int BEAM_COUNT = 8;
    private static final float BEAM_HEIGHT = 250.0f;
    private static final ResourceLocation FALLBACK_TEXTURE = new ResourceLocation("hbm", "textures/entity/duck.png");

    public FiveHundredKgExplosionRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
    }

    public void render(FiveHundredKgExplosionEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        FiveHundredKgExplosionRenderer.renderBeamRing(entity, partialTick, poseStack, buffer, 0.5f, 1.0f, 0.0f, 0.0f);
        FiveHundredKgExplosionRenderer.renderBeamRing(entity, partialTick, poseStack, buffer, 0.25f, 1.0f, 0.0f, 1.0f);
        FiveHundredKgExplosionRenderer.renderOrb(entity, partialTick, poseStack, buffer);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private static void renderBeamRing(FiveHundredKgExplosionEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, float radius, float r, float g, float b) {
        float life = ((float)entity.f_19797_ + partialTick) / 90.0f;
        float alpha = Mth.m_14036_((float)(1.0f - life), (float)0.0f, (float)1.0f);
        if (alpha <= 0.0f) {
            return;
        }
        VertexConsumer consumer = buffer.m_6299_(ModRenderTypes.ATOMIC_FLASH);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        double angleStep = 0.7853981633974483;
        for (int i = 0; i < 8; ++i) {
            double angle0 = angleStep * (double)i;
            double angle1 = angle0 + angleStep;
            float x0 = (float)(Math.cos(angle0) * (double)radius);
            float z0 = (float)(Math.sin(angle0) * (double)radius);
            float x1 = (float)(Math.cos(angle1) * (double)radius);
            float z1 = (float)(Math.sin(angle1) * (double)radius);
            FiveHundredKgExplosionRenderer.addBeamQuad(consumer, matrix, x0, z0, x1, z1, r, g, b, alpha * 0.85f);
        }
    }

    private static void addBeamQuad(VertexConsumer consumer, Matrix4f matrix, float x0, float z0, float x1, float z1, float r, float g, float b, float alpha) {
        consumer.m_252986_(matrix, x0, 250.0f, z0).m_85950_(r, g, b, alpha * 0.25f).m_5752_();
        consumer.m_252986_(matrix, x0, 0.0f, z0).m_85950_(r, g, b, alpha).m_5752_();
        consumer.m_252986_(matrix, x1, 0.0f, z1).m_85950_(r, g, b, alpha).m_5752_();
        consumer.m_252986_(matrix, x1, 250.0f, z1).m_85950_(r, g, b, alpha * 0.25f).m_5752_();
    }

    private static void renderOrb(FiveHundredKgExplosionEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        float progress = Mth.m_14036_((float)(((float)entity.f_19797_ + partialTick) / 90.0f), (float)0.0f, (float)1.0f);
        float scale = Math.max(0.0f, 10.0f - 10.0f * progress);
        if (scale <= 0.0f) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        FiveHundredKgExplosionRenderer.drawSphere(poseStack, buffer.m_6299_(ModRenderTypes.DEATH_BLAST_CORE), 24, 32, 1.0f, 0.0f, 1.0f, progress);
        poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        float additiveAlpha = progress * 0.125f;
        for (int i = 0; i < 8; ++i) {
            FiveHundredKgExplosionRenderer.drawSphere(poseStack, buffer.m_6299_(ModRenderTypes.DEATH_BLAST_GLARE), 24, 32, 1.0f, 0.0f, 0.0f, additiveAlpha);
            poseStack.m_85841_(1.05f, 1.05f, 1.05f);
        }
        poseStack.m_85849_();
    }

    private static void drawSphere(PoseStack poseStack, VertexConsumer consumer, int latSegments, int lonSegments, float r, float g, float b, float alpha) {
        if (alpha <= 0.0f) {
            return;
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (int lat = 0; lat < latSegments; ++lat) {
            float lat0 = (float)Math.PI * ((float)lat / (float)latSegments - 0.5f);
            float lat1 = (float)Math.PI * (((float)lat + 1.0f) / (float)latSegments - 0.5f);
            float sinLat0 = Mth.m_14031_((float)lat0);
            float cosLat0 = Mth.m_14089_((float)lat0);
            float sinLat1 = Mth.m_14031_((float)lat1);
            float cosLat1 = Mth.m_14089_((float)lat1);
            for (int lon = 0; lon < lonSegments; ++lon) {
                float lon0 = (float)(Math.PI * 2 * (double)lon / (double)lonSegments);
                float lon1 = (float)(Math.PI * 2 * (double)((float)lon + 1.0f) / (double)lonSegments);
                float cosLon0 = Mth.m_14089_((float)lon0);
                float sinLon0 = Mth.m_14031_((float)lon0);
                float cosLon1 = Mth.m_14089_((float)lon1);
                float sinLon1 = Mth.m_14031_((float)lon1);
                float x00 = cosLon0 * cosLat0;
                float z00 = sinLon0 * cosLat0;
                float y00 = sinLat0;
                float x01 = cosLon1 * cosLat0;
                float z01 = sinLon1 * cosLat0;
                float y01 = sinLat0;
                float x10 = cosLon0 * cosLat1;
                float z10 = sinLon0 * cosLat1;
                float y10 = sinLat1;
                float x11 = cosLon1 * cosLat1;
                float z11 = sinLon1 * cosLat1;
                float y11 = sinLat1;
                FiveHundredKgExplosionRenderer.addTriangle(consumer, matrix, x00, y00, z00, x10, y10, z10, x11, y11, z11, r, g, b, alpha);
                FiveHundredKgExplosionRenderer.addTriangle(consumer, matrix, x00, y00, z00, x11, y11, z11, x01, y01, z01, r, g, b, alpha);
            }
        }
    }

    private static void addTriangle(VertexConsumer consumer, Matrix4f matrix, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float alpha) {
        consumer.m_252986_(matrix, x0, y0, z0).m_85950_(r, g, b, alpha).m_5752_();
        consumer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        consumer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
    }

    public ResourceLocation getTextureLocation(FiveHundredKgExplosionEntity entity) {
        return FALLBACK_TEXTURE;
    }
}

