/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.render.model.AccessableRenderable;
import com.hbm.utils.EnumUtils;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;

public class RenderUtils {
    public static void renderBlockModel(BakedModel model, BlockState state, ModelBlockRenderer modelRenderer, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, RenderType renderType) {
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int i = blockColors.m_92577_(state, (BlockAndTintGetter)null, (BlockPos)null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        for (RenderType rt : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), (ModelData)null)) {
            modelRenderer.renderModel(pPoseStack.m_85850_(), pBuffer.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), state, model, f, f1, f2, pPackedLight, pPackedOverlay, ModelData.EMPTY, rt);
        }
    }

    public static void renderModel(BakedModel model, PoseStack pPose, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, RenderType renderType) {
        VertexConsumer buffer;
        if (renderType == null || (buffer = pBuffer.m_6299_(renderType)) == null) {
            return;
        }
        float pRed = 1.0f;
        float pGreen = 1.0f;
        float pBlue = 1.0f;
        BlockState dummyState = Blocks.f_50016_.m_49966_();
        RandomSource randomSource = RandomSource.m_216335_((long)42L);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            RenderUtils.renderQuadList(pPose.m_85850_(), buffer, pRed, pGreen, pBlue, model.m_213637_(dummyState, direction, randomSource), pPackedLight, pPackedOverlay);
        }
        RenderUtils.renderQuadList(pPose.m_85850_(), buffer, pRed, pGreen, pBlue, model.m_213637_(dummyState, (Direction)null, randomSource), pPackedLight, pPackedOverlay);
    }

    private static void renderQuadList(PoseStack.Pose pPose, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, List<BakedQuad> pQuads, int pPackedLight, int pPackedOverlay) {
        for (BakedQuad bakedquad : pQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.m_111304_()) {
                f = Mth.m_14036_((float)pRed, (float)0.0f, (float)1.0f);
                f1 = Mth.m_14036_((float)pGreen, (float)0.0f, (float)1.0f);
                f2 = Mth.m_14036_((float)pBlue, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            pConsumer.m_85987_(pPose, bakedquad, f, f1, f2, pPackedLight, pPackedOverlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderStandalone(PoseStack poseStack, RenderType renderType, AccessableRenderable.Component component, int lightmap, int overlay) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        try {
            VertexConsumer buffer = bufferSource.m_6299_(renderType);
            component.render(poseStack, buffer, lightmap, overlay);
        }
        finally {
            bufferSource.m_109911_();
        }
    }
}

