/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.blockentity;

import com.hbm.blockentity.machine.ChemplantEntity;
import com.hbm.render.RenderUtils;
import com.hbm.render.model.Models;
import com.hbm.utils.DirectionUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class ChemplantRenderer
implements BlockEntityRenderer<ChemplantEntity> {
    boolean running = true;
    public static BakedModel body_model;
    public static BakedModel piston_model;
    public static BakedModel spinner_model;

    public ChemplantRenderer(BlockEntityRendererProvider.Context pContext) {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        body_model = modelManager.getModel(Models.CHEMPLANT_BODY);
        piston_model = modelManager.getModel(Models.CHEMPLANT_PISTON);
        spinner_model = modelManager.getModel(Models.CHEMPLANT_SPINNER);
    }

    public void render(ChemplantEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = pBlockEntity.m_58900_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer modelRenderer = blockRenderer.m_110937_();
        this.running = pBlockEntity.progress > 0;
        pPoseStack.m_85836_();
        DirectionUtils.generalMachineRotate(pPoseStack, blockState);
        RenderUtils.renderBlockModel(body_model, blockState, modelRenderer, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, null);
        int rotation = (int)(System.currentTimeMillis() % 1800L) / 5;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(-0.625, 0.0, 0.625);
        if (this.running) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-rotation)));
        } else {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        }
        RenderUtils.renderBlockModel(spinner_model, blockState, modelRenderer, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, null);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.625, 0.0, 0.625);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(this.running ? (float)rotation : 45.0f));
        RenderUtils.renderBlockModel(spinner_model, blockState, modelRenderer, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, null);
        pPoseStack.m_85849_();
        double push = Math.sin((double)(System.currentTimeMillis() % 2000L) / 1000.0 * Math.PI) * 0.25 - 0.25;
        pPoseStack.m_85836_();
        if (this.running) {
            pPoseStack.m_85837_(0.0, push, 0.0);
        } else {
            pPoseStack.m_85837_(0.0, -0.25, 0.0);
        }
        RenderUtils.renderBlockModel(piston_model, blockState, modelRenderer, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, null);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
    }

    public void generalMachineRotate(PoseStack poseStack, Direction facing) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                poseStack.m_252880_(1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, 0.0f, -1.0f);
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                poseStack.m_252880_(1.0f, 0.0f, -1.0f);
            }
        }
    }
}

