/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.blockentity;

import com.hbm.blockentity.machine.tokamak.TokamakControllerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class TokamakRenderer
implements BlockEntityRenderer<TokamakControllerBlockEntity> {
    private static final ResourceLocation PLASMA_TEX = new ResourceLocation("hbm", "textures/effects/tokamak_plasma.png");

    public TokamakRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TokamakControllerBlockEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (tile == null) {
            return;
        }
        Level level = tile.m_58904_();
        if (level == null) {
            return;
        }
        float radius = tile.getPlasmaRadius();
        float brightness = tile.getBrightness();
        float instability = tile.getInstabilityFactor();
        float swirlSpeed = tile.getSwirlSpeed();
        float time = ((float)level.m_46467_() + partialTicks) * swirlSpeed * 0.02f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.6, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * 360.0f));
        poseStack.m_85841_(radius, radius * 0.6f, radius);
        RenderType type = RenderType.m_110436_((ResourceLocation)PLASMA_TEX, (float)time, (float)(time * 0.5f));
        VertexConsumer vc = buffer.m_6299_(type);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float alpha = Mth.m_14036_((float)(brightness + instability * 0.5f), (float)0.2f, (float)1.0f);
        float color = Mth.m_14036_((float)(0.5f + brightness), (float)0.5f, (float)1.0f);
        this.drawQuad(mat, vc, color, alpha, packedLight);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        mat = poseStack.m_85850_().m_252922_();
        this.drawQuad(mat, vc, color, alpha * 0.9f, packedLight);
        poseStack.m_85849_();
    }

    private void drawQuad(Matrix4f mat, VertexConsumer vc, float color, float alpha, int light) {
        vc.m_252986_(mat, -1.0f, 0.0f, -1.0f).m_85950_(color, color * 0.6f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(mat, -1.0f, 0.0f, 1.0f).m_85950_(color, color * 0.6f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(mat, 1.0f, 0.0f, 1.0f).m_85950_(color, color * 0.6f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(mat, 1.0f, 0.0f, -1.0f).m_85950_(color, color * 0.6f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

