/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.render.model.Models;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BlackHoleRender
extends EntityRenderer<EntityBlackHole> {
    public static BakedModel model_sphere;
    public static final ResourceLocation BLACK_HOLE_TEXTURE;
    public static final ResourceLocation SWIRL_TEXTURE;
    public static final ResourceLocation DISC_TEXTURE;
    public static final ResourceLocation DEFAULT_TEXTURE;

    public BlackHoleRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        model_sphere = modelManager.getModel(Models.BLACK_HOLE);
    }

    public void render(EntityBlackHole pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer modelRenderer = blockRenderer.m_110937_();
        pPoseStack.m_85836_();
        RenderType renderType = RenderType.m_110452_((ResourceLocation)BLACK_HOLE_TEXTURE);
        float size = pEntity.getSize();
        pPoseStack.m_85841_(size, size, size);
        modelRenderer.renderModel(pPoseStack.m_85850_(), pBuffer.m_6299_(renderType), null, model_sphere, 1.0f, 1.0f, 1.0f, pPackedLight, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        pPoseStack.m_85849_();
        this.renderJet(pEntity, pPoseStack, pBuffer);
        this.renderDisc(pEntity, pPoseStack, pBuffer, pPartialTick);
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(EntityBlackHole pEntity) {
        return null;
    }

    protected void renderJet(EntityBlackHole entity, PoseStack pPoseStack, MultiBufferSource pBuffer) {
        RenderSystem.enableBlend();
        pPoseStack.m_85836_();
        int id = entity.m_19879_();
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_((float)(id % 90 - 45)));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)(id % 360)));
        RenderType renderType = RenderType.m_110473_((ResourceLocation)DEFAULT_TEXTURE);
        BufferBuilder buffer = (BufferBuilder)pBuffer.m_6299_(renderType);
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f normal = pPoseStack.m_85850_().m_252943_();
        Vec3 jet = new Vec3(0.5, 0.0, 0.0);
        for (int j = -1; j <= 1; j += 2) {
            for (int i = 0; i < 12; ++i) {
                buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.35f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, (float)jet.f_82479_, (float)(5 * j), (float)jet.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                jet = jet.m_82524_((float)(0.5235987755982988 * (double)j));
                buffer.m_252986_(matrix4f, (float)jet.f_82479_, (float)(5 * j), (float)jet.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.35f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
        pPoseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    protected void renderDisc(EntityBlackHole entity, PoseStack pPoseStack, MultiBufferSource pBuffer, float pPartialTick) {
        float glow = 0.75f;
        int count = 16;
        int step = 15;
        Vec3 vec = new Vec3(1.0, 0.0, 0.0);
        pPoseStack.m_85836_();
        int id = entity.m_19879_();
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_((float)(id % 90 - 45)));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)(id % 360)));
        int overlayCoord = OverlayTexture.f_118083_;
        int light = 240;
        VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)DISC_TEXTURE));
        for (int i = 0; i < step; ++i) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(((float)entity.f_19797_ + pPartialTick % 360.0f) * -((float)Math.pow(i + 1, 1.25))));
            Matrix4f pose = pPoseStack.m_85850_().m_252922_();
            Matrix3f normal = pPoseStack.m_85850_().m_252943_();
            double s = 3.0 - (double)i * 0.175;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < count; ++k) {
                    ColorHolder color = j == 0 ? this.setColorFromIteration(i, 1.0f) : new ColorHolder(1.0f, 1.0f, 1.0f, glow);
                    buffer.m_252986_(pose, (float)(vec.f_82479_ * s), 0.0f, (float)(vec.f_82481_ * s)).m_85950_(color.r, color.g, color.b, color.alpha).m_7421_((float)(0.5 + vec.f_82479_ * 0.25), (float)(0.5 + vec.f_82481_ * 0.25)).m_86008_(overlayCoord).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                    color = this.setColorFromIteration(i, 0.0f);
                    buffer.m_252986_(pose, (float)(vec.f_82479_ * s * 2.0), 0.0f, (float)(vec.f_82481_ * s * 2.0)).m_85950_(color.r, color.g, color.b, color.alpha).m_7421_((float)(0.5 + vec.f_82479_ * 0.5), (float)(0.5 + vec.f_82481_ * 0.5)).m_86008_(overlayCoord).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                    vec = vec.m_82524_((float)(Math.PI * 2 / (double)count));
                    buffer.m_252986_(pose, (float)(vec.f_82479_ * s * 2.0), 0.0f, (float)(vec.f_82481_ * s * 2.0)).m_85950_(color.r, color.g, color.b, color.alpha).m_7421_((float)(0.5 + vec.f_82479_ * 0.5), (float)(0.5 + vec.f_82481_ * 0.5)).m_86008_(overlayCoord).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                    color = j == 0 ? this.setColorFromIteration(i, 1.0f) : new ColorHolder(1.0f, 1.0f, 1.0f, glow);
                    buffer.m_252986_(pose, (float)(vec.f_82479_ * s), 0.0f, (float)(vec.f_82481_ * s)).m_85950_(color.r, color.g, color.b, color.alpha).m_7421_((float)(0.5 + vec.f_82479_ * 0.25), (float)(0.5 + vec.f_82481_ * 0.25)).m_86008_(overlayCoord).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                }
            }
        }
        pPoseStack.m_85849_();
    }

    protected ColorHolder setColorFromIteration(int iteration, float alpha) {
        if (iteration < 5) {
            float g = 0.125f + (float)iteration * 0.1f;
            return new ColorHolder(1.0f, g, 0.0f, alpha);
        }
        if (iteration == 5) {
            return new ColorHolder(1.0f, 1.0f, 0.0f, alpha);
        }
        int i = iteration - 6;
        float r = 1.0f - (float)i * 0.11111111f;
        float g = 1.0f - (float)i * 0.11111111f;
        float b = (float)i * 0.2f;
        return new ColorHolder(r, g, b, alpha);
    }

    static {
        BLACK_HOLE_TEXTURE = new ResourceLocation("hbm", "textures/models/black_hole.png");
        SWIRL_TEXTURE = new ResourceLocation("hbm", "textures/entity/bhole.png");
        DISC_TEXTURE = new ResourceLocation("hbm", "textures/entity/bhole_d.png");
        DEFAULT_TEXTURE = new ResourceLocation("hbm", "textures/models/white_default_texture.png");
    }

    protected record ColorHolder(float r, float g, float b, float alpha) {
    }
}

