/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.EntityNukeTorex;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTorexRender
extends EntityRenderer<EntityNukeTorex> {
    public static final ResourceLocation TEXTURE_PARTICLE = new ResourceLocation("hbm", "textures/particle/hbm_smoke.png");
    public static final ResourceLocation TEXTURE_FLARE = new ResourceLocation("hbm", "textures/particle/flare.png");
    private Comparator cloudSorter = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            EntityNukeTorex.Cloudlet first = (EntityNukeTorex.Cloudlet)arg0;
            EntityNukeTorex.Cloudlet second = (EntityNukeTorex.Cloudlet)arg1;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            assert (player != null);
            double dist1 = player.m_20275_(first.posX, first.posY, first.posZ);
            double dist2 = player.m_20275_(second.posX, second.posY, second.posZ);
            return Double.compare(dist2, dist1);
        }
    };

    public EntityTorexRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(EntityNukeTorex pEntity) {
        return null;
    }

    public void render(EntityNukeTorex pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    private void cloudletWrapper(EntityNukeTorex cloud, PoseStack pPoseStack, MultiBufferSource pBuffer, float pPartialTick) {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252931_(pPoseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(GameRenderer::m_172829_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_PARTICLE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        ArrayList<EntityNukeTorex.Cloudlet> cloudlets = new ArrayList<EntityNukeTorex.Cloudlet>(cloud.cloudlets);
        cloudlets.sort(this.cloudSorter);
        for (EntityNukeTorex.Cloudlet cloudlet : cloudlets) {
            Vec3 vec = cloudlet.getInterpPos(pPartialTick);
            double x = vec.f_82479_ - cloud.m_20182_().f_82479_;
            double y = vec.f_82480_ - cloud.m_20182_().f_82480_;
            double z = vec.f_82481_ - cloud.m_20182_().f_82481_;
            this.tessellateCloudlet((VertexConsumer)buffer, x, y, z, cloudlet, pPartialTick);
        }
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        posestack.m_85849_();
    }

    private void tessellateCloudlet(VertexConsumer buffer, double posX, double posY, double posZ, EntityNukeTorex.Cloudlet cloud, float pPartialTicks) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 vec3 = camera.m_90583_();
        Quaternionf rotation = camera.m_253121_();
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f = (float)(posX - vec3.m_7096_());
        float f1 = (float)(posY - vec3.m_7098_());
        float f2 = (float)(posZ - vec3.m_7094_());
        float alpha = cloud.getAlpha();
        float scale = cloud.getScale();
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(scale);
            vector3f.add(f, f1, f2);
        }
        EntityNukeTorex.TorexType cfr_ignored_0 = cloud.type;
        float brightness = cloud.type == EntityNukeTorex.TorexType.CONDENSATION ? 0.9f : 0.75f * cloud.colorMod;
        Vec3 color = cloud.getInterpColor(pPartialTicks).m_82490_(255.0);
        color = color.m_82490_((double)brightness);
        buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(1.0f, 1.0f).m_85950_((float)((int)color.f_82479_), (float)((int)color.f_82480_), (float)((int)color.f_82481_), alpha).m_85969_((int)brightness).m_5752_();
        buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(1.0f, 0.0f).m_85950_((float)((int)color.f_82479_), (float)((int)color.f_82480_), (float)((int)color.f_82481_), alpha).m_85969_((int)brightness).m_5752_();
        buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(0.0f, 0.0f).m_85950_((float)((int)color.f_82479_), (float)((int)color.f_82480_), (float)((int)color.f_82481_), alpha).m_85969_((int)brightness).m_5752_();
        buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(0.0f, 1.0f).m_85950_((float)((int)color.f_82479_), (float)((int)color.f_82480_), (float)((int)color.f_82481_), alpha).m_85969_((int)brightness).m_5752_();
    }
}

