/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;
import org.joml.Quaternionf;

public class AccessableRenderable {
    public Function<ResourceLocation, RenderType> renderType;
    public Map<String, Component> components = new HashMap<String, Component>();

    public AccessableRenderable(CompositeRenderable renderable) {
        this(renderable, RenderType::m_110458_);
    }

    public AccessableRenderable(CompositeRenderable renderable, Function<ResourceLocation, RenderType> renderType) {
        this.renderType = renderType;
        try {
            Class<CompositeRenderable> classRenderable = CompositeRenderable.class;
            Field field_components = classRenderable.getDeclaredField("components");
            field_components.setAccessible(true);
            Class<?>[] declaredClasses = classRenderable.getDeclaredClasses();
            Class<?> classComponent = null;
            Class<?> classMesh = null;
            for (Class<?> declaredClass : declaredClasses) {
                if (declaredClass.getName().contains("Component")) {
                    classComponent = declaredClass;
                    continue;
                }
                if (!declaredClass.getName().contains("Mesh")) continue;
                classMesh = declaredClass;
            }
            if (classComponent != null && classMesh != null) {
                Field field_name = classComponent.getDeclaredField("name");
                Field field_chlidren = classComponent.getDeclaredField("children");
                Field field_meshes = classComponent.getDeclaredField("meshes");
                Field field_texture = classMesh.getDeclaredField("texture");
                Field field_quads = classMesh.getDeclaredField("quads");
                field_name.setAccessible(true);
                field_chlidren.setAccessible(true);
                field_meshes.setAccessible(true);
                field_texture.setAccessible(true);
                field_quads.setAccessible(true);
                List list1 = (List)field_components.get(renderable);
                for (Object o : list1) {
                    Object object;
                    if (!classComponent.isInstance(o) || !((object = field_name.get(o)) instanceof String)) continue;
                    String name = (String)object;
                    this.components.put(name, AccessableRenderable.parseComponent(o, new Component(this.renderType), classComponent, classMesh, field_name, field_chlidren, field_meshes, field_texture, field_quads));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Component parseComponent(Object o, Component component, Class<?> classComponent, Class<?> classMesh, Field field_name, Field field_chlidren, Field field_meshes, Field field_texture, Field field_quads) throws IllegalAccessException {
        Object object;
        if (classComponent.isInstance(o) && (object = field_name.get(o)) instanceof String) {
            String name;
            component.name = name = (String)object;
            Iterator iterator = field_meshes.get(o);
            if (iterator instanceof List) {
                List meshes = (List)((Object)iterator);
                iterator = meshes.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    Object mesh = iterator.next();
                    if (!classMesh.isInstance(mesh) || !((object2 = field_texture.get(mesh)) instanceof ResourceLocation)) continue;
                    ResourceLocation texture = (ResourceLocation)object2;
                    object2 = field_quads.get(mesh);
                    if (!(object2 instanceof List)) continue;
                    List quads = (List)object2;
                    if (!(field_quads.getGenericType() instanceof ParameterizedType) || ((ParameterizedType)field_quads.getGenericType()).getActualTypeArguments()[0] != BakedQuad.class) continue;
                    component.meshes.add(new Mesh(texture, quads));
                }
            }
            if ((iterator = field_chlidren.get(o)) instanceof List) {
                List children = (List)((Object)iterator);
                if (children.isEmpty()) {
                    return component;
                }
                for (Object child : children) {
                    Object object3;
                    if (!classComponent.isInstance(child) || !((object3 = field_name.get(child)) instanceof String)) continue;
                    String nameInner = (String)object3;
                    component.children.put(nameInner, AccessableRenderable.parseComponent(child, new Component(component.getRenderType()), classComponent, classMesh, field_name, field_chlidren, field_meshes, field_texture, field_quads));
                }
            }
        } else {
            return component;
        }
        return component;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation rl, int lightmap, int overlay, float partialTick) {
        this.render(poseStack, bufferSource, (ResourceLocation)this.renderType, lightmap, overlay, partialTick);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick) {
        for (Component component : this.components.values()) {
            component.render(poseStack, bufferSource.m_6299_(textureRenderTypeLookup.get(null)), lightmap, overlay);
        }
    }

    public static class Component
    extends Model {
        public String name;
        public Map<String, Component> children = new HashMap<String, Component>();
        public List<Mesh> meshes = new ArrayList<Mesh>();
        public float x = 0.0f;
        public float y = 0.0f;
        public float z = 0.0f;
        public float xRot = 0.0f;
        public float yRot = 0.0f;
        public float zRot = 0.0f;
        public float xScale = 1.0f;
        public float yScale = 1.0f;
        public float zScale = 1.0f;
        public boolean visible = true;
        public float xRotPoint = 0.0f;
        public float yRotPoint = 0.0f;
        public float zRotPoint = 0.0f;

        public Component(Function<ResourceLocation, RenderType> renderType) {
            super(renderType);
        }

        public Component copyPose(ModelPart modelPart) {
            this.x = modelPart.f_104200_;
            this.y = modelPart.f_104201_;
            this.z = modelPart.f_104202_;
            this.xRot = modelPart.f_104203_;
            this.yRot = modelPart.f_104204_;
            this.zRot = modelPart.f_104205_;
            this.xScale = modelPart.f_233553_;
            this.yScale = modelPart.f_233554_;
            this.zScale = modelPart.f_233555_;
            this.visible = modelPart.f_104207_;
            return this;
        }

        public Component setRotPoint(float x, float y, float z) {
            this.xRotPoint = x;
            this.yRotPoint = y;
            this.zRotPoint = z;
            return this;
        }

        public Component resetX() {
            this.x = 0.0f;
            return this;
        }

        public Component resetY() {
            this.y = 0.0f;
            return this;
        }

        public Component resetZ() {
            this.z = 0.0f;
            return this;
        }

        public Component adjXYZ(float xDelta, float yDelta, float zDelta) {
            this.x += xDelta;
            this.y += yDelta;
            this.z += zDelta;
            return this;
        }

        public Function<ResourceLocation, RenderType> getRenderType() {
            return this.f_103106_;
        }

        public void render(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
            if (this.visible) {
                poseStack.m_85836_();
                poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
                if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
                    poseStack.m_252880_(this.xRotPoint / 16.0f, this.yRotPoint / 16.0f, this.zRotPoint / 16.0f);
                    poseStack.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
                    poseStack.m_252880_(-this.xRotPoint / 16.0f, -this.yRotPoint / 16.0f, -this.zRotPoint / 16.0f);
                }
                poseStack.m_85841_(this.xScale / 16.0f, this.yScale / 16.0f, this.zScale / 16.0f);
                for (Component part : this.children.values()) {
                    part.render(poseStack, consumer, lightmap, overlay);
                }
                for (Mesh mesh : this.meshes) {
                    mesh.render(poseStack, consumer, lightmap, overlay);
                }
                poseStack.m_85849_();
            }
        }

        public void renderGUI(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
            poseStack.m_85836_();
            for (Component part : this.children.values()) {
                part.render(poseStack, consumer, lightmap, overlay);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, consumer, lightmap, overlay);
            }
            poseStack.m_85849_();
        }

        public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        }
    }

    public static class Mesh {
        public final ResourceLocation texture;
        public final List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public Mesh(ResourceLocation texture) {
            this.texture = texture;
        }

        public Mesh(ResourceLocation texture, List<BakedQuad> quads) {
            this.texture = texture;
            this.quads.addAll(quads);
        }

        public void render(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
            for (BakedQuad quad : this.quads) {
                consumer.putBulkData(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, lightmap, overlay, true);
            }
        }
    }
}

