/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BaseObjModel
extends Model {
    private static final Logger LOGGER = LogManager.getLogger((String)"HBM-ObjModel");
    public String name;
    private String modelIdentifier = "unknown";
    public Map<String, BaseObjModel> children = new HashMap<String, BaseObjModel>();
    public List<Mesh> meshes = new ArrayList<Mesh>();
    public RenderType tempRenderType;
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float xRot = 0.0f;
    public float yRot = 0.0f;
    public float zRot = 0.0f;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public boolean visible = true;
    public float xRotPoint = 0.0f;
    public float yRotPoint = 0.0f;
    public float zRotPoint = 0.0f;
    public float size = 16.0f;

    public BaseObjModel(Function<ResourceLocation, RenderType> pRenderType) {
        this(pRenderType, "");
    }

    public BaseObjModel(BaseObjModel root, String name) {
        this(root.f_103106_, name);
        this.modelIdentifier = root.modelIdentifier;
    }

    public BaseObjModel(Function<ResourceLocation, RenderType> pRenderType, String name) {
        super(pRenderType);
        this.name = name;
    }

    public static BaseObjModel create(ResourceLocation jsonPath, Function<ResourceLocation, RenderType> renderType) {
        BaseObjModel baseObjModel;
        Gson gson = new Gson();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Resource resource = resourceManager.m_215593_(jsonPath.m_266382_(".json"));
        InputStreamReader reader = new InputStreamReader(resource.m_215507_());
        try {
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ObjModel objModel = ObjLoader.INSTANCE.read(jsonObject, null);
            HashMap<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
            if (jsonObject.has("texture0")) {
                textureMap.put("#texture0", new ResourceLocation(jsonObject.get("texture0").getAsString()));
            }
            if (jsonObject.has("#layer0")) {
                textureMap.put("#layer0", new ResourceLocation(jsonObject.get("layer0").getAsString()));
            }
            CompositeRenderable renderable = objModel.bakeRenderable((IGeometryBakingContext)StandaloneGeometryBakingContext.create(textureMap));
            BaseObjModel model = BaseObjModel.create(renderable, renderType);
            model.setModelIdentifier(jsonPath.toString());
            baseObjModel = model;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseObjModel fallback = new BaseObjModel(renderType);
                fallback.setModelIdentifier(jsonPath.toString());
                return fallback;
            }
        }
        reader.close();
        return baseObjModel;
    }

    public static BaseObjModel create(CompositeRenderable renderable, Function<ResourceLocation, RenderType> renderType) {
        BaseObjModel model = new BaseObjModel(renderType);
        model.setModelIdentifier(renderable.toString());
        try {
            Class<CompositeRenderable> classRenderable = CompositeRenderable.class;
            Field field_components = classRenderable.getDeclaredField("components");
            field_components.setAccessible(true);
            Class<?>[] declaredClasses = classRenderable.getDeclaredClasses();
            Class<?> classComponent = null;
            Class<?> classMesh = null;
            for (Class<?> declaredClass : declaredClasses) {
                if (declaredClass.getName().contains("Component")) {
                    classComponent = declaredClass;
                    continue;
                }
                if (!declaredClass.getName().contains("Mesh")) continue;
                classMesh = declaredClass;
            }
            if (classComponent != null && classMesh != null) {
                Field field_name = classComponent.getDeclaredField("name");
                Field field_chlidren = classComponent.getDeclaredField("children");
                Field field_meshes = classComponent.getDeclaredField("meshes");
                Field field_texture = classMesh.getDeclaredField("texture");
                Field field_quads = classMesh.getDeclaredField("quads");
                field_name.setAccessible(true);
                field_chlidren.setAccessible(true);
                field_meshes.setAccessible(true);
                field_texture.setAccessible(true);
                field_quads.setAccessible(true);
                List list1 = (List)field_components.get(renderable);
                for (Object o : list1) {
                    Object object;
                    if (!classComponent.isInstance(o) || !((object = field_name.get(o)) instanceof String)) continue;
                    String name = (String)object;
                    model.children.put(name, BaseObjModel.parseComponent(o, new BaseObjModel(model, name), classComponent, classMesh, field_name, field_chlidren, field_meshes, field_texture, field_quads));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static BaseObjModel parseComponent(Object o, BaseObjModel component, Class<?> classComponent, Class<?> classMesh, Field field_name, Field field_chlidren, Field field_meshes, Field field_texture, Field field_quads) throws IllegalAccessException {
        Object object;
        if (classComponent.isInstance(o) && (object = field_name.get(o)) instanceof String) {
            String name;
            component.name = name = (String)object;
            Iterator iterator = field_meshes.get(o);
            if (iterator instanceof List) {
                List meshes = (List)((Object)iterator);
                iterator = meshes.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    Object mesh = iterator.next();
                    if (!classMesh.isInstance(mesh) || !((object2 = field_texture.get(mesh)) instanceof ResourceLocation)) continue;
                    ResourceLocation texture = (ResourceLocation)object2;
                    object2 = field_quads.get(mesh);
                    if (!(object2 instanceof List)) continue;
                    List quads = (List)object2;
                    if (!(field_quads.getGenericType() instanceof ParameterizedType) || ((ParameterizedType)field_quads.getGenericType()).getActualTypeArguments()[0] != BakedQuad.class) continue;
                    component.meshes.add(new Mesh(texture, quads));
                }
            }
            if ((iterator = field_chlidren.get(o)) instanceof List) {
                List children = (List)((Object)iterator);
                if (children.isEmpty()) {
                    return component;
                }
                for (Object child : children) {
                    Object object3;
                    if (!classComponent.isInstance(child) || !((object3 = field_name.get(child)) instanceof String)) continue;
                    String nameInner = (String)object3;
                    component.children.put(nameInner, BaseObjModel.parseComponent(child, new BaseObjModel(component, nameInner), classComponent, classMesh, field_name, field_chlidren, field_meshes, field_texture, field_quads));
                }
            }
        } else {
            return component;
        }
        return component;
    }

    public BaseObjModel getChild(String name) {
        if (name == null) {
            LOGGER.warn("OBJ model '{}' attempted to lookup null child.", (Object)this.modelIdentifier);
            return this.createPlaceholderChild("null-child");
        }
        BaseObjModel child = this.children.get(name);
        if (child == null) {
            LOGGER.warn("OBJ model '{}' missing child '{}', creating empty placeholder.", (Object)this.modelIdentifier, (Object)name);
            child = this.createPlaceholderChild(name);
            this.children.put(name, child);
        }
        return child;
    }

    public BaseObjModel addChild(String name, BaseObjModel child) {
        this.children.put(name, child);
        return this;
    }

    public BaseObjModel popChild(String name) {
        BaseObjModel child = this.children.remove(name);
        if (child == null) {
            LOGGER.warn("OBJ model '{}' failed to pop missing child '{}'; returning placeholder.", (Object)this.modelIdentifier, (Object)name);
            return this.createPlaceholderChild(name == null ? "null-child" : name);
        }
        return child;
    }

    public BaseObjModel copyPose(ModelPart modelPart) {
        this.x = modelPart.f_104200_;
        this.y = modelPart.f_104201_;
        this.z = modelPart.f_104202_;
        this.xRot = modelPart.f_104203_;
        this.yRot = modelPart.f_104204_;
        this.zRot = modelPart.f_104205_;
        this.xScale = modelPart.f_233553_;
        this.yScale = modelPart.f_233554_;
        this.zScale = modelPart.f_233555_;
        this.visible = modelPart.f_104207_;
        return this;
    }

    public BaseObjModel setRotPoint(float x, float y, float z) {
        this.xRotPoint = x;
        this.yRotPoint = y;
        this.zRotPoint = z;
        return this;
    }

    public BaseObjModel resetX() {
        this.x = 0.0f;
        return this;
    }

    public BaseObjModel resetY() {
        this.y = 0.0f;
        return this;
    }

    public BaseObjModel resetZ() {
        this.z = 0.0f;
        return this;
    }

    public BaseObjModel adjXYZ(float xDelta, float yDelta, float zDelta, String ... names) {
        this.x += xDelta;
        this.y += yDelta;
        this.z += zDelta;
        if (names == null || names.length == 0) {
            return this;
        }
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            BaseObjModel child = this.children.get(name);
            if (child == null) {
                LOGGER.warn("BaseObjModel.adjXYZ: group '{}' not found in model '{}', skipping.", (Object)name, (Object)this.modelIdentifier);
                continue;
            }
            child.adjXYZ(xDelta, yDelta, zDelta, new String[0]);
        }
        return this;
    }

    public BaseObjModel setRot(float xRot, float yRot, float zRot) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
        return this;
    }

    public BaseObjModel scale(float xScale, float yScale, float zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
        return this;
    }

    public BaseObjModel scale(float scale) {
        this.yScale = this.zScale = scale;
        this.xScale = this.zScale;
        this.children.forEach((n, child) -> child.scale(scale));
        return this;
    }

    public BaseObjModel visible(boolean visible, String ... names) {
        if (names.length == 0) {
            this.visible = visible;
        } else {
            for (String name : names) {
                BaseObjModel child = this.getChildSafe(name, "visible");
                if (child == null) continue;
                child.visible(visible, names);
            }
        }
        return this;
    }

    public BaseObjModel size(float size, String ... names) {
        this.size = size;
        if (names.length == 0) {
            this.children.values().forEach(child -> child.size(size, new String[0]));
        } else {
            for (String name : names) {
                BaseObjModel child2 = this.getChildSafe(name, "size");
                if (child2 == null) continue;
                child2.size(size, new String[0]);
            }
        }
        return this;
    }

    public BaseObjModel bindTexture(ResourceLocation texture) {
        return this.bindRenderType(this.m_103119_(texture));
    }

    public BaseObjModel bindRenderType(RenderType renderType) {
        this.tempRenderType = renderType;
        return this;
    }

    private BaseObjModel getChildSafe(String childName, String action) {
        BaseObjModel child = this.children.get(childName);
        if (child == null) {
            LOGGER.warn("OBJ model '{}' missing child '{}', skipping {}.", (Object)this.modelIdentifier, (Object)childName, (Object)action);
        }
        return child;
    }

    public void setModelIdentifier(String identifier) {
        this.modelIdentifier = identifier;
    }

    public String getModelIdentifier() {
        return this.modelIdentifier;
    }

    private BaseObjModel createPlaceholderChild(String name) {
        BaseObjModel placeholder = new BaseObjModel(this, name == null ? "missing" : name);
        placeholder.setModelIdentifier(this.modelIdentifier + "::missing::" + name);
        return placeholder;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick, CompositeRenderable.Transforms context) {
        this.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, context);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, CompositeRenderable.Transforms context) {
        Matrix4f matrix = context.getTransform(this.name);
        if (matrix != null) {
            poseStack.m_85836_();
            poseStack.m_252931_(matrix);
        }
        for (BaseObjModel part : this.children.values()) {
            part.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, context);
        }
        for (Mesh mesh : this.meshes) {
            mesh.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay);
        }
        if (matrix != null) {
            poseStack.m_85849_();
        }
    }

    public void renderStatic(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
        poseStack.m_85836_();
        for (BaseObjModel part : this.children.values()) {
            part.renderToBuffer(poseStack, consumer, lightmap, overlay);
        }
        for (Mesh mesh : this.meshes) {
            mesh.render(poseStack, consumer, lightmap, overlay);
        }
        poseStack.m_85849_();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
        this.m_7695_(poseStack, consumer, lightmap, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer consumer, int lightmap, int overlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        if (this.visible) {
            poseStack.m_85836_();
            poseStack.m_252880_(this.x / this.size, this.y / this.size, this.z / this.size);
            if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
                poseStack.m_252880_(this.xRotPoint, this.yRotPoint, this.zRotPoint);
                poseStack.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
                poseStack.m_252880_(-this.xRotPoint, -this.yRotPoint, -this.zRotPoint);
            }
            poseStack.m_85841_(this.xScale / this.size, this.yScale / this.size, this.zScale / this.size);
            if (this.tempRenderType == null) {
                for (BaseObjModel part : this.children.values()) {
                    part.m_7695_(poseStack, consumer, lightmap, overlay, pRed, pGreen, pBlue, pAlpha);
                }
                for (Mesh mesh : this.meshes) {
                    mesh.render(poseStack, consumer, lightmap, overlay, pRed, pGreen, pBlue, pAlpha);
                }
            } else {
                MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                try {
                    VertexConsumer consumer1 = bufferSource.m_6299_(this.tempRenderType);
                    for (BaseObjModel part : this.children.values()) {
                        part.m_7695_(poseStack, consumer1, lightmap, overlay, pRed, pGreen, pBlue, pAlpha);
                    }
                    for (Mesh mesh : this.meshes) {
                        mesh.render(poseStack, consumer1, lightmap, overlay, pRed, pGreen, pBlue, pAlpha);
                    }
                }
                finally {
                    bufferSource.m_109911_();
                }
            }
            poseStack.m_85849_();
        }
        this.tempRenderType = null;
    }

    public static void renderItem(BaseObjModel model, ResourceLocation texture, float size, float xOffset, float yOffset, float zOffset, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        float scale = 0.625f / size;
        float xRot = 30.0f;
        float yRot = 225.0f;
        if (pDisplayContext == ItemDisplayContext.GROUND) {
            yRot = 0.0f;
            xRot = 0.0f;
            scale = 0.25f / size;
        } else if (pDisplayContext == ItemDisplayContext.FIXED) {
            yRot = 0.0f;
            xRot = 0.0f;
            scale = 0.5f / size;
        } else if (pDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            xRot = 75.0f;
            yRot = 45.0f;
            scale = 0.375f / size;
        } else if (pDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            xRot = 75.0f;
            scale = 0.375f / size;
        } else if (pDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            yRot = 45.0f;
            scale = 0.4f / size;
        } else if (pDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            scale = 0.4f / size;
        }
        pPoseStack.m_252880_(xOffset, yOffset, zOffset);
        pPoseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
        pPoseStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
        pPoseStack.m_85841_(scale, scale, scale);
        VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        model.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
    }

    public static class Mesh {
        public ResourceLocation texture;
        public final List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public Mesh(ResourceLocation texture) {
            this.texture = texture;
        }

        public Mesh(ResourceLocation texture, List<BakedQuad> quads) {
            this.texture = texture;
            this.quads.addAll(quads);
        }

        public void render(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay) {
            this.render(poseStack, consumer, lightmap, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        public void render(PoseStack poseStack, VertexConsumer consumer, int lightmap, int overlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            for (BakedQuad quad : this.quads) {
                consumer.putBulkData(poseStack.m_85850_(), quad, pRed, pGreen, pBlue, pAlpha, lightmap, overlay, true);
            }
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay) {
            VertexConsumer consumer = bufferSource.m_6299_(textureRenderTypeLookup.get(this.texture));
            for (BakedQuad quad : this.quads) {
                consumer.putBulkData(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, lightmap, overlay, true);
            }
        }
    }
}

