/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model;

import com.hbm.HBM;
import com.hbm.item.HBMWeapon;
import com.hbm.render.model.IObjModel;
import com.hbm.render.model.armor.ModelArmorAJR;
import com.hbm.render.model.armor.ModelArmorBJ;
import com.hbm.render.model.armor.ModelArmorBismuth;
import com.hbm.render.model.armor.ModelArmorDesh;
import com.hbm.render.model.armor.ModelArmorDiesel;
import com.hbm.render.model.armor.ModelArmorRPA;
import com.hbm.render.model.armor.ModelArmorT51;
import com.hbm.render.model.entity.ModelGlyphid;
import com.hbm.render.model.entity.ObjEntityModelSingle;
import com.hbm.render.model.item.SimpleBakedModelWrapper;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Models {
    private static final Set<ResourceLocation> models = new HashSet<ResourceLocation>();
    private static final ConcurrentMap<ResourceLocation, ResourceLocation> ITEM_MODEL_KEYS = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();
    private static final ConcurrentMap<ResourceLocation, WeakReference<Model>> ENTITY_MODELS = new ConcurrentHashMap<ResourceLocation, WeakReference<Model>>();
    private static final ConcurrentMap<ResourceLocation, Supplier<Model>> ENTITY_MODEL_FACTORIES = new ConcurrentHashMap<ResourceLocation, Supplier<Model>>();
    public static final ResourceLocation ASSEMBLER_BODY = Models.add(HBM.rl("block/assembler/assembler_body"));
    public static final ResourceLocation ASSEMBLER_COG = Models.add(HBM.rl("block/assembler/assembler_cog"));
    public static final ResourceLocation ASSEMBLER_SLIDER = Models.add(HBM.rl("block/assembler/assembler_slider"));
    public static final ResourceLocation ASSEMBLER_ARM = Models.add(HBM.rl("block/assembler/assembler_arm"));
    public static final ResourceLocation CRUCIBLE = Models.add(HBM.rl("block/crucible/crucible"));
    public static final ResourceLocation FAT_MAN = Models.add(HBM.rl("block/bomb/fat_man"));
    public static final ResourceLocation BOY = Models.add(HBM.rl("block/bomb/boy"));
    public static final ResourceLocation CUSTOM_NUKE = Models.add(HBM.rl("block/bomb/custom"));
    public static final ResourceLocation BLACK_HOLE = Models.add(HBM.rl("block/effect/sphere"));
    public static final ResourceLocation CHEMPLANT_BODY = Models.add(HBM.rl("block/chemplant/chemplant_new_body"));
    public static final ResourceLocation CHEMPLANT_PISTON = Models.add(HBM.rl("block/chemplant/chemplant_new_piston"));
    public static final ResourceLocation CHEMPLANT_SPINNER = Models.add(HBM.rl("block/chemplant/chemplant_new_spinner"));
    public static final ResourceLocation LAUNCH_PAD = Models.add(HBM.rl("block/launch_pad"));
    public static final ResourceLocation WOOD_BURNER = Models.add(HBM.rl("block/machine_wood_burner"));
    public static final ResourceLocation ZIRNOX_BASE = Models.add(HBM.rl("block/reactor/zirnox"));
    public static final ResourceLocation RESEARCH_REACTOR_BASE = Models.add(HBM.rl("block/reactor/reactor_small_base"));
    public static final ResourceLocation RESEARCH_REACTOR_RODS = Models.add(HBM.rl("block/reactor/reactor_small_rods"));
    public static final ResourceLocation BREEDER_REACTOR = Models.add(HBM.rl("block/reactor/breeder"));
    public static final ResourceLocation MP_W_15_BALEFIRE = Models.addItem(HBM.rl("item/mp_warhead_15_balefire"), HBMWeapon.MP_WARHEAD_15_BALEFIRE);
    public static final ResourceLocation MISSILE_TEST = Models.addEntity(HBM.modelRl("entity/missile/missile_test"), ObjEntityModelSingle::new);
    public static final ResourceLocation MISSILE_NUKE = Models.addEntity(HBM.rl("entity/missile_nuclear"), ObjEntityModelSingle::new);
    public static final ResourceLocation T51 = Models.addEntity(HBM.modelRl("item/armor_t51"), ModelArmorT51::new);
    public static final ResourceLocation BISMUTH = Models.addEntity(HBM.modelRl("item/armor_bismuth"), ModelArmorBismuth::new);
    public static final ResourceLocation DESH = Models.addEntity(HBM.modelRl("item/armor_desh"), ModelArmorDesh::new);
    public static final ResourceLocation DIESEL = Models.addEntity(HBM.modelRl("item/armor_diesel"), ModelArmorDiesel::new);
    public static final ResourceLocation RPA = Models.addEntity(HBM.modelRl("item/armor_rpa"), ModelArmorRPA::new);
    public static final ResourceLocation AJR = Models.addEntity(HBM.modelRl("item/armor_ajr"), ModelArmorAJR::new);
    public static final ResourceLocation BJ = Models.addEntity(HBM.modelRl("item/armor_bj"), ModelArmorBJ::new);
    public static final ResourceLocation GLYPHID = Models.addEntity(HBM.modelRl("entity/glyphid"), ModelGlyphid::new);

    public static ResourceLocation add(ResourceLocation rl) {
        models.add(rl);
        return rl;
    }

    public static ResourceLocation addItem(ResourceLocation rl, RegistryObject<Item> itemRegistryObject) {
        models.add(rl);
        ITEM_MODEL_KEYS.put(rl, itemRegistryObject.getId());
        return rl;
    }

    public static ResourceLocation addEntity(ResourceLocation rl, Supplier<Model> modelFactory) {
        ENTITY_MODEL_FACTORIES.put(rl, modelFactory);
        Model model = Models.buildEntityModel(rl, modelFactory);
        if (model != null) {
            ENTITY_MODELS.put(rl, new WeakReference<Model>(model));
        }
        return rl;
    }

    public static void registerModels(ModelEvent.RegisterAdditional event) {
        models.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                Models.reloadEntityModels();
            }
            catch (Exception e) {
                HBM.LOGGER.error("Failed to preload entity models", (Throwable)e);
            }
        });
    }

    public static void modifyBakingResult(ModelEvent.ModifyBakingResult event) {
        ITEM_MODEL_KEYS.forEach((rl, itemId) -> {
            BakedModel bakedModel = (BakedModel)event.getModels().get(rl);
            if (bakedModel instanceof SimpleBakedModel) {
                event.getModels().put(new ModelResourceLocation(itemId, "inventory"), new SimpleBakedModelWrapper((SimpleBakedModel)bakedModel));
            }
        });
    }

    public static BakedModel get(ResourceLocation rl) {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        return modelManager.getModel(rl);
    }

    public static Model getEntityModel(ResourceLocation rl) {
        Model model;
        WeakReference ref = (WeakReference)ENTITY_MODELS.get(rl);
        Model model2 = model = ref != null ? (Model)ref.get() : null;
        if (model == null) {
            model = Models.rebuildEntityModel(rl);
        } else {
            Models.prepareModel(rl, model);
        }
        return model;
    }

    private static void clearCaches(String reason) {
        ITEM_MODEL_KEYS.clear();
        ENTITY_MODELS.clear();
        HBM.LOGGER.debug("[Models] caches cleared due to {}", (Object)reason);
    }

    @SubscribeEvent
    public static void onBakingCompleted(ModelEvent.BakingCompleted e) {
        Models.clearCaches("BakingCompleted");
        Models.reloadEntityModels();
    }

    private static Model buildEntityModel(ResourceLocation rl, Supplier<Model> modelFactory) {
        Model model = modelFactory.get();
        Models.prepareModel(rl, model);
        return model;
    }

    private static Model rebuildEntityModel(ResourceLocation rl) {
        Supplier factory = (Supplier)ENTITY_MODEL_FACTORIES.get(rl);
        if (factory == null) {
            return null;
        }
        Model model = Models.buildEntityModel(rl, factory);
        if (model != null) {
            ENTITY_MODELS.put(rl, new WeakReference<Model>(model));
        }
        return model;
    }

    private static void reloadEntityModels() {
        ENTITY_MODELS.clear();
        ENTITY_MODEL_FACTORIES.keySet().forEach(Models::rebuildEntityModel);
    }

    private static void prepareModel(ResourceLocation rl, Model model) {
        if (!(model instanceof IObjModel)) {
            return;
        }
        IObjModel objModel = (IObjModel)model;
        if (objModel.getRootModel() != null) {
            return;
        }
        Minecraft minecraft = Models.safeGetMinecraft();
        if (minecraft == null) {
            return;
        }
        ResourceManager resourceManager = minecraft.m_91098_();
        if (resourceManager == null) {
            return;
        }
        ResourceLocation jsonPath = rl.m_266382_(".json");
        if (resourceManager.m_213713_(jsonPath).isEmpty()) {
            HBM.LOGGER.debug("[Models] Resource {} not ready; postpone parsing", (Object)jsonPath);
            return;
        }
        objModel.parseJson(rl);
    }

    private static Minecraft safeGetMinecraft() {
        try {
            return Minecraft.m_91087_();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeSideHooks {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut e) {
            Models.clearCaches("ClientDisconnect");
        }

        @SubscribeEvent
        public static void onRegisterReload(RegisterClientReloadListenersEvent e) {
            e.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

                protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                    return null;
                }

                protected void apply(Void data, ResourceManager resourceManager, ProfilerFiller profiler) {
                    Models.clearCaches("ReloadListener");
                    Models.reloadEntityModels();
                }
            });
        }
    }
}

