/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model.armor;

import com.hbm.render.model.BaseObjModel;
import com.hbm.render.model.IObjModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelArmorBase<T extends LivingEntity>
extends HumanoidArmorModel<T>
implements IObjModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"HBM-ModelArmor");
    static ModelPart EMPTY = new ModelPart(List.of(), Map.of());
    static ModelPart DUMMY_HUMANOID = new ModelPart(List.of(), Map.of("head", EMPTY, "hat", EMPTY, "body", EMPTY, "right_arm", EMPTY, "left_arm", EMPTY, "right_leg", EMPTY, "left_leg", EMPTY));
    public BaseObjModel rootModel;
    public List<String> names = new ArrayList<String>();
    public BaseObjModel chead;
    public BaseObjModel cbody;
    public BaseObjModel cleftArm;
    public BaseObjModel crightArm;
    public BaseObjModel cleftLeg;
    public BaseObjModel crightLeg;
    public BaseObjModel cleftFoot;
    public BaseObjModel crightFoot;
    protected ResourceLocation armTexExtra = null;

    public ModelArmorBase(String ... strings) {
        super(DUMMY_HUMANOID);
        this.names.addAll(Arrays.stream(strings).toList());
    }

    @Override
    public BaseObjModel getRootModel() {
        return this.rootModel;
    }

    public BaseObjModel getComponent(String name) {
        if (this.rootModel == null) {
            LOGGER.error("ModelArmorBase attempted to access component '{}' before model initialization.", (Object)name);
            BaseObjModel placeholder = new BaseObjModel(RenderType::m_110431_, name);
            placeholder.setModelIdentifier("armor::placeholder::" + name);
            return placeholder;
        }
        return this.rootModel.getChild(name);
    }

    @Override
    public void parseJson(ResourceLocation jsonPath) {
        this.rootModel = BaseObjModel.create(jsonPath, RenderType::m_110431_);
        this.initializeParts();
    }

    public void initializeParts() {
        this.chead = this.getComponent(this.names.get(0));
        this.cbody = this.getComponent(this.names.get(1));
        this.cleftArm = this.getComponent(this.names.get(2)).setRotPoint(0.0f, 2.2f, 2.5f);
        this.crightArm = this.getComponent(this.names.get(3)).setRotPoint(0.0f, 2.0f, 2.0f);
        this.cleftLeg = this.getComponent(this.names.get(4)).setRotPoint(0.0f, 12.0f, 0.0f);
        this.crightLeg = this.getComponent(this.names.get(5)).setRotPoint(0.0f, 12.0f, 0.0f);
        if (this.names.size() >= 7) {
            this.cleftFoot = this.getComponent(this.names.get(6)).setRotPoint(0.0f, 12.0f, 0.0f);
        }
        if (this.names.size() >= 8) {
            this.crightFoot = this.getComponent(this.names.get(7)).setRotPoint(0.0f, 12.0f, 0.0f);
        }
    }

    public ModelArmorBase<?> adjustWithOrigin(HumanoidModel<?> origin, EquipmentSlot equipmentSlot) {
        this.chead.copyPose(origin.f_102809_);
        this.cbody.copyPose(origin.f_102810_);
        this.cleftArm.copyPose(origin.f_102812_).adjXYZ(-5.2f, -2.2f, 0.0f, new String[0]);
        this.crightArm.copyPose(origin.f_102811_).adjXYZ(5.2f, -1.8f, 0.0f, new String[0]);
        this.cleftLeg.copyPose(origin.f_102814_).resetX().resetY();
        this.crightLeg.copyPose(origin.f_102813_).resetX().resetY();
        this.cleftFoot.copyPose(origin.f_102814_).resetX().resetY();
        this.crightFoot.copyPose(origin.f_102813_).resetX().resetY();
        this.setObjVisible(false);
        switch (equipmentSlot) {
            case HEAD: {
                this.chead.visible = true;
                break;
            }
            case CHEST: {
                this.cbody.visible = true;
                this.crightArm.visible = true;
                this.cleftArm.visible = true;
                break;
            }
            case LEGS: {
                this.crightLeg.visible = true;
                this.cleftLeg.visible = true;
                break;
            }
            case FEET: {
                this.cleftFoot.visible = true;
                this.crightFoot.visible = true;
            }
        }
        return this;
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        if (this.armTexExtra != null) {
            this.cleftArm.bindTexture(this.armTexExtra);
            this.crightArm.bindTexture(this.armTexExtra);
        }
        this.cleftFoot.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.crightFoot.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.cleftLeg.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.crightLeg.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.cbody.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.chead.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.cleftArm.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.crightArm.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
    }

    public void setObjVisible(boolean visible) {
        this.rootModel.children.forEach((s, component) -> {
            component.visible = visible;
        });
    }
}

