/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.model.entity;

import com.hbm.entity.mob.EntityGlyphid;
import com.hbm.render.model.BaseObjModel;
import com.hbm.render.model.IObjModel;
import com.hbm.utils.BobMth;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelGlyphid<T extends Entity>
extends EntityModel<T>
implements IObjModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"HBM-ModelGlyphid");
    public BaseObjModel rootModel;
    public String body = "Body";
    public String jawLeft = "JawLeft";
    public String jawRight = "JawRight";
    public String jawTop = "JawTop";
    public String armRightUpper = "ArmRightUpper";
    public String armRightMid = "ArmRightMid";
    public String armRightLower = "ArmRightLower";
    public String armLeftUpper = "ArmLeftUpper";
    public String armLeftMid = "ArmLeftMid";
    public String armLeftLower = "ArmLeftLower";
    public String legRightUpper = "LegRightUpper";
    public String legRightLower = "LegRightLower";
    public String legLeftUpper = "LegLeftUpper";
    public String legLeftLower = "LegLeftLower";
    public String armorRight = "ArmorRight";
    public String armorLeft = "ArmorLeft";
    public String armorFront = "ArmorFront";
    public String armRightArmor = "ArmRightArmor";
    public String armLeftArmor = "ArmLeftArmor";
    public String jaw = "jaw";
    public float scale;
    public float[] cy = new float[2];

    @Override
    public void parseJson(ResourceLocation jsonPath) {
        this.rootModel = BaseObjModel.create(jsonPath, RenderType::m_110458_);
        try {
            LOGGER.debug("Glyphid model '{}' adjusting leg groups {}", (Object)this.rootModel.getModelIdentifier(), List.of(this.legLeftUpper, this.legRightUpper));
            this.rootModel.adjXYZ(0.0f, -1.5f * this.getRootModel().size, 0.0f, this.legLeftUpper, this.legRightUpper);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to adjust glyphid model '{}' groups {}", (Object)this.rootModel.getModelIdentifier(), List.of(this.legLeftUpper, this.legRightUpper), (Object)ex);
        }
        this.rootModel.getChild(this.body);
        this.rootModel.addChild(this.jaw, new BaseObjModel(this.rootModel, this.jaw).setRotPoint(0.0f, 0.5f, 0.25f).addChild(this.jawLeft, this.rootModel.popChild(this.jawLeft).setRotPoint(0.0f, 0.5f, 0.25f)).addChild(this.jawRight, this.rootModel.popChild(this.jawRight).setRotPoint(0.0f, 0.5f, 0.25f)).addChild(this.jawTop, this.rootModel.popChild(this.jawTop).setRotPoint(0.0f, 0.5f, 0.25f)));
        this.rootModel.getChild(this.armRightLower).addChild(this.armRightArmor, this.rootModel.popChild(this.armRightArmor)).setRotPoint(-0.25f, 0.625f, 0.9375f);
        this.rootModel.getChild(this.armRightMid).addChild(this.armRightLower, this.rootModel.popChild(this.armRightLower)).setRotPoint(-0.25f, 0.625f, 0.4375f);
        this.rootModel.getChild(this.armRightUpper).addChild(this.armRightMid, this.rootModel.popChild(this.armRightMid)).setRotPoint(-0.25f, 0.625f, 0.0625f);
        this.rootModel.getChild(this.armLeftLower).addChild(this.armLeftArmor, this.rootModel.popChild(this.armLeftArmor)).setRotPoint(0.25f, 0.625f, 0.9375f);
        this.rootModel.getChild(this.armLeftMid).addChild(this.armLeftLower, this.rootModel.popChild(this.armLeftLower)).setRotPoint(0.25f, 0.625f, 0.4375f);
        this.rootModel.getChild(this.armLeftUpper).addChild(this.armLeftMid, this.rootModel.popChild(this.armLeftMid)).setRotPoint(0.25f, 0.625f, 0.0625f);
        this.rootModel.getChild(this.legRightLower).setRotPoint(-0.5625f, 0.25f, 0.0f);
        this.rootModel.getChild(this.legRightUpper).addChild(this.legRightLower, this.rootModel.popChild(this.legRightLower)).visible(false, new String[0]).setRotPoint(0.0f, 0.25f, 0.0f);
        this.rootModel.getChild(this.legLeftLower).setRotPoint(0.5625f, 0.25f, 0.0f);
        this.rootModel.getChild(this.legLeftUpper).addChild(this.legLeftLower, this.rootModel.popChild(this.legLeftLower)).visible(false, new String[0]).setRotPoint(0.0f, 0.25f, 0.0f);
        this.rootModel.getChild(this.armorRight);
        this.rootModel.getChild(this.armorLeft);
        this.rootModel.getChild(this.armorFront);
    }

    public void m_6973_(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.scale = ((EntityGlyphid)pEntity).m_6134_() * 16.0f;
        this.rootModel.scale(this.scale);
        float cy0 = (float)Math.sin((double)pLimbSwing % (Math.PI * 2));
        float cy1 = (float)Math.sin((double)pLimbSwing % (Math.PI * 2) - 1.5707963267948966);
        float cy2 = (float)Math.sin((double)pLimbSwing % (Math.PI * 2) - Math.PI);
        float cy3 = (float)Math.sin((double)pLimbSwing % (Math.PI * 2) - 2.356194490192345);
        byte armor = (Byte)pEntity.m_20088_().m_135370_(EntityGlyphid.DATA_ARMOR);
        this.rootModel.getChild((String)this.armorFront).visible = (armor & 1) > 0;
        this.rootModel.getChild((String)this.armorLeft).visible = (armor & 2) > 0;
        this.rootModel.getChild((String)this.armorRight).visible = (armor & 4) > 0;
        float headYRot = pNetHeadYaw * ((float)Math.PI / 180);
        float headXRot = pHeadPitch * ((float)Math.PI / 180);
        this.rootModel.getChild(this.jaw).getChild(this.jawTop).setRot(-headXRot + pLimbSwingAmount, headYRot, 0.0f);
        this.rootModel.getChild(this.jaw).getChild(this.jawLeft).setRot(-headXRot + pLimbSwingAmount, headYRot + pLimbSwingAmount, 0.0f);
        this.rootModel.getChild(this.jaw).getChild(this.jawRight).setRot(-headXRot + pLimbSwingAmount, headYRot - pLimbSwingAmount, 0.0f);
        this.rootModel.getChild(this.armLeftUpper).setRot(BobMth.degree2Radians(35.0f + cy1 * 20.0f), BobMth.degree2Radians(10.0f), 0.0f).getChild(this.armLeftMid).setRot(BobMth.degree2Radians(-75.0f - cy1 * 20.0f + cy0 * 20.0f), 0.0f, 0.0f).getChild(this.armLeftLower).setRot(BobMth.degree2Radians(90.0f - cy0 * 45.0f), 0.0f, 0.0f).getChild(this.armLeftArmor).visible((armor & 8) > 0, new String[0]);
        this.rootModel.getChild(this.armRightUpper).setRot(BobMth.degree2Radians(35.0f + cy2 * 20.0f), BobMth.degree2Radians(-10.0f), 0.0f).getChild(this.armRightMid).setRot(BobMth.degree2Radians(-75.0f - cy2 * 20.0f + cy3 * 20.0f), 0.0f, 0.0f).getChild(this.armRightLower).setRot(BobMth.degree2Radians(90.0f - cy3 * 45.0f), BobMth.degree2Radians(10.0f), 0.0f).getChild(this.armRightArmor).visible((armor & 0x10) > 0, new String[0]);
        this.cy[0] = cy0;
        this.cy[1] = cy1;
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
        this.rootModel.visible(false, this.legLeftUpper, this.legRightUpper);
        this.rootModel.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        this.rootModel.visible(true, this.legLeftUpper, this.legRightUpper);
        float steppy = 15.0f;
        float bend = 60.0f;
        for (int i = 0; i < 3; ++i) {
            float c0 = this.cy[0] * (float)(i == 1 ? -1 : 1);
            float c1 = this.cy[1] * (float)(i == 1 ? -1 : 1);
            this.rootModel.getChild(this.legLeftUpper).setRot(0.0f, BobMth.degree2Radians((float)(i * 30 - 15) + c0 * 7.5f), BobMth.degree2Radians(steppy + c1 * steppy));
            this.rootModel.getChild(this.legLeftUpper).getChild(this.legLeftLower).setRot(0.0f, 0.0f, BobMth.degree2Radians(-bend - c1 * steppy));
            this.rootModel.getChild(this.legLeftUpper).m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
            this.rootModel.getChild(this.legRightUpper).setRot(0.0f, BobMth.degree2Radians((float)(i * 30 - 45) + c0 * 7.5f), BobMth.degree2Radians(-steppy + c1 * steppy));
            this.rootModel.getChild(this.legRightUpper).getChild(this.legRightLower).setRot(0.0f, 0.0f, BobMth.degree2Radians(bend - c1 * steppy));
            this.rootModel.getChild(this.legRightUpper).m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        this.rootModel.visible(false, this.legLeftUpper, this.legRightUpper);
        pPoseStack.m_85849_();
    }

    @Override
    public BaseObjModel getRootModel() {
        return this.rootModel;
    }

    public List<String> trackedGroups() {
        return Arrays.asList(this.body, this.jawLeft, this.jawRight, this.jawTop, this.armRightUpper, this.armRightMid, this.armRightLower, this.armLeftUpper, this.armLeftMid, this.armLeftLower, this.legRightUpper, this.legRightLower, this.legLeftUpper, this.legLeftLower, this.armorRight, this.armorLeft, this.armorFront, this.armRightArmor, this.armLeftArmor, this.jaw);
    }
}

