/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public final class AtomicFlashOverlay {
    private static int ticksRemaining;
    private static int totalTicks;
    private static float maxAlpha;

    private AtomicFlashOverlay() {
    }

    public static void trigger(float strength, int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        ticksRemaining = totalTicks = Math.max(1, durationTicks);
        maxAlpha = Mth.m_14036_((float)strength, (float)0.1f, (float)1.0f);
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || ticksRemaining <= 0) {
            return;
        }
        --ticksRemaining;
    }

    public static void onGuiRender(RenderGuiEvent.Post event) {
        if (ticksRemaining <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null) {
            return;
        }
        float progress = 1.0f - (float)ticksRemaining / (float)totalTicks;
        float alpha = maxAlpha * (1.0f - progress);
        if (alpha <= 0.01f) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int width = event.getWindow().m_85445_();
        int height = event.getWindow().m_85446_();
        int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
        RenderSystem.enableBlend();
        graphics.m_280509_(0, 0, width, height, color);
        RenderSystem.disableBlend();
    }
}

