/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.overlay;

import com.hbm.config.ClientConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public final class DebugTagOverlay {
    private static final int TEXT_COLOR = -1056964609;
    private static final int BACKGROUND_COLOR = 0x4C000000;
    private static final int PADDING = 6;
    private static final int SHORT_SHA_LENGTH = 8;
    private static final Map<UUID, String> SIGNATURE_CACHE = new HashMap<UUID, String>();
    private static String cachedVersion;

    private DebugTagOverlay() {
    }

    public static void onGuiRender(RenderGuiEvent.Post event) {
        if (!ClientConfig.DEBUG_TAG_OVERLAY.get().booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null || mc.f_91066_.f_92063_) {
            return;
        }
        String versionLine = "HBM-" + DebugTagOverlay.getVersion() + " Debug Info";
        GuiGraphics graphics = event.getGuiGraphics();
        Font font = mc.f_91062_;
        String tag = "[" + mc.f_91074_.m_36316_().getName() + "]:{" + DebugTagOverlay.getSignature(mc.f_91074_.m_20148_()) + "}";
        int width = Math.max(font.m_92895_(versionLine), font.m_92895_(tag));
        int x = 6;
        int n = event.getWindow().m_85446_();
        Objects.requireNonNull(font);
        int y = n - 9 * 2 - 8;
        RenderSystem.enableBlend();
        Objects.requireNonNull(font);
        graphics.m_280509_(x - 3, y - 4, x + width + 3, y + 9 * 2 + 4, 0x4C000000);
        graphics.m_280056_(font, versionLine, x, y, -1056964609, false);
        Objects.requireNonNull(font);
        graphics.m_280056_(font, tag, x, y + 9 + 2, -1056964609, false);
        RenderSystem.disableBlend();
    }

    private static String getSignature(UUID uuid) {
        return SIGNATURE_CACHE.computeIfAbsent(uuid, DebugTagOverlay::computeSignature);
    }

    private static String computeSignature(UUID uuid) {
        String source = DebugTagOverlay.getVersion() + ":" + String.valueOf(uuid);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hash = digest.digest(source.getBytes(StandardCharsets.UTF_8));
            String hex = HexFormat.of().withUpperCase().formatHex(hash);
            return hex.substring(0, Math.min(8, hex.length()));
        }
        catch (NoSuchAlgorithmException e) {
            return Integer.toHexString(source.hashCode()).toUpperCase(Locale.ROOT);
        }
    }

    private static String getVersion() {
        if (cachedVersion == null) {
            cachedVersion = ModList.get().getModContainerById("hbm").map(container -> container.getModInfo().getVersion().toString()).orElse("dev-build");
        }
        return cachedVersion;
    }
}

