/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.pipeline;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.hbm.render.pipeline.RenderLayerType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public record AnimatableRenderDefinition(ResourceLocation id, ResourceLocation model, @Nullable ResourceLocation animation, Map<String, ResourceLocation> textures, RenderLayerType renderLayer, float shadowRadius, float scale) {
    private static final String DEFAULT_TEXTURE_KEY = "default";

    public AnimatableRenderDefinition {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(model, "model");
        Objects.requireNonNull(textures, "textures");
        if (textures.isEmpty()) {
            throw new IllegalArgumentException("Textures map must not be empty for " + String.valueOf(id));
        }
        if (!textures.containsKey(DEFAULT_TEXTURE_KEY)) {
            throw new IllegalArgumentException("Render definition " + String.valueOf(id) + " is missing a \"default\" texture entry");
        }
        textures = ImmutableMap.copyOf(textures);
        renderLayer = Objects.requireNonNullElse(renderLayer, RenderLayerType.CUTOUT);
        shadowRadius = Math.max(0.0f, shadowRadius);
        scale = scale <= 0.0f ? 1.0f : scale;
    }

    public ResourceLocation texture(String key) {
        if (key != null && !key.isBlank()) {
            ResourceLocation variant = this.textures.get(key);
            if (variant != null) {
                return variant;
            }
            ResourceLocation normalized = this.textures.get(key.toLowerCase(Locale.ROOT));
            if (normalized != null) {
                return normalized;
            }
        }
        return this.textures.get(DEFAULT_TEXTURE_KEY);
    }

    public static AnimatableRenderDefinition fromJson(ResourceLocation fallbackId, JsonObject json) {
        ResourceLocation id = json.has("id") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"id")) : fallbackId;
        ResourceLocation model = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"model"));
        ResourceLocation animation = json.has("animation") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"animation")) : null;
        RenderLayerType layer = json.has("render_type") ? RenderLayerType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"render_type")) : RenderLayerType.CUTOUT;
        float shadowRadius = GsonHelper.m_13820_((JsonObject)json, (String)"shadow_radius", (float)0.5f);
        float scale = GsonHelper.m_13820_((JsonObject)json, (String)"scale", (float)1.0f);
        JsonObject textureObj = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
        ImmutableMap.Builder textures = ImmutableMap.builder();
        for (String key : textureObj.keySet()) {
            textures.put((Object)key, (Object)new ResourceLocation(GsonHelper.m_13906_((JsonObject)textureObj, (String)key)));
        }
        return new AnimatableRenderDefinition(id, model, animation, (Map<String, ResourceLocation>)textures.build(), layer, shadowRadius, scale);
    }
}

