/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.pipeline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm.HBM;
import com.hbm.render.pipeline.AnimatableRenderDefinition;
import com.hbm.render.pipeline.RenderLayerType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GeoRenderPipeline
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final GeoRenderPipeline INSTANCE = new GeoRenderPipeline();
    private static final Logger LOGGER = LogManager.getLogger((String)"HBM-GeoRenderPipeline");
    private static final ResourceLocation FALLBACK_MODEL = HBM.rl("geo/pipeline_placeholder.geo.json");
    private static final ResourceLocation FALLBACK_ANIMATION = HBM.rl("animations/pipeline_generic.animation.json");
    private static final ResourceLocation FALLBACK_TEXTURE = HBM.rl("textures/entity/duck.png");
    private static final AnimatableRenderDefinition FALLBACK_DEFINITION = new AnimatableRenderDefinition(HBM.rl("fallback_placeholder"), FALLBACK_MODEL, FALLBACK_ANIMATION, Map.of("default", FALLBACK_TEXTURE), RenderLayerType.CUTOUT, 0.5f, 1.0f);
    private volatile Map<ResourceLocation, AnimatableRenderDefinition> definitions = Map.of();
    private final Set<ResourceLocation> reportedMissing = Collections.synchronizedSet(new HashSet());

    private GeoRenderPipeline() {
        super(GSON, "render_pipeline");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profiler) {
        HashMap resolved = new HashMap();
        jsons.forEach((fileId, element) -> {
            if (!element.isJsonObject()) {
                LOGGER.warn("Ignoring non-object render pipeline definition at {}", fileId);
                return;
            }
            JsonObject json = element.getAsJsonObject();
            if (json.has("entries")) {
                json.getAsJsonArray("entries").forEach(entry -> this.readEntry((ResourceLocation)fileId, (JsonElement)entry, resolved));
            } else {
                this.readEntry((ResourceLocation)fileId, (JsonElement)json, resolved);
            }
        });
        this.definitions = Map.copyOf(resolved);
        this.reportedMissing.clear();
        LOGGER.info("Loaded {} GeckoLib render definitions", (Object)this.definitions.size());
    }

    private void readEntry(ResourceLocation fileId, JsonElement element, Map<ResourceLocation, AnimatableRenderDefinition> sink) {
        if (!element.isJsonObject()) {
            LOGGER.warn("Skipping malformed render pipeline entry in {}", (Object)fileId);
            return;
        }
        JsonObject entryJson = element.getAsJsonObject();
        AnimatableRenderDefinition definition = AnimatableRenderDefinition.fromJson(new ResourceLocation(fileId.m_135827_(), fileId.m_135815_()), entryJson);
        sink.put(definition.id(), definition);
    }

    public AnimatableRenderDefinition definition(ResourceLocation id) {
        AnimatableRenderDefinition definition = this.definitions.get(id);
        if (definition != null) {
            return definition;
        }
        if (this.reportedMissing.add(id)) {
            LOGGER.warn("Missing GeckoLib render definition for {}, using fallback placeholder", (Object)id);
        }
        return FALLBACK_DEFINITION;
    }

    public Map<ResourceLocation, AnimatableRenderDefinition> definitions() {
        return this.definitions;
    }

    public ResourceLocation fallbackModel() {
        return FALLBACK_MODEL;
    }

    public ResourceLocation fallbackAnimation() {
        return FALLBACK_ANIMATION;
    }

    public ResourceLocation fallbackTexture() {
        return FALLBACK_TEXTURE;
    }
}

