/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class GaugeUtil {
    private GaugeUtil() {
    }

    public static void drawSmoothGauge(GuiGraphics graphics, int x, int y, float z, double progress, double tipLength, double backLength, double backSide, int color, int colorOuter) {
        progress = Mth.m_14008_((double)progress, (double)0.0, (double)1.0);
        double angle = Math.toRadians(-progress * 270.0 - 45.0);
        double tipX = 0.0;
        double tipY = tipLength;
        double leftX = backSide;
        double leftY = -backLength;
        double rightX = -backSide;
        double rightY = -backLength;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double tipXR = tipX * cos - tipY * sin;
        double tipYR = tipX * sin + tipY * cos;
        double leftXR = leftX * cos - leftY * sin;
        double leftYR = leftX * sin + leftY * cos;
        double rightXR = rightX * cos - rightY * sin;
        double rightYR = rightX * sin + rightY * cos;
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        GaugeUtil.addTriangle(buffer, matrix, x, y, z, tipXR * 1.5, tipYR * 1.5, leftXR * 1.5, leftYR * 1.5, rightXR * 1.5, rightYR * 1.5, colorOuter);
        GaugeUtil.addTriangle(buffer, matrix, x, y, z, tipXR, tipYR, leftXR, leftYR, rightXR, rightYR, color);
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private static void addTriangle(BufferBuilder buffer, Matrix4f matrix, int x, int y, float z, double tipX, double tipY, double leftX, double leftY, double rightX, double rightY, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.m_252986_(matrix, (float)((double)x + tipX), (float)((double)y + tipY), z).m_6122_(r, g, b, 255).m_5752_();
        buffer.m_252986_(matrix, (float)((double)x + leftX), (float)((double)y + leftY), z).m_6122_(r, g, b, 255).m_5752_();
        buffer.m_252986_(matrix, (float)((double)x + rightX), (float)((double)y + rightY), z).m_6122_(r, g, b, 255).m_5752_();
    }
}

