/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnegative;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BobMth {
    public static double safeClamp(double val, double min, double max) {
        if ((val = Mth.m_14008_((double)val, (double)min, (double)max)) == Double.NaN) {
            val = (min + max) / 2.0;
        }
        return val;
    }

    public static Vec3 interpVec(Vec3 vec1, Vec3 vec2, float interp) {
        return new Vec3(BobMth.interp(vec1.f_82479_, vec2.f_82479_, interp), BobMth.interp(vec1.f_82480_, vec2.f_82480_, interp), BobMth.interp(vec1.f_82481_, vec2.f_82481_, interp));
    }

    public static double interp(double x, double y, float interp) {
        return x + (y - x) * (double)interp;
    }

    public static double getAngleFrom2DVecs(double x1, double z1, double x2, double z2) {
        double upper = x1 * x2 + z1 * z2;
        double lower = Math.sqrt(x1 * x1 + z1 * z1) * Math.sqrt(x2 * x2 + z2 * z2);
        double result = Math.toDegrees(Math.cos(upper / lower));
        if (result >= 180.0) {
            result -= 180.0;
        }
        return result;
    }

    public static double getCrossAngle(Vec3 vel, Vec3 rel) {
        vel.m_82541_();
        rel.m_82541_();
        double vecProd = rel.f_82479_ * vel.f_82479_ + rel.f_82480_ * vel.f_82480_ + rel.f_82481_ * vel.f_82481_;
        double bot = rel.m_82553_() * vel.m_82553_();
        double angle = Math.acos(vecProd / bot) * 180.0 / Math.PI;
        if (angle >= 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    public static float remap(float num, float min1, float max1, float min2, float max2) {
        return (num - min1) / (max1 - min1) * (max2 - min2) + min2;
    }

    public static float remap01(float num, float min1, float max1) {
        return (num - min1) / (max1 - min1);
    }

    public static float remap01_clamp(float num, float min1, float max1) {
        return Mth.m_14036_((float)((num - min1) / (max1 - min1)), (float)0.0f, (float)1.0f);
    }

    public static Direction[] getShuffledDirs() {
        Direction[] dirs = new Direction[6];
        ArrayList indices = new ArrayList(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };
        Collections.shuffle(indices);
        for (int i = 0; i < 6; ++i) {
            dirs[i] = Direction.m_122376_((int)((Integer)indices.get(i)));
        }
        return dirs;
    }

    public static String toPercentage(float amount, float total) {
        return NumberFormat.getPercentInstance().format(amount / total);
    }

    public static String[] ticksToDate(long ticks) {
        int tickDay = 48000;
        int tickYear = tickDay * 100;
        String[] dateOut = new String[3];
        long year = Math.floorDiv(ticks, tickYear);
        byte day = (byte)Math.floorDiv(ticks - (long)tickYear * year, tickDay);
        float time = ticks - ((long)tickYear * year + (long)(tickDay * day));
        time = (float)BobMth.convertScale(time, 0.0, tickDay, 0.0, 10.0);
        dateOut[0] = String.valueOf(year);
        dateOut[1] = String.valueOf(day);
        dateOut[2] = String.valueOf(time);
        return dateOut;
    }

    public static double convertScale(double toScale, double oldMin, double oldMax, double newMin, double newMax) {
        double prevRange = oldMax - oldMin;
        double newRange = newMax - newMin;
        return (toScale - oldMin) * newRange / prevRange + newMin;
    }

    public static double roundDecimal(double num, @Nonnegative int digits) {
        if (digits < 0) {
            throw new IllegalArgumentException("Attempted negative number in non-negative field! Attempted value: " + digits);
        }
        return new BigDecimal(num).setScale(digits, RoundingMode.HALF_UP).doubleValue();
    }

    public static boolean getBlink() {
        return System.currentTimeMillis() % 1000L < 500L;
    }

    public static String getShortNumber(long l) {
        if ((double)l >= Math.pow(10.0, 18.0)) {
            double res = (double)l / Math.pow(10.0, 18.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "E";
        }
        if ((double)l >= Math.pow(10.0, 15.0)) {
            double res = (double)l / Math.pow(10.0, 15.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "P";
        }
        if ((double)l >= Math.pow(10.0, 12.0)) {
            double res = (double)l / Math.pow(10.0, 12.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "T";
        }
        if ((double)l >= Math.pow(10.0, 9.0)) {
            double res = (double)l / Math.pow(10.0, 9.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "G";
        }
        if ((double)l >= Math.pow(10.0, 6.0)) {
            double res = (double)l / Math.pow(10.0, 6.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "M";
        }
        if ((double)l >= Math.pow(10.0, 3.0)) {
            double res = (double)l / Math.pow(10.0, 3.0);
            res = (double)Math.round(res * 100.0) / 100.0;
            return res + "k";
        }
        return Long.toString(l);
    }

    public static double squirt(double x) {
        return Math.sqrt(x + 1.0 / ((x + 2.0) * (x + 2.0))) - 1.0 / (x + 2.0);
    }

    public static void setPi(double pi) {
        try {
            Field field = Math.class.getDeclaredField("PI");
            field.setDouble(null, pi);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double angularDifference(double alpha, double beta) {
        double delta = (beta - alpha + 180.0) % 360.0 - 180.0;
        return delta < -180.0 ? delta + 360.0 : delta;
    }

    public static int[] intCollectionToArray(Collection<Integer> in) {
        return BobMth.intCollectionToArray(in, i -> (Integer)i);
    }

    public static int[] intCollectionToArray(Collection<Integer> in, ToIntFunction<? super Object> mapper) {
        return Arrays.stream(in.toArray()).mapToInt(mapper).toArray();
    }

    public static int[] collectionToIntArray(Collection<? extends Object> in, ToIntFunction<? super Object> mapper) {
        return Arrays.stream(in.toArray()).mapToInt(mapper).toArray();
    }

    public static double sps(double x) {
        return Math.sin(1.5707963267948966 * Math.cos(x));
    }

    public static double sws(double x, double squarination) {
        double s = Math.sin(x);
        return Math.pow(Math.abs(s), 2.0 - squarination) / s;
    }

    public static float degree2Radians(float degree) {
        return Mth.m_14177_((float)degree) * (float)Math.PI / 180.0f;
    }
}

