/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;

public class ConcurrentBitSet {
    private final AtomicLongArray words;
    private final int size;
    private final LongAdder bitCount = new LongAdder();

    public ConcurrentBitSet(int size) {
        this.size = size;
        int wordCount = size + 63 >>> 6;
        this.words = new AtomicLongArray(wordCount);
    }

    public void set(int bit) {
        long newWord;
        long oldWord;
        if (bit < 0 || bit >= this.size) {
            return;
        }
        int wordIndex = bit >>> 6;
        long mask = 1L << (bit & 0x3F);
        do {
            if ((oldWord = this.words.get(wordIndex)) != (newWord = oldWord | mask)) continue;
            return;
        } while (!this.words.compareAndSet(wordIndex, oldWord, newWord));
        this.bitCount.increment();
    }

    public void clear(int bit) {
        long newWord;
        long oldWord;
        if (bit < 0 || bit >= this.size) {
            return;
        }
        int wordIndex = bit >>> 6;
        long mask = 1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        do {
            if ((oldWord = this.words.get(wordIndex)) != (newWord = oldWord & mask)) continue;
            return;
        } while (!this.words.compareAndSet(wordIndex, oldWord, newWord));
        this.bitCount.decrement();
    }

    public int nextSetBit(int from) {
        int wordIndex;
        if (from < 0) {
            from = 0;
        }
        if ((wordIndex = from >>> 6) >= this.words.length()) {
            return -1;
        }
        long word = this.words.get(wordIndex) & -1L << (from & 0x3F);
        while (true) {
            if (word != 0L) {
                int idx = (wordIndex << 6) + Long.numberOfTrailingZeros(word);
                return idx < this.size ? idx : -1;
            }
            if (++wordIndex >= this.words.length()) {
                return -1;
            }
            word = this.words.get(wordIndex);
        }
    }

    public boolean isEmpty() {
        return this.bitCount.sum() == 0L;
    }

    public long cardinality() {
        return this.bitCount.sum();
    }
}

