/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.HBMLang;
import com.hbm.addational_data.AdditionalDataManager;
import com.hbm.addational_data.DataEntry;
import com.hbm.addational_data.chunk.RadiationManager;
import com.hbm.api.badthing.HazmatRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ContaminationUtil {
    public static float calculateRadiationMod(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float koeff = 10.0f;
            return (float)Math.pow(koeff, -HazmatRegistry.getResistance(player));
        }
        return 1.0f;
    }

    public static boolean isRadImmune(Entity e) {
        return false;
    }

    public static void incrementRadiation(Entity entity, float amount) {
        Float rad = AdditionalDataManager.getEntityData(entity, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
        AdditionalDataManager.setEntityData(entity, DataEntry.RADIATION, Float.valueOf(rad.floatValue() + amount));
    }

    public static void incrementDigamma(Entity entity, float amount) {
        Float rad = AdditionalDataManager.getEntityData(entity, DataEntry.DIGMMA).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
        AdditionalDataManager.setEntityData(entity, DataEntry.DIGMMA, Float.valueOf(rad.floatValue() + amount));
    }

    public static boolean contaminate(LivingEntity entity, HazardType hazard, ContaminationType cont, float amount) {
        if (hazard == HazardType.RADIATION) {
            float radEnv = AdditionalDataManager.getEntityData((Entity)entity, DataEntry.RADIATION_ENV).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
            AdditionalDataManager.setEntityData((Entity)entity, DataEntry.RADIATION_ENV, Float.valueOf(radEnv + amount));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            switch (cont) {
                // Empty switch
            }
            if (player.m_7500_() && cont != ContaminationType.NONE && cont != ContaminationType.DIGAMMA2) {
                return false;
            }
            if (player.f_19797_ < 200) {
                return false;
            }
        }
        if (hazard == HazardType.RADIATION && ContaminationUtil.isRadImmune((Entity)entity)) {
            return false;
        }
        switch (hazard) {
            case RADIATION: {
                ContaminationUtil.incrementRadiation((Entity)entity, amount * (cont == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case DIGAMMA: {
                ContaminationUtil.incrementDigamma((Entity)entity, amount);
            }
        }
        return true;
    }

    public static void printGeigerData(Player player) {
        Level level = player.m_9236_();
        float eRad = AdditionalDataManager.getEntityData((Entity)player, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        float env = AdditionalDataManager.getEntityData((Entity)player, DataEntry.RADIATION_BUF).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
        float rads = RadiationManager.getRadiation(level, player.m_20097_());
        double res = (double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0;
        double resKoeff = (double)((int)((double)HazmatRegistry.getResistance(player) * 100.0)) / 100.0;
        ChatFormatting chunkFormat = ContaminationUtil.getPreffixFromRad(rads);
        ChatFormatting envFormat = ContaminationUtil.getPreffixFromRad(rads);
        ChatFormatting resPrefix = ChatFormatting.WHITE;
        ChatFormatting radPrefix = eRad < 200.0f ? ChatFormatting.GREEN : (eRad < 400.0f ? ChatFormatting.YELLOW : (eRad < 600.0f ? ChatFormatting.GOLD : (eRad < 800.0f ? ChatFormatting.RED : (eRad < 1000.0f ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GRAY))));
        if (resKoeff > 0.0) {
            resPrefix = ChatFormatting.GREEN;
        }
        player.m_213846_((Component)Component.m_237113_((String)"===== \u2622 ").m_7220_((Component)Component.m_237115_((String)HBMLang.TOOLTIP_GEIGER0.key())).m_7220_((Component)Component.m_237113_((String)" \u2622 =====")).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)HBMLang.TOOLTIP_GEIGER1.key()).m_7220_((Component)Component.m_237113_((String)(" " + rads + " RAD/s")).m_130940_(chunkFormat)).m_130940_(ChatFormatting.YELLOW));
        player.m_213846_((Component)Component.m_237115_((String)HBMLang.TOOLTIP_GEIGER2.key()).m_7220_((Component)Component.m_237113_((String)(" " + env + " RAD/s")).m_130940_(envFormat)).m_130940_(ChatFormatting.YELLOW));
        player.m_213846_((Component)Component.m_237115_((String)HBMLang.TOOLTIP_GEIGER3.key()).m_7220_((Component)Component.m_237113_((String)(" " + eRad + " RAD/s")).m_130940_(radPrefix)).m_130940_(ChatFormatting.YELLOW));
        player.m_213846_((Component)Component.m_237115_((String)HBMLang.TOOLTIP_GEIGER4.key()).m_7220_((Component)Component.m_237113_((String)(" " + res + " RAD/s")).m_130940_(resPrefix)).m_130940_(ChatFormatting.YELLOW));
    }

    public static ChatFormatting getPreffixFromRad(double rads) {
        if (rads == 0.0) {
            return ChatFormatting.GREEN;
        }
        if (rads < 1.0) {
            return ChatFormatting.YELLOW;
        }
        if (rads < 10.0) {
            return ChatFormatting.GOLD;
        }
        if (rads < 100.0) {
            return ChatFormatting.RED;
        }
        if (rads < 1000.0) {
            return ChatFormatting.DARK_RED;
        }
        return ChatFormatting.DARK_GRAY;
    }

    public static enum HazardType {
        RADIATION,
        DIGAMMA;

    }

    public static enum ContaminationType {
        FARADAY,
        HAZMAT,
        HAZMAT2,
        DIGAMMA,
        DIGAMMA2,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }
}

