/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.utils.EnumUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionUtils {
    public static final int[] OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 6};
    public static final int[][] ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2, 6}, {0, 1, 5, 4, 2, 3, 6}, {5, 4, 2, 3, 0, 1, 6}, {4, 5, 2, 3, 1, 0, 6}, {2, 3, 1, 0, 4, 5, 6}, {3, 2, 0, 1, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};

    public static Direction leftRot(Direction axis, Direction original) {
        return EnumUtils.DIRECTIONS[ROTATION_MATRIX[axis.ordinal()][original.ordinal()]];
    }

    public static Direction horizRot(Direction refDir, Direction newRefDir, Direction dir) {
        int times = (newRefDir.m_122416_() - refDir.m_122416_() + 4) % 4;
        return Direction.m_122407_((int)((dir.m_122416_() + times) % 4));
    }

    public static Vec3i offsetRot(Vec3i offset, Direction refDir, Direction newRefdir) {
        return DirectionUtils.offsetRot(List.of(offset), refDir, newRefdir).get(0);
    }

    public static List<Vec3i> offsetRot(List<Vec3i> offsets, Direction refDir, Direction newRefDir) {
        int times = (newRefDir.m_122416_() - refDir.m_122416_() + 4) % 4;
        ArrayList<Vec3i> result = new ArrayList<Vec3i>(offsets.size());
        for (Vec3i v : offsets) {
            int x = v.m_123341_();
            int y = v.m_123342_();
            int z = v.m_123343_();
            switch (times) {
                case 0: {
                    result.add(new Vec3i(x, y, z));
                    break;
                }
                case 1: {
                    result.add(new Vec3i(-z, y, x));
                    break;
                }
                case 2: {
                    result.add(new Vec3i(-x, y, -z));
                    break;
                }
                case 3: {
                    result.add(new Vec3i(z, y, -x));
                }
            }
        }
        return result;
    }

    public static void generalMachineRotate(PoseStack poseStack, BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        DirectionUtils.generalMachineRotate(poseStack, facing, 0.5f, 0.5f);
    }

    public static void generalMachineRotate(PoseStack poseStack, Direction facing, float centerX, float centerZ) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252880_(centerX - centerZ, 0.0f, centerX + centerZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252880_(2.0f * centerX, 0.0f, 2.0f * centerZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252880_(centerX + centerZ, 0.0f, -centerX + centerZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            }
        }
    }

    public static VoxelShape voxelShapeRot(VoxelShape shape, Direction facing) {
        return DirectionUtils.voxelShapeRot(shape, Direction.SOUTH, facing);
    }

    public static VoxelShape voxelShapeRot(VoxelShape shape, Direction defaultFace, Direction facing) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (facing.m_122416_() - defaultFace.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

