/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    static Function<ItemStack, Boolean> allowAll = itemStack -> true;

    private InventoryUtils() {
    }

    @Nullable
    public static Boolean extractItem(Level level, BaseMachineBlockEntity dest, Direction interactDir) {
        return InventoryUtils.extractItem(level, dest, null, null, interactDir, allowAll);
    }

    @Nullable
    public static Boolean extractItem(Level level, BaseMachineBlockEntity dest, List<Integer> extSlots, Direction interactDir) {
        return InventoryUtils.extractItem(level, dest, null, extSlots, interactDir, allowAll);
    }

    @Nullable
    public static Boolean extractItem(Level level, BaseMachineBlockEntity dest, @Nullable BlockPos proxyPos, @Nullable List<Integer> extSlots, Direction interactDir, Function<ItemStack, Boolean> extCond) {
        BlockPos destPos = proxyPos == null ? dest.m_58899_() : proxyPos;
        List<Integer> slotList = extSlots == null ? IntStream.range(0, dest.m_6643_()).boxed().toList() : extSlots;
        return InventoryUtils.getItemHandler(level, destPos.m_121945_(interactDir), interactDir.m_122424_()).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.m_41619_() || !((Boolean)extCond.apply(extractItem)).booleanValue()) continue;
                Iterator iterator = slotList.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    ItemStack destStack = dest.m_8020_(j);
                    if (!dest.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= dest.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.m_41619_()) {
                        dest.m_6836_(j, extractItem);
                    } else {
                        destStack.m_41769_(1);
                        dest.m_6836_(j, destStack);
                    }
                    dest.m_6596_();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean dropperInsertHook(Level level, BlockPos pos, DispenserBlockEntity dropper, int slot, @NotNull ItemStack stack) {
        Direction enumfacing = (Direction)level.m_8055_(pos).m_61143_((Property)DropperBlock.f_52659_);
        BlockPos blockpos = pos.m_121945_(enumfacing);
        return InventoryUtils.getItemHandler(level, blockpos, enumfacing.m_122424_()).map(destinationResult -> {
            ItemStack dispensedStack;
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            ItemStack remainder = InventoryUtils.putStackInInventoryAllSlots((BlockEntity)dropper, destination, itemHandler, dispensedStack = stack.m_41777_().m_41620_(1));
            if (remainder.m_41619_()) {
                remainder = stack.m_41777_();
                remainder.m_41774_(1);
            } else {
                remainder = stack.m_41777_();
            }
            dropper.m_6836_(slot, remainder);
            return false;
        }).orElse(true);
    }

    public static boolean insertItem(BaseMachineBlockEntity src, Direction interactDir) {
        return InventoryUtils.insertItem(src, null, null, interactDir);
    }

    public static boolean insertItem(BaseMachineBlockEntity src, List<Integer> intSlots, Direction interactDir) {
        return InventoryUtils.insertItem(src, null, intSlots, interactDir);
    }

    public static boolean insertItem(BaseMachineBlockEntity src, @Nullable BlockPos proxyPos, @Nullable List<Integer> intSlots, Direction interactDir) {
        List<Integer> slotList = intSlots == null ? IntStream.range(0, src.m_6643_()).boxed().toList() : intSlots;
        BlockPos srcPos = proxyPos == null ? src.m_58899_() : proxyPos;
        return InventoryUtils.getItemHandler(src.m_58904_(), srcPos.m_121945_(interactDir), interactDir.m_122424_()).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (InventoryUtils.isFull(itemHandler)) {
                return false;
            }
            Iterator iterator = slotList.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (src.m_8020_(i).m_41619_()) continue;
                ItemStack originalSlotContents = src.m_8020_(i).m_41777_();
                ItemStack insertStack = src.m_7407_(i, 1);
                ItemStack remainder = InventoryUtils.putStackInInventoryAllSlots(src, destination, itemHandler, insertStack);
                if (remainder.m_41619_()) {
                    return true;
                }
                src.m_6836_(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.m_41619_(); ++slot) {
            stack = InventoryUtils.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).m_41619_()) {
            HopperBlockEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = InventoryUtils.isEmpty(destInventory);
            if (itemstack.m_41619_()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.f_41583_;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.m_41613_();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).m_41613_();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperBlockEntity && !(destinationHopper = (HopperBlockEntity)destination).m_59409_()) {
                int k = 0;
                if (source instanceof HopperBlockEntity && destinationHopper.getLastUpdateTime() >= ((HopperBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.m_59395_(8 - k);
            }
        }
        return stack;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, BaseContainerBlockEntity src, Direction facing) {
        return InventoryUtils.getItemHandler(level, src.m_58899_().m_121945_(facing), facing.m_122424_());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.m_41613_() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Optional<Pair<IItemHandler, Object>> getItemHandler(Level worldIn, BlockPos blockpos, Direction side) {
        BlockEntity blockEntity;
        BlockState state = worldIn.m_8055_(blockpos);
        if (state.m_155947_() && (blockEntity = worldIn.m_7702_(blockpos)) != null) {
            return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity));
        }
        return Optional.empty();
    }

    public static ItemStack shrink(int amount, ItemStack itemStack) {
        itemStack.m_41774_(amount);
        return itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack;
    }

    public static ItemStack grow(int amount, ItemStack itemStack) {
        itemStack.m_41769_(amount);
        if (itemStack.m_41613_() > itemStack.m_41741_()) {
            itemStack.m_41764_(itemStack.m_41741_());
        }
        return itemStack;
    }

    public static boolean canAddItemEntirely(ItemStack originStack, ItemStack toPut) {
        return originStack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)originStack, (ItemStack)toPut) && originStack.m_41613_() + toPut.m_41613_() <= originStack.m_41741_();
    }

    public static ItemStack growNoCheck(int amount, ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.m_41619_()) {
            itemStack = itemStack2.m_41777_();
        } else {
            itemStack.m_41769_(amount);
        }
        return itemStack;
    }

    public static void handleItems(BlockEntity be, Function<ItemStack, ItemStack> processFunction, int slot1, int slot2) {
        ItemStack output;
        IItemHandler itemHandler = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (itemHandler == null) {
            return;
        }
        ItemStack itemStack = itemHandler.extractItem(slot1, 1, true);
        if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)(output = processFunction.apply(itemStack))) && itemHandler.insertItem(slot2, output, true) == ItemStack.f_41583_) {
            itemHandler.extractItem(slot1, 1, false);
            itemHandler.insertItem(slot2, output, false);
        }
    }
}

