/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDataUtils {
    @NotNull
    public static CompoundTag getDataMap(CompoundTag tag) {
        if (tag.m_128425_("hbmdata", 10)) {
            return tag.m_128469_("hbmdata");
        }
        CompoundTag dataMap = new CompoundTag();
        tag.m_128365_("hbmdata", (Tag)dataMap);
        return dataMap;
    }

    @NotNull
    public static CompoundTag getDataMap(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return ItemDataUtils.getDataMap(tag);
    }

    @Nullable
    public static CompoundTag getDataMapIfPresent(CompoundTag tag) {
        if (tag != null && tag.m_128425_("hbmdata", 10)) {
            return tag.m_128469_("hbmdata");
        }
        return null;
    }

    @Nullable
    public static CompoundTag getDataMapIfPresent(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return ItemDataUtils.getDataMapIfPresent(tag);
    }

    public static boolean hasData(ItemStack stack, String key, int type) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap != null && dataMap.m_128425_(key, type);
    }

    public static <T extends INBTSerializable<CompoundTag>> void readContainers(ItemStack stack, String containerKey, T container) {
        if (!stack.m_41619_() && ItemDataUtils.hasData(stack, containerKey, 10)) {
            container.deserializeNBT((Tag)((CompoundTag)ItemDataUtils.getDataMap(stack).m_128423_(containerKey)));
        }
    }

    public static <T extends INBTSerializable<CompoundTag>> void writeContainers(ItemStack stack, String containerKey, T container) {
        if (!stack.m_41619_()) {
            ItemDataUtils.getDataMap(stack).m_128365_(containerKey, container.serializeNBT());
        }
    }
}

