/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.blockentity.base2.DummyableBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class MultipartUtils {
    private MultipartUtils() {
    }

    public static RayTraceVectors getRayTraceVectors(Entity entity) {
        float pitch = entity.m_146909_();
        float yaw = entity.m_146908_();
        Vec3 start = entity.m_146892_();
        float f1 = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float lookY = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        float lookX = f2 * f3;
        float lookZ = f1 * f3;
        double reach = 5.0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            reach = player.getBlockReach();
        }
        Vec3 end = start.m_82520_((double)lookX * reach, (double)lookY * reach, (double)lookZ * reach);
        return new RayTraceVectors(start, end);
    }

    public static AdvancedRayTraceResult collisionRayTrace(Entity entity, BlockPos pos, Collection<VoxelShape> boxes) {
        RayTraceVectors vecs = MultipartUtils.getRayTraceVectors(entity);
        return MultipartUtils.collisionRayTrace(pos, vecs.start(), vecs.end(), boxes);
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, Collection<VoxelShape> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (VoxelShape shape : boxes) {
            AdvancedRayTraceResult advancedResult;
            double d;
            BlockHitResult result;
            if (shape != null && (result = shape.m_83220_(start, end, pos)) != null && (d = (advancedResult = new AdvancedRayTraceResult((HitResult)result, shape, i)).squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = advancedResult;
            }
            ++i;
        }
        return hit;
    }

    public static boolean checkRequirement(Level level, BlockPos blockPos, Direction dir, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = MultipartUtils.transOffsets(offsets, dir);
        for (Vec3i offset : offsets2) {
            if (level.m_8055_(blockPos.m_121955_(offset)).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public static void fillSpace(Level level, BlockPos blockPos, BlockState blockState, Direction dir, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = MultipartUtils.transOffsets(offsets, dir);
        for (Vec3i offset : offsets2) {
            level.m_7731_(blockPos.m_121955_(offset), blockState, 3);
            BlockEntity blockEntity = level.m_7702_(blockPos.m_121955_(offset));
            if (!(blockEntity instanceof DummyableBlockEntity)) continue;
            DummyableBlockEntity dummyableBlockEntity = (DummyableBlockEntity)blockEntity;
        }
    }

    public static void clearSpace(Level level, BlockPos blockPos, BlockState blockState, Direction direction, List<Vec3i> offsets) {
        List<Vec3i> offsets2 = MultipartUtils.transOffsets(offsets, direction);
        for (Vec3i offset : offsets2) {
            BlockPos pos = blockPos.m_121955_(offset);
            if (!level.m_8055_(pos).m_60713_(blockState.m_60734_())) continue;
            level.m_7471_(pos, false);
        }
    }

    public static List<Vec3i> transOffsets(List<Vec3i> offsets, Direction dir) {
        ArrayList<Vec3i> result = new ArrayList<Vec3i>(offsets);
        int[] trans = switch (dir) {
            case Direction.NORTH -> new int[]{-1, 0, 0, -1};
            case Direction.EAST -> new int[]{0, -1, 1, 0};
            case Direction.SOUTH -> new int[]{1, 0, 0, 1};
            case Direction.WEST -> new int[]{0, 1, -1, 0};
            default -> new int[]{1, 0, 0, 1};
        };
        for (int i = 0; i < result.size(); ++i) {
            Vec3i v1 = (Vec3i)result.get(i);
            Vec3i v2 = new Vec3i(v1.m_123341_() * trans[0] + v1.m_123343_() * trans[2], v1.m_123342_(), v1.m_123341_() * trans[1] + v1.m_123343_() * trans[3]);
            result.set(i, v2);
        }
        return result;
    }

    public static List<Vec3i> square(int[] dim) {
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (int i = -dim[4]; i <= dim[5]; ++i) {
            for (int j = -dim[1]; j <= dim[0]; ++j) {
                for (int k = -dim[2]; k <= dim[3]; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    offsets.add(new Vec3i(i, j, k));
                }
            }
        }
        return offsets;
    }

    public static Vec3i square(int n) {
        return new Vec3i(n, n, n);
    }

    public static Vec3i pillar(int width, int height) {
        return new Vec3i(width, height, width);
    }

    public record RayTraceVectors(Vec3 start, Vec3 end) {
    }

    public static class AdvancedRayTraceResult {
        public final VoxelShape bounds;
        public final HitResult hit;
        public final int subHit;

        public AdvancedRayTraceResult(HitResult mop, VoxelShape shape, int subHit) {
            this.hit = mop;
            this.bounds = shape;
            this.subHit = subHit;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3 vec) {
            return this.hit.m_82450_().m_82557_(vec);
        }
    }
}

