/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.HBM;
import com.hbm.addational_data.DataEntry;
import com.hbm.api.Coord4D;
import com.hbm.api.annotations.ParametersAreNotNullByDefault;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNotNullByDefault
public class NBTUtils {
    private NBTUtils() {
    }

    public static void serializeDataEntry(CompoundTag nbt, DataEntry entry, Object value) {
        if (value == null) {
            return;
        }
        String entryNum = String.valueOf(entry.ordinal());
        if (entry.type == null) {
            nbt.m_128359_(entryNum, "");
        } else if (entry.type.equals(Boolean.class)) {
            nbt.m_128379_(entryNum, ((Boolean)value).booleanValue());
        } else if (entry.type.equals(Byte.class)) {
            nbt.m_128344_(entryNum, ((Byte)value).byteValue());
        } else if (entry.type.equals(Integer.class)) {
            nbt.m_128405_(entryNum, ((Integer)value).intValue());
        } else if (entry.type.equals(Long.class)) {
            nbt.m_128356_(entryNum, ((Long)value).longValue());
        } else if (entry.type.equals(Float.class)) {
            nbt.m_128350_(entryNum, ((Float)value).floatValue());
        } else if (entry.type.equals(Double.class)) {
            nbt.m_128347_(entryNum, ((Double)value).doubleValue());
        } else if (entry.type.equals(String.class)) {
            nbt.m_128359_(entryNum, (String)value);
        } else if (INBTSerializable.class.isAssignableFrom(entry.type)) {
            nbt.m_128365_(entryNum, ((INBTSerializable)value).serializeNBT());
        } else {
            HBM.LOGGER.warn("Data entry:{} value can't be serialized.", (Object)entry);
        }
    }

    public static Object deserializeDataEntry(CompoundTag nbt, DataEntry entry) {
        String entryNum = String.valueOf(entry.ordinal());
        if (entry.type == null) {
            return null;
        }
        if (entry.type.equals(Boolean.class)) {
            return nbt.m_128471_(entryNum);
        }
        if (entry.type.equals(Byte.class)) {
            return nbt.m_128445_(entryNum);
        }
        if (entry.type.equals(Integer.class)) {
            return nbt.m_128451_(entryNum);
        }
        if (entry.type.equals(Long.class)) {
            return nbt.m_128454_(entryNum);
        }
        if (entry.type.equals(Float.class)) {
            return Float.valueOf(nbt.m_128457_(entryNum));
        }
        if (entry.type.equals(Double.class)) {
            return nbt.m_128459_(entryNum);
        }
        if (entry.type.equals(String.class)) {
            return nbt.m_128461_(entryNum);
        }
        if (INBTSerializable.class.isAssignableFrom(entry.type)) {
            try {
                return nbt.m_128423_(entryNum);
            }
            catch (Exception e) {
                HBM.LOGGER.warn("Data entry:{} try invoke deserializeNBT method fail.", (Object)entry);
            }
        } else {
            HBM.LOGGER.warn("Data entry:{} value can't be deserialized.", (Object)entry);
        }
        return null;
    }

    public static void setByteIfPresent(CompoundTag nbt, String key, ByteConsumer setter) {
        if (nbt.m_128425_(key, 1)) {
            setter.accept(nbt.m_128445_(key));
        }
    }

    public static void setBooleanIfPresent(CompoundTag nbt, String key, BooleanConsumer setter) {
        if (nbt.m_128425_(key, 1)) {
            setter.accept(nbt.m_128471_(key));
        }
    }

    public static void setBooleanIfPresentElse(CompoundTag nbt, String key, boolean fallback, BooleanConsumer setter) {
        if (nbt.m_128425_(key, 1)) {
            setter.accept(nbt.m_128471_(key));
        } else {
            setter.accept(fallback);
        }
    }

    public static void setShortIfPresent(CompoundTag nbt, String key, ShortConsumer setter) {
        if (nbt.m_128425_(key, 2)) {
            setter.accept(nbt.m_128448_(key));
        }
    }

    public static void setIntIfPresent(CompoundTag nbt, String key, IntConsumer setter) {
        if (nbt.m_128425_(key, 3)) {
            setter.accept(nbt.m_128451_(key));
        }
    }

    public static void setLongIfPresent(CompoundTag nbt, String key, LongConsumer setter) {
        if (nbt.m_128425_(key, 4)) {
            setter.accept(nbt.m_128454_(key));
        }
    }

    public static void setFloatIfPresent(CompoundTag nbt, String key, FloatConsumer setter) {
        if (nbt.m_128425_(key, 5)) {
            setter.accept(nbt.m_128457_(key));
        }
    }

    public static void setDoubleIfPresent(CompoundTag nbt, String key, DoubleConsumer setter) {
        if (nbt.m_128425_(key, 6)) {
            setter.accept(nbt.m_128459_(key));
        }
    }

    public static void setByteArrayIfPresent(CompoundTag nbt, String key, Consumer<byte[]> setter) {
        if (nbt.m_128425_(key, 7)) {
            setter.accept(nbt.m_128463_(key));
        }
    }

    public static void setStringIfPresent(CompoundTag nbt, String key, Consumer<String> setter) {
        if (nbt.m_128425_(key, 8)) {
            setter.accept(nbt.m_128461_(key));
        }
    }

    public static void setListIfPresent(CompoundTag nbt, String key, int type, Consumer<ListTag> setter) {
        if (nbt.m_128425_(key, 9)) {
            setter.accept(nbt.m_128437_(key, type));
        }
    }

    public static void setCompoundIfPresent(CompoundTag nbt, String key, Consumer<CompoundTag> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(nbt.m_128469_(key));
        }
    }

    public static void setIntArrayIfPresent(CompoundTag nbt, String key, Consumer<int[]> setter) {
        if (nbt.m_128425_(key, 11)) {
            setter.accept(nbt.m_128465_(key));
        }
    }

    public static void setLongArrayIfPresent(CompoundTag nbt, String key, Consumer<long[]> setter) {
        if (nbt.m_128425_(key, 12)) {
            setter.accept(nbt.m_128467_(key));
        }
    }

    public static void setUUIDIfPresent(CompoundTag nbt, String key, Consumer<UUID> setter) {
        if (nbt.m_128403_(key)) {
            setter.accept(nbt.m_128342_(key));
        }
    }

    public static void setUUIDIfPresentElse(CompoundTag nbt, String key, Consumer<UUID> setter, Runnable notPresent) {
        if (nbt.m_128403_(key)) {
            setter.accept(nbt.m_128342_(key));
        } else {
            notPresent.run();
        }
    }

    public static void setBlockPosIfPresent(CompoundTag nbt, String key, Consumer<BlockPos> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(key)));
        }
    }

    public static void setCoord4DIfPresent(CompoundTag nbt, String key, Consumer<Coord4D> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(Coord4D.read(nbt.m_128469_(key)));
        }
    }

    public static void setFluidStackIfPresent(CompoundTag nbt, String key, Consumer<FluidStack> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(key)));
        }
    }

    public static void setItemStackIfPresent(CompoundTag nbt, String key, Consumer<ItemStack> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key)));
        }
    }

    public static void setItemStackOrEmpty(CompoundTag nbt, String key, Consumer<ItemStack> setter) {
        if (nbt.m_128425_(key, 10)) {
            setter.accept(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key)));
        } else {
            setter.accept(ItemStack.f_41583_);
        }
    }

    public static void setResourceLocationIfPresent(CompoundTag nbt, String key, Consumer<ResourceLocation> setter) {
        ResourceLocation value;
        if (nbt.m_128425_(key, 8) && (value = ResourceLocation.m_135820_((String)nbt.m_128461_(key))) != null) {
            setter.accept(value);
        }
    }

    public static void setResourceLocationIfPresentElse(CompoundTag nbt, String key, Consumer<ResourceLocation> setter, Runnable notPresent) {
        if (nbt.m_128425_(key, 8)) {
            ResourceLocation value = ResourceLocation.m_135820_((String)nbt.m_128461_(key));
            if (value == null) {
                notPresent.run();
            } else {
                setter.accept(value);
            }
        }
    }

    public static <REG> void setRegistryEntryIfPresentElse(CompoundTag nbt, String key, IForgeRegistry<REG> registry, Consumer<REG> setter, Runnable notPresent) {
        NBTUtils.setResourceLocationIfPresentElse(nbt, key, rl -> {
            Object reg = registry.getValue(rl);
            if (reg == null) {
                notPresent.run();
            } else {
                setter.accept(reg);
            }
        }, notPresent);
    }

    public static <REG> void setResourceKeyIfPresentElse(CompoundTag nbt, String key, ResourceKey<? extends Registry<REG>> registryName, Consumer<ResourceKey<REG>> setter, Runnable notPresent) {
        NBTUtils.setResourceLocationIfPresentElse(nbt, key, rl -> setter.accept(ResourceKey.m_135785_((ResourceKey)registryName, (ResourceLocation)rl)), notPresent);
    }

    public static <ENUM extends Enum<ENUM>> void setEnumIfPresent(CompoundTag nbt, String key, Int2ObjectFunction<ENUM> indexLookup, Consumer<ENUM> setter) {
        if (nbt.m_128425_(key, 3)) {
            setter.accept((Enum)indexLookup.apply(nbt.m_128451_(key)));
        }
    }

    public static void writeEnum(CompoundTag nbt, String key, Enum<?> e) {
        nbt.m_128405_(key, e.ordinal());
    }

    public static <V> V readRegistryEntry(CompoundTag nbt, String key, IForgeRegistry<V> registry, V fallback) {
        Object result;
        ResourceLocation rl;
        if (nbt.m_128425_(key, 8) && (rl = ResourceLocation.m_135820_((String)nbt.m_128461_(key))) != null && (result = registry.getValue(rl)) != null) {
            return (V)result;
        }
        return fallback;
    }

    public static <V> void writeRegistryEntry(CompoundTag nbt, String key, IForgeRegistry<V> registry, V entry) {
        ResourceLocation registryName = registry.getKey(entry);
        if (registryName != null) {
            nbt.m_128359_(key, registryName.toString());
        }
    }

    public static void writeResourceKey(CompoundTag nbt, String key, ResourceKey<?> entry) {
        nbt.m_128359_(key, entry.m_135782_().toString());
    }

    public static int[] blockpos2intarr(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static BlockPos intarr2blockpos(int[] arr) {
        if (arr.length < 3) {
            HBM.LOGGER.warn("load block pos failed");
            return BlockPos.f_121853_;
        }
        return new BlockPos(arr[0], arr[1], arr[2]);
    }
}

