/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class RegistryUtils {
    private RegistryUtils() {
    }

    public static ResourceLocation getName(MenuType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.MENU_TYPES, element);
    }

    public static ResourceLocation getName(ParticleType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.PARTICLE_TYPES, element);
    }

    public static ResourceLocation getName(Item element) {
        return RegistryUtils.getName(ForgeRegistries.ITEMS, element);
    }

    public static String getPath(Item element) {
        return RegistryUtils.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Block element) {
        return RegistryUtils.getName(ForgeRegistries.BLOCKS, element);
    }

    public static String getNamespace(Block element) {
        return RegistryUtils.getName(element).m_135827_();
    }

    public static String getPath(Block element) {
        return RegistryUtils.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Fluid element) {
        return RegistryUtils.getName(ForgeRegistries.FLUIDS, element);
    }

    public static ResourceLocation getName(BlockEntityType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.BLOCK_ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(EntityType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(RecipeSerializer<?> element) {
        return RegistryUtils.getName(ForgeRegistries.RECIPE_SERIALIZERS, element);
    }

    private static <T> ResourceLocation getName(IForgeRegistry<T> registry, T element) {
        return registry.getKey(element);
    }

    @Nullable
    public static ResourceLocation getNameGeneric(Object element) {
        for (Registry registry : BuiltInRegistries.f_257047_) {
            Optional resourceKey = registry.m_7854_(element);
            if (!resourceKey.isPresent()) continue;
            return ((ResourceKey)resourceKey.get()).m_135782_();
        }
        return null;
    }
}

