/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils;

import com.hbm.utils.SubChunkKey;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class SubChunkSnapshot {
    public static final SubChunkSnapshot EMPTY = new SubChunkSnapshot(new Block[]{Blocks.f_50016_}, null);
    private final Block[] palette;
    private final short[] data;

    private SubChunkSnapshot(Block[] p, short[] d) {
        this.palette = p;
        this.data = d;
    }

    public static SubChunkSnapshot getSnapshot(ServerLevel level, SubChunkKey key, boolean allowGeneration) {
        ChunkStatus status = allowGeneration ? ChunkStatus.f_62326_ : ChunkStatus.f_62314_;
        LevelChunk chunk = (LevelChunk)level.m_6522_(key.getChunkX(), key.getChunkZ(), status, allowGeneration);
        if (chunk == null) {
            return EMPTY;
        }
        int lowestSectionIndex = level.m_151564_(level.m_141937_());
        int arrayIndex = key.getSectionY() - lowestSectionIndex;
        LevelChunkSection section = chunk.m_183278_(arrayIndex);
        if (section.m_188008_()) {
            return EMPTY;
        }
        short[] data = new short[4096];
        ArrayList<Block> palette = new ArrayList<Block>();
        palette.add(Blocks.f_50016_);
        HashMap<Block, Short> idxMap = new HashMap<Block, Short>();
        idxMap.put(Blocks.f_50016_, (short)0);
        for (int ly = 0; ly < 16; ++ly) {
            for (int lz = 0; lz < 16; ++lz) {
                for (int lx = 0; lx < 16; ++lx) {
                    short idx;
                    Block block = section.m_62982_(lx, ly, lz).m_60734_();
                    if (block == Blocks.f_50016_) {
                        idx = 0;
                    } else {
                        Short e = (Short)idxMap.get(block);
                        if (e == null) {
                            idx = (short)palette.size();
                            idxMap.put(block, idx);
                            palette.add(block);
                        } else {
                            idx = e;
                        }
                    }
                    data[ly << 8 | lz << 4 | lx] = idx;
                }
            }
        }
        return new SubChunkSnapshot(palette.toArray(new Block[0]), data);
    }

    public Block getBlock(int x, int y, int z) {
        if (this == EMPTY || this.data == null) {
            return Blocks.f_50016_;
        }
        short idx = this.data[y << 8 | z << 4 | x];
        return idx >= 0 && idx < this.palette.length ? this.palette[idx] : Blocks.f_50016_;
    }
}

