/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.chunk;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChunkLoadHelper {
    public static Map<Entity, LongSet> entitiesWithChunkLoad = new HashMap<Entity, LongSet>();

    public static void forceChunk(ServerLevel level, ChunkPos chunkPos, boolean isLoad) {
        if (isLoad) {
            if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                return;
            }
            LongSet chunks = ((ForcedChunksSavedData)level.m_8895_().m_164861_(ForcedChunksSavedData::m_151483_, ForcedChunksSavedData::new, "chunks")).m_46116_();
            if (chunks.contains(chunkPos.m_45588_()) || chunks.size() >= 256) {
                return;
            }
            level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        } else {
            level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        }
    }

    public static void register(Entity entity) {
        if (ChunkLoadHelper.entityInServer(entity)) {
            entitiesWithChunkLoad.computeIfAbsent(entity, e -> new LongOpenHashSet());
            if (!entity.m_9236_().m_46749_(entity.m_20183_())) {
                ChunkPos chunkPos = new ChunkPos(entity.m_20183_());
                ChunkLoadHelper.forceChunk((ServerLevel)entity.m_9236_(), chunkPos, true);
                entitiesWithChunkLoad.get(entity).add(chunkPos.m_45588_());
            }
        }
    }

    public static void unRegister(Entity entity) {
        if (ChunkLoadHelper.entityInServer(entity) && entitiesWithChunkLoad.containsKey(entity)) {
            for (Long chunkPos : entitiesWithChunkLoad.get(entity)) {
                ChunkLoadHelper.forceChunk((ServerLevel)entity.m_9236_(), new ChunkPos(chunkPos.longValue()), false);
            }
        }
    }

    protected static boolean entityInServer(Entity entity) {
        return !entity.m_9236_().m_5776_();
    }

    @SubscribeEvent
    public static void onEntityEnterSection(EntityEvent.EnteringSection event) {
        Entity entity = event.getEntity();
        if (event.didChunkChange() && entitiesWithChunkLoad.containsKey(entity) && !entity.m_9236_().f_46443_) {
            ChunkPos newChunk = event.getNewPos().m_123251_();
            ChunkPos oldChunk = event.getOldPos().m_123251_();
            LongSet chunks = entitiesWithChunkLoad.get(entity);
            if (chunks.contains(oldChunk.m_45588_())) {
                ChunkLoadHelper.forceChunk((ServerLevel)entity.m_9236_(), oldChunk, false);
                chunks.remove(oldChunk.m_45588_());
            }
            if (!entity.m_9236_().m_46749_(entity.m_20097_())) {
                ChunkLoadHelper.forceChunk((ServerLevel)entity.m_9236_(), newChunk, true);
                chunks.add(newChunk.m_45588_());
            }
        }
    }
}

