/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.debug;

import com.hbm.HBMLang;
import com.hbm.addational_data.AdditionalDataManager;
import com.hbm.addational_data.DataEntry;
import com.hbm.entity.weapon.missile.EntityMissileTier0;
import com.hbm.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.jetbrains.annotations.Nullable;

public class ItemDebugWand
extends Item {
    public ItemDebugWand(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)HBMLang.CACHED_DATA.key()));
        if (pStack.m_41782_() && pStack.m_41737_("position") != null) {
            pTooltipComponents.add((Component)Component.m_237110_((String)HBMLang.POS_DATA.key(), (Object[])new Object[]{NbtUtils.m_129239_((CompoundTag)pStack.m_41737_("position")).m_123344_()}));
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (!pContext.m_43725_().f_46443_ && pContext.m_43723_().m_217003_(Pose.CROUCHING)) {
            Player player = pContext.m_43723_();
            BlockPos clickedPos = pContext.m_8083_();
            ItemStack itemInHand = pContext.m_43722_();
            itemInHand.m_41700_("position", (Tag)NbtUtils.m_129224_((BlockPos)clickedPos));
            ChunkPos chunkPos = new ChunkPos(clickedPos);
            ((ServerLevel)pContext.m_43725_()).m_7726_().addRegionTicket(TicketType.f_9445_, chunkPos, 0, (Object)chunkPos, true);
            player.m_213846_((Component)Component.m_237110_((String)"msg.hbm.mark_pos", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
        }
        return super.m_6225_(pContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.f_46443_ && !pPlayer.m_217003_(Pose.CROUCHING)) {
            ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
            CompoundTag posElement = itemInHand.m_41737_("position");
            if (!itemInHand.m_41782_() || posElement == null) {
                pPlayer.m_213846_((Component)Component.m_237115_((String)"msg.hbm.no_pos"));
            } else {
                BlockPos storedPos = NbtUtils.m_129239_((CompoundTag)posElement);
                BlockState markedBlock = WorldUtils.getBlockState((BlockGetter)pLevel, storedPos).orElse(Blocks.f_50016_.m_49966_());
                if (markedBlock.m_60713_(Blocks.f_50016_) || markedBlock.m_60713_(Blocks.f_50626_)) {
                    pPlayer.m_213846_((Component)Component.m_237110_((String)HBMLang.BLOCK_STATE_LOSE.key(), (Object[])new Object[]{storedPos.m_123344_()}));
                } else {
                    ItemDebugWand.createMissle(pLevel, pPlayer, pUsedHand, storedPos);
                }
                itemInHand.m_41749_("position");
            }
            ItemDebugWand.showRadData(pLevel, (Entity)pPlayer);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.m_5776_()) {
            return;
        }
    }

    public static void forceChunk(Level pLevel, Player pPlayer, BlockPos storedPos, BlockState markedBlock) {
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)pLevel), (String)"hbm", (BlockPos)storedPos, (int)SectionPos.m_123171_((int)storedPos.m_123341_()), (int)SectionPos.m_123171_((int)storedPos.m_123342_()), (boolean)false, (boolean)false);
        pPlayer.m_213846_((Component)Component.m_237110_((String)HBMLang.BLOCK_STATE_INFO.key(), (Object[])new Object[]{storedPos.m_123344_(), markedBlock.m_60734_().m_7705_()}));
    }

    public static void createMissle(Level pLevel, Player pPlayer, InteractionHand pUsedHand, BlockPos storedPos) {
        EntityMissileTier0.EntityMissileTest missileTest = new EntityMissileTier0.EntityMissileTest(pLevel, (float)pPlayer.m_20185_(), (float)(pPlayer.m_20186_() + 2.0), (float)pPlayer.m_20189_(), storedPos);
        missileTest.m_5602_((Entity)pPlayer);
        pLevel.m_7967_((Entity)missileTest);
        pPlayer.m_213846_((Component)Component.m_237110_((String)"msg.hbm.new_missile_create", (Object[])new Object[]{storedPos.m_123344_()}));
    }

    public static void addEffects(Level pLevel, Player pPlayer, BlockPos storedPos) {
        if (!pLevel.m_7232_(storedPos.m_123341_() >> 4, storedPos.m_123343_() >> 4)) {
            return;
        }
        ChunkAccess chunk = pLevel.m_46865_(storedPos);
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            AdditionalDataManager.setChunkData(levelChunk, DataEntry.RADIATION, 1000);
            pPlayer.m_213846_((Component)Component.m_237110_((String)"msg.hbm.radiation_set_at", (Object[])new Object[]{storedPos.m_123344_()}));
        }
    }

    public static void showRadData(Level pLevel, Entity pEntity) {
        Float entityRad = AdditionalDataManager.getEntityData(pEntity, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
        Float chunkRad = AdditionalDataManager.getChunkData(pLevel.m_46745_(pEntity.m_20097_()), DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f));
        pEntity.m_213846_((Component)Component.m_237110_((String)"msg.hbm.entity_chunk_rad", (Object[])new Object[]{entityRad, chunkRad}));
    }

    public static void showChunkRadData(ItemStack pStack, Level pLevel, Entity pEntity) {
        if (pStack.m_41737_("position") != null || pLevel.m_46467_() % 40L != 0L) {
            return;
        }
        ArrayList<Float> radList = new ArrayList<Float>();
        BlockPos blockPos = pEntity.m_20097_();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                LevelChunk chunk = pLevel.m_6325_(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j);
                radList.add(AdditionalDataManager.getChunkData(chunk, DataEntry.RADIATION).map(o -> Float.valueOf(((Float)o).floatValue())).orElse(Float.valueOf(0.0f)));
            }
        }
        pEntity.m_213846_((Component)Component.m_237110_((String)"msg.hbm.radiation_now", (Object[])new Object[]{((Object)radList).toString()}));
    }
}

