/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.multiblock;

import com.hbm.block.HBMMachine;
import com.hbm.blockentity.base2.DummyableBlockEntity;
import com.hbm.blockentity.base2.TileProxyBase;
import com.hbm.capabilities.HBMCaps;
import com.hbm.registries.ModBlocks;
import com.hbm.utils.DirectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class MultiblockData {
    public static final Map<Block, MultiblockData> mapping = new HashMap<Block, MultiblockData>();
    public List<Vec3i> offsets;
    public int[] dirOffsets;
    public Map<Vec3i, Map<Capability<?>, Set<Direction>>> capsMap = new HashMap();

    MultiblockData(List<Vec3i> offsets, int[] dirOffsets) {
        this.offsets = offsets;
        this.dirOffsets = dirOffsets;
    }

    MultiblockData(int ... dirOffsets) {
        this.dirOffsets = dirOffsets;
        this.offsets = MultiblockData.square(dirOffsets);
    }

    public MultiblockData addCap(Vec3i offset, Capability<?> cap, Direction ... directions) {
        this.capsMap.computeIfAbsent(offset, pos -> new HashMap()).computeIfAbsent(cap, capability -> new HashSet());
        this.capsMap.get(offset).get(cap).addAll(List.of(directions));
        if (this.capsMap.get(offset).get(cap).contains(null) && directions.length > 1) {
            this.capsMap.get(offset).get(cap).remove(null);
        }
        return this;
    }

    public MultiblockData addCap(Vec3i offset, Capability<?> cap) {
        return this.addCap(offset, cap, new Direction[]{null});
    }

    public MultiblockData addCaps(Vec3i offset, Capability<?> ... caps) {
        for (Capability<?> cap : caps) {
            this.addCap(offset, cap);
        }
        return this;
    }

    public MultiblockData addCaps(Object ... objs) {
        int[] relativePos = new int[4];
        HashSet<Capability> caps = new HashSet<Capability>();
        for (Object obj : objs) {
            if (obj instanceof Capability) {
                Capability cap = (Capability)obj;
                caps.add(cap);
                continue;
            }
            if (obj instanceof Integer) {
                Integer integer = (Integer)obj;
                relativePos[relativePos[3]] = integer;
                relativePos[3] = (relativePos[3] + 1) % 3;
                continue;
            }
            if (!(obj instanceof Direction)) continue;
            Direction direction = (Direction)obj;
            for (Capability cap : caps) {
                this.addCap(new Vec3i(relativePos[0], relativePos[1], relativePos[2]), cap, direction);
            }
        }
        return this;
    }

    public static List<Vec3i> square(int[] dim) {
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (int i = -dim[4]; i <= dim[5]; ++i) {
            for (int j = -dim[1]; j <= dim[0]; ++j) {
                for (int k = -dim[2]; k <= dim[3]; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    offsets.add(new Vec3i(i, j, k));
                }
            }
        }
        return offsets;
    }

    public static Vec3i square(int n) {
        return new Vec3i(n, n, n);
    }

    public void distributeCaps(BlockEntity be) {
        if (!(be instanceof DummyableBlockEntity) || !be.m_58898_()) {
            return;
        }
        BlockPos bePos = be.m_58899_();
        Level level = be.m_58904_();
        Direction facing = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        for (Map.Entry<Vec3i, Map<Capability<?>, Set<Direction>>> entry : this.capsMap.entrySet()) {
            Vec3i offset = entry.getKey();
            BlockPos proxyPos = bePos.m_121955_(DirectionUtils.offsetRot(offset, Direction.SOUTH, facing));
            for (Map.Entry<Capability<?>, Set<Direction>> setEntry : entry.getValue().entrySet()) {
                TileProxyBase proxy;
                Capability<?> proxyCap = setEntry.getKey();
                Set<Direction> proxyDir = setEntry.getValue().stream().map(direction -> DirectionUtils.horizRot(Direction.SOUTH, facing, direction)).collect(Collectors.toSet());
                BlockEntity blockEntity = level.m_7702_(proxyPos);
                if (!(blockEntity instanceof TileProxyBase) || (proxy = (TileProxyBase)blockEntity).getBlockEntity() == null || !proxy.getBlockEntity().equals(be)) continue;
                ((DummyableBlockEntity)be).giveProxyCapabilities(offset, proxy, proxyCap, proxyDir);
            }
        }
    }

    public static List<Vec3i> transOffsets(List<Vec3i> offsets, Direction dir) {
        ArrayList<Vec3i> result = new ArrayList<Vec3i>(offsets);
        int[] trans = switch (dir) {
            case Direction.NORTH -> new int[]{-1, 0, 0, -1};
            case Direction.EAST -> new int[]{0, -1, 1, 0};
            case Direction.SOUTH -> new int[]{1, 0, 0, 1};
            case Direction.WEST -> new int[]{0, 1, -1, 0};
            default -> new int[]{1, 0, 0, 1};
        };
        for (int i = 0; i < result.size(); ++i) {
            Vec3i v1 = (Vec3i)result.get(i);
            Vec3i v2 = new Vec3i(v1.m_123341_() * trans[0] + v1.m_123343_() * trans[2], v1.m_123342_(), v1.m_123341_() * trans[1] + v1.m_123343_() * trans[3]);
            result.set(i, v2);
        }
        return result;
    }

    static {
        mapping.put((Block)ModBlocks.machine_assembler.get(), new MultiblockData(1, 0, 2, 1, 2, 1).addCaps(HBMCaps.LONG_ENERGY, -1, 0, 1, Direction.SOUTH, 0, 0, 1, Direction.SOUTH, -1, 0, -2, Direction.NORTH, 0, 0, -2, Direction.NORTH).addCaps(ForgeCapabilities.ITEM_HANDLER, 1, 0, -1, Direction.EAST, -2, 0, 0, Direction.WEST));
        mapping.put((Block)HBMMachine.CHEMPLANT.get(), new MultiblockData(2, 0, 2, 1, 2, 1).addCaps(HBMCaps.LONG_ENERGY, ForgeCapabilities.FLUID_HANDLER, -1, 0, 1, Direction.SOUTH, 0, 0, 1, Direction.SOUTH, -1, 0, -2, Direction.NORTH, 0, 0, -2, Direction.NORTH).addCaps(ForgeCapabilities.ITEM_HANDLER, 1, 0, -1, Direction.EAST, -2, 0, 0, Direction.WEST));
        mapping.put((Block)ModBlocks.bomb_boy.get(), new MultiblockData(0, 0, 0, 0, 1, 1));
        mapping.put((Block)ModBlocks.bomb_custom.get(), mapping.get(ModBlocks.bomb_boy.get()));
        mapping.put((Block)ModBlocks.bomb_fat_man.get(), new MultiblockData(1, 0, 0, 1, 1, 1));
        mapping.put((Block)HBMMachine.LAUNCH_PAD.get(), new MultiblockData(0, 0, 1, 1, 1, 1));
        mapping.put((Block)ModBlocks.machine_rbmk_base.get(), new MultiblockData(0, 0, 0, 0, 0, 0));
        mapping.put((Block)ModBlocks.machine_cracking_tower.get(), new MultiblockData(0, 0, 3, 3, 2, 3).addCap(new Vec3i(0, 0, -2), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(2, 0, 0), ForgeCapabilities.FLUID_HANDLER, Direction.EAST).addCap(new Vec3i(0, 0, 2), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(-2, 0, 0), ForgeCapabilities.FLUID_HANDLER, Direction.WEST).addCap(new Vec3i(1, 0, 2), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH));
        mapping.put((Block)ModBlocks.machine_cooling_tower.get(), new MultiblockData(12, 0, 4, 4, 4, 4).addCap(new Vec3i(0, 0, 4), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(4, 0, 0), ForgeCapabilities.FLUID_HANDLER, Direction.EAST).addCap(new Vec3i(0, 0, -4), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(-4, 0, 0), ForgeCapabilities.FLUID_HANDLER, Direction.WEST).addCap(new Vec3i(3, 0, 3), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(-3, 0, 3), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(3, 0, -3), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(-3, 0, -3), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(0, 1, 4), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(4, 1, 0), ForgeCapabilities.FLUID_HANDLER, Direction.EAST).addCap(new Vec3i(0, 1, -4), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(-4, 1, 0), ForgeCapabilities.FLUID_HANDLER, Direction.WEST).addCap(new Vec3i(3, 1, 3), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(-3, 1, 3), ForgeCapabilities.FLUID_HANDLER, Direction.SOUTH).addCap(new Vec3i(3, 1, -3), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH).addCap(new Vec3i(-3, 1, -3), ForgeCapabilities.FLUID_HANDLER, Direction.NORTH));
        int[] turbineDims = new int[]{2, 0, 1, 1, 4, 5};
        ArrayList<Vec3i> turbineOffsets = new ArrayList<Vec3i>(MultiblockData.square(turbineDims));
        Vec3i extraWest = new Vec3i(-5, 1, 0);
        if (!turbineOffsets.contains(extraWest)) {
            turbineOffsets.add(extraWest);
        }
        mapping.put((Block)ModBlocks.machine_turbine_gas.get(), new MultiblockData(turbineOffsets, turbineDims).addCap(new Vec3i(-1, 0, -1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(-1, 0, 1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(-2, 0, -1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(-2, 0, 1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(2, 0, -1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(2, 0, 1), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(3, 1, 0), ForgeCapabilities.FLUID_HANDLER, Direction.values()).addCap(new Vec3i(0, 1, -1), ForgeCapabilities.ENERGY, Direction.values()).addCap(new Vec3i(0, 1, -1), HBMCaps.LONG_ENERGY, Direction.values()));
        ArrayList<Vec3i> zirnoxOffsets = new ArrayList<Vec3i>(MultiblockData.square(new int[]{1, 0, 2, 2, 2, 2}));
        for (int y = 2; y <= 4; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    zirnoxOffsets.add(new Vec3i(x, y, z));
                }
            }
            zirnoxOffsets.add(new Vec3i(-2, y, 0));
            zirnoxOffsets.add(new Vec3i(2, y, 0));
        }
        mapping.put((Block)ModBlocks.machine_zirnox.get(), new MultiblockData(zirnoxOffsets, new int[]{1, 0, 2, 2, 2, 2}).addCap(new Vec3i(-2, 1, 0), ForgeCapabilities.FLUID_HANDLER, Direction.WEST).addCap(new Vec3i(2, 1, 0), ForgeCapabilities.FLUID_HANDLER, Direction.EAST).addCap(new Vec3i(-2, 3, 0), ForgeCapabilities.FLUID_HANDLER, Direction.WEST).addCap(new Vec3i(2, 3, 0), ForgeCapabilities.FLUID_HANDLER, Direction.EAST));
        mapping.put((Block)ModBlocks.machine_icf.get(), new MultiblockData(new ArrayList<Vec3i>(), new int[]{0, 0, 0, 0, 0, 0}));
        mapping.put((Block)ModBlocks.machine_research_reactor.get(), new MultiblockData(2, 0, 0, 0, 0, 0));
        mapping.put((Block)ModBlocks.machine_reactor_breeding.get(), new MultiblockData(2, 0, 0, 0, 0, 0));
    }
}

