/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AudioWrapper {
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public float range = 100.0f;
    public boolean isRepeat = true;
    public boolean isPlaying = false;
    public SoundEvent sound;
    public SoundSource source = SoundSource.NEUTRAL;
    public SimpleSoundInstance soundInstance;

    public AudioWrapper() {
    }

    public AudioWrapper(SoundEvent sound, SoundSource source) {
        this.sound = sound;
        this.source = source;
    }

    public AudioWrapper(SoundEvent sound, float volume, float pitch, float range, boolean isRepeat) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.range = range;
        this.isRepeat = isRepeat;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLoopSound(Vec3 pPos, long pSeed) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (this.soundInstance == null) {
            this.soundInstance = new SimpleSoundInstance(this.sound, this.source, this.volume, this.pitch, RandomSource.m_216335_((long)pSeed), true, 0, SoundInstance.Attenuation.NONE, pPos.m_7096_(), pPos.m_7098_(), pPos.m_7094_());
        }
        if (!soundManager.m_120403_((SoundInstance)this.soundInstance)) {
            soundManager.m_120367_((SoundInstance)this.soundInstance);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopLoopSound() {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        soundManager.m_120399_((SoundInstance)this.soundInstance);
        this.soundInstance = null;
    }

    public void setKeepAlive(int keepAlive) {
    }

    public void keepAlive() {
    }

    public void updatePosition(float x, float y, float z) {
    }

    public void updateVolume(float volume) {
        this.volume = volume;
    }

    public void updateRange(float range) {
        this.range = range;
    }

    public void updatePitch(float pitch) {
        this.pitch = pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getRange() {
        return this.range;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setDoesRepeat(boolean repeats) {
        this.isRepeat = repeats;
    }

    public void startSound() {
    }

    public void stopSound() {
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }
}

