/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.transport_net;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidNetwork {
    private final Set<BlockPos> transmitters = new HashSet<BlockPos>();
    private Fluid fluid = Fluids.f_76191_;

    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid == null ? Fluids.f_76191_ : fluid;
    }

    public void addTransmitter(BlockPos pos) {
        this.transmitters.add(pos.m_7949_());
    }

    public void removeTransmitter(BlockPos pos) {
        this.transmitters.remove(pos);
    }

    public boolean isEmpty() {
        return this.transmitters.isEmpty();
    }

    public boolean contains(BlockPos pos) {
        return this.transmitters.contains(pos);
    }

    public Set<BlockPos> getTransmitters() {
        return Collections.unmodifiableSet(this.transmitters);
    }

    public void absorb(FluidNetwork other) {
        if (other == null) {
            return;
        }
        other.transmitters.forEach(this.transmitters::add);
        if (this.fluid == Fluids.f_76191_) {
            this.fluid = other.fluid;
        }
    }

    public void replaceTransmitters(Set<BlockPos> newMembers) {
        this.transmitters.clear();
        if (newMembers != null) {
            newMembers.stream().filter(Objects::nonNull).forEach(pos -> this.transmitters.add(pos.m_7949_()));
        }
    }

    public boolean canMergeWith(FluidNetwork other) {
        if (other == null) {
            return false;
        }
        if (this.fluid == Fluids.f_76191_ || other.fluid == Fluids.f_76191_) {
            return true;
        }
        return this.fluid == other.fluid;
    }

    public void tick() {
    }
}

