/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.utils.transport_net;

import com.hbm.block.logistic.AbstractPipeBlock;
import com.hbm.blockentity.machine.PipeEntity;
import com.hbm.utils.transport_net.FluidNetwork;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class FluidNetworkSystem {
    public static final Map<Level, FluidNetworkSystem> INSTANCES = new HashMap<Level, FluidNetworkSystem>();
    private final Level level;
    private final Map<BlockPos, FluidNetwork> pipeIndex = new HashMap<BlockPos, FluidNetwork>();
    private final List<FluidNetwork> networks = new ArrayList<FluidNetwork>();

    private FluidNetworkSystem(Level level) {
        this.level = level;
    }

    public static FluidNetworkSystem getOrCreate(Level level) {
        return INSTANCES.computeIfAbsent(level, FluidNetworkSystem::new);
    }

    public void tick() {
        if (this.networks.isEmpty()) {
            return;
        }
        this.networks.forEach(FluidNetwork::tick);
    }

    public void rebuildNetwork(BlockPos pos) {
        if (this.level.f_46443_) {
            return;
        }
        this.removeFromCurrent(pos);
        if (!(this.level.m_8055_(pos).m_60734_() instanceof AbstractPipeBlock)) {
            return;
        }
        Set<FluidNetwork> neighbouring = this.collectNeighbourNetworks(pos);
        if (neighbouring.isEmpty()) {
            this.create(pos);
            return;
        }
        FluidNetwork primary = neighbouring.iterator().next();
        this.join(pos, primary);
        if (neighbouring.size() > 1) {
            this.connect(neighbouring.toArray(new FluidNetwork[0]));
        }
    }

    public void load(ChunkPos chunkPos, BlockPos pos) {
        this.rebuildNetwork(pos);
    }

    public void unload(ChunkPos chunkPos, BlockPos pos) {
        this.leave(pos);
    }

    public void create(BlockPos pos) {
        FluidNetwork network = new FluidNetwork();
        network.addTransmitter(pos);
        this.networks.add(network);
        this.pipeIndex.put(pos, network);
        this.bindPipe(pos, network);
    }

    public void join(BlockPos pos, FluidNetwork target) {
        if (target == null) {
            this.create(pos);
            return;
        }
        this.removeFromCurrent(pos);
        target.addTransmitter(pos);
        this.pipeIndex.put(pos, target);
        this.bindPipe(pos, target);
    }

    public void leave(BlockPos pos) {
        FluidNetwork current = this.pipeIndex.get(pos);
        if (current == null) {
            this.bindPipe(pos, null);
            return;
        }
        this.removeFromCurrent(pos);
        if (current.isEmpty()) {
            this.networks.remove(current);
        } else {
            this.split(current);
        }
    }

    public void connect(FluidNetwork ... candidates) {
        if (candidates == null || candidates.length <= 1) {
            return;
        }
        FluidNetwork primary = null;
        for (FluidNetwork candidate : candidates) {
            if (candidate == null) continue;
            if (primary == null) {
                primary = candidate;
                continue;
            }
            if (!primary.canMergeWith(candidate)) continue;
            this.transfer(candidate, primary);
        }
    }

    public void split(FluidNetwork network) {
        if (network == null || network.isEmpty()) {
            return;
        }
        List<Set<BlockPos>> components = this.findComponents(network);
        if (components.size() <= 1) {
            return;
        }
        Iterator<Set<BlockPos>> iterator = components.iterator();
        Set<BlockPos> base = iterator.next();
        network.replaceTransmitters(base);
        base.forEach(pos -> this.pipeIndex.put((BlockPos)pos, network));
        this.bindAll(base, network);
        while (iterator.hasNext()) {
            Set<BlockPos> cluster = iterator.next();
            FluidNetwork splitNetwork = new FluidNetwork();
            splitNetwork.setFluid(network.getFluid());
            cluster.forEach(splitNetwork::addTransmitter);
            this.networks.add(splitNetwork);
            cluster.forEach(pos -> {
                this.pipeIndex.put((BlockPos)pos, splitNetwork);
                this.bindPipe((BlockPos)pos, splitNetwork);
            });
        }
    }

    private void transfer(FluidNetwork source, FluidNetwork target) {
        if (source == null || source == target) {
            return;
        }
        source.getTransmitters().forEach(pos -> {
            target.addTransmitter((BlockPos)pos);
            this.pipeIndex.put((BlockPos)pos, target);
            this.bindPipe((BlockPos)pos, target);
        });
        if (target.getFluid() == Fluids.f_76191_) {
            target.setFluid(source.getFluid());
        }
        this.networks.remove(source);
    }

    private void removeFromCurrent(BlockPos pos) {
        FluidNetwork network = this.pipeIndex.remove(pos);
        if (network == null) {
            this.bindPipe(pos, null);
            return;
        }
        network.removeTransmitter(pos);
        this.bindPipe(pos, null);
    }

    private Set<FluidNetwork> collectNeighbourNetworks(BlockPos pos) {
        LinkedHashSet<FluidNetwork> networks = new LinkedHashSet<FluidNetwork>();
        for (Direction direction : Direction.values()) {
            FluidNetwork neighbour = this.pipeIndex.get(pos.m_121945_(direction));
            if (neighbour == null) continue;
            networks.add(neighbour);
        }
        return networks;
    }

    private List<Set<BlockPos>> findComponents(FluidNetwork source) {
        HashSet<BlockPos> remaining = new HashSet<BlockPos>(source.getTransmitters());
        ArrayList<Set<BlockPos>> result = new ArrayList<Set<BlockPos>>();
        while (!remaining.isEmpty()) {
            BlockPos start = (BlockPos)remaining.iterator().next();
            HashSet<BlockPos> component = new HashSet<BlockPos>();
            ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
            queue.add(start);
            remaining.remove(start);
            while (!queue.isEmpty()) {
                BlockPos current = (BlockPos)queue.poll();
                component.add(current);
                BlockState state = this.level.m_8055_(current);
                if (!(state.m_60734_() instanceof AbstractPipeBlock)) continue;
                for (Direction direction : Direction.values()) {
                    BlockPos next;
                    BooleanProperty prop = (BooleanProperty)PipeBlock.f_55154_.get(direction);
                    if (!state.m_61138_((Property)prop) || !((Boolean)state.m_61143_((Property)prop)).booleanValue() || !remaining.remove(next = current.m_121945_(direction))) continue;
                    queue.add(next);
                }
            }
            result.add(component);
        }
        return result;
    }

    private void bindPipe(BlockPos pos, FluidNetwork network) {
        BlockEntity blockEntity = this.level.m_7702_(pos);
        if (!(blockEntity instanceof PipeEntity)) {
            return;
        }
        PipeEntity pipeEntity = (PipeEntity)blockEntity;
        pipeEntity.network = network;
    }

    private void bindAll(Set<BlockPos> positions, FluidNetwork network) {
        positions.forEach(pos -> this.bindPipe((BlockPos)pos, network));
    }
}

