/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.structure;

import com.hbm.world.structure.ModStructureProcessors;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureFoundationProcessor
extends StructureProcessor {
    public static final Codec<StructureFoundationProcessor> CODEC = Codec.unit(StructureFoundationProcessor::new);

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ModStructureProcessors.FOUNDATION_PROCESSOR.get();
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos pivot, BlockPos offset, StructureTemplate.StructureBlockInfo templateInfo, StructureTemplate.StructureBlockInfo placedInfo, StructurePlaceSettings settings) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!placedInfo.f_74676_().m_60795_()) {
                this.fillFoundationBelow(serverLevel, placedInfo.f_74675_());
            }
        }
        return placedInfo;
    }

    private void fillFoundationBelow(ServerLevel level, BlockPos structurePos) {
        BlockState state;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(structurePos.m_123341_(), structurePos.m_123342_() - 1, structurePos.m_123343_());
        int maxFoundationDepth = 64;
        int filled = 0;
        while (cursor.m_123342_() > level.m_141937_() + 10 && filled < 64 && !StructureFoundationProcessor.isStableBlock(state = level.m_8055_((BlockPos)cursor))) {
            if (state.m_60795_()) {
                level.m_7731_((BlockPos)cursor, Blocks.f_50069_.m_49966_(), 3);
                ++filled;
            }
            cursor.m_122184_(0, -1, 0);
        }
    }

    private static boolean isStableBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_49994_) || state.m_60713_(Blocks.f_50334_) || state.m_60713_(Blocks.f_50228_) || state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_50062_) || state.m_60713_(Blocks.f_152550_) || state.m_60713_(Blocks.f_50122_);
    }
}

