/****************************************************************************
*  Copyright 2025 hoooooz  (https://github.com/hoooooz)                     *
*                                                                           *
*  Licensed under the Apache License, Version 2.0 (the "License");          *
*  you may not use this file except in compliance with the License.         *
*  You may obtain a copy of the License at                                  *
*                                                                           *
*     http://www.apache.org/licenses/LICENSE-2.0                            *
*                                                                           *
*  Unless required by applicable law or agreed to in writing, software      *
*  distributed under the License is distributed on an "AS IS" BASIS,        *
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. *
*  See the License for the specific language governing permissions and      *
*  limitations under the License.                                           *
*                                                                           *
****************************************************************************/
#include ".\zero_strm_write.h"

extern_fsm_initialiser(enqueue,
    args(zero_strm_write_t *ptStreamWrite
    ));

extern_fsm_initialiser(stream_write_flush,
    args(zero_strm_write_t *ptStreamWrite,zero_strm_mem_blk_t **pptByteFifo,zero_strm_dma_send_data_fn *fnDmaStart
    ))



void zero_strm_write_init(zero_strm_write_t *ptThis,zero_strm_write_cfg_t *ptCfg)
{
    if (NULL == ptThis 
        || NULL == ptCfg) {
        return;
    }
    
    write_fifo_t *ptAddr = ptCfg->pchBuffer;
    uint8_t chCnt        = ptCfg->hwSize/sizeof(write_fifo_t);
    memset(&this,0,sizeof(zero_strm_write_t));
     
    zero_strm_block_fifo_init(&(this.tMemBlockFifo)); 
    for(uint8_t chIndex = 0;chIndex < chCnt;chIndex++) {
        ptAddr[chIndex].tList.tSizeInByte = WRITE_BUFF_CNT;
        zero_strm_block_free(&(this.tMemBlockFifo),&ptAddr[chIndex].tList);
    }
     
    this.bBusy = false;
    this.ptByteFifoCpl = NULL;
    this.fnDmaStart = ptCfg->fnDmaSendData;
    
    this.ptByteFifo = zero_strm_block_new(&this.tMemBlockFifo);
    zero_strm_init_byte_fifo_empty(&(this.tByteFifo),this.ptByteFifo->chMemory,this.ptByteFifo->tSizeInByte);    
    this.ptByteFifo->tSizeInByte = 0;
    
    init_fsm(enqueue,&(this.fsmEnqueue),
        args(&this
    ));

    init_fsm(stream_write_flush,&(this.fsmFlushAuto),
        args(&this,              
            &(this.ptByteFifoCpl), 
            this.fnDmaStart   
    )); 
            
    init_fsm(stream_write_flush,&(this.fsmFlushManual),
        args(&this,            
            &(this.ptByteFifo),      
            this.fnDmaStart
    ));            
}



bool zero_strm_write(zero_strm_write_t *ptThis,byte tByte)
{
    bool bRet = false;
    if ( NULL == ptThis ) {
        return bRet;
    }
    
    if ( fsm_rt_cpl == call_fsm(enqueue,&(this.fsmEnqueue),args(tByte) ) ) {
        bRet = true;
    }
    
    return bRet;
}

void zero_strm_write_rest_of_data(zero_strm_write_t *ptThis)
{
    if ( NULL == ptThis ) {
        return ;
    }
    
    call_fsm(stream_write_flush,&(this.fsmFlushManual));
}
void zero_strm_dma_send_data_cpl_event_handler(zero_strm_write_t *ptThis)
{
    if (NULL == ptThis) {
        return ;
    }
        
    zero_strm_block_free(&this.tMemBlockFifo,this.ptFifoSend);  
    this.bBusy = false; 
    
    call_fsm(stream_write_flush,&(this.fsmFlushAuto));           
}
