@tool
class_name NameDialog extends Window

@onready var _panel: Panel = $Panel
@onready var _name_edit: LineEdit = $Margin/Content/NameEdit
@onready var _ok_button: Button = $Margin/Content/Margin/Buttons/OK

var _on_name_dialog_close: Callable


func _ready() -> void:
	var style_box := StyleBoxFlat.new()
	style_box.bg_color = EditorInterface.get_editor_theme().get_color("base_color", "Editor")
	_panel.add_theme_stylebox_override("panel", style_box)
	min_size = get_contents_minimum_size()
	reset_size()


func popup_create(entity: String, on_name_dialog_close: Callable) -> void:
	_popup(tr("Create"), entity, true, "", on_name_dialog_close)


func popup_rename(entity: String, current_name: String, on_name_dialog_close: Callable) -> void:
	_popup(tr("Rename"), entity, true, current_name, on_name_dialog_close)


func popup_delete(entity: String, current_name: String, on_name_dialog_close: Callable) -> void:
	_popup(tr("Delete"), entity, false, current_name, on_name_dialog_close)


func _popup(action: String, entity: String, editable: bool, current_name: String, on_name_dialog_close: Callable) -> void:
	_on_name_dialog_close = on_name_dialog_close
	_set_title(action, entity)
	_ok_button.text = action
	_name_edit.editable = editable
	_name_edit.text = current_name
	if editable:
		_name_edit.select_all()
		_name_edit.grab_focus.call_deferred()
	else:
		_ok_button.grab_focus.call_deferred()
	popup_centered()


func _set_title(action: String, entity: String) -> void:
	title = "Story - "+action+" "+entity


func _on_close_requested() -> void:
	_close_name_dialog(false)


func _on_name_edit_text_submitted(_new_text: String) -> void:
	_close_name_dialog(true)


func _on_name_edit_gui_input(event: InputEvent) -> void:
	if event.is_action("ui_cancel"):
		_close_name_dialog(false)


func _on_ok_pressed() -> void:
	_close_name_dialog(true)


func _on_cancel_pressed() -> void:
	_close_name_dialog(false)


func _close_name_dialog(ok: bool) -> void:
	if _on_name_dialog_close:
		_on_name_dialog_close.call(_name_edit.text, ok)
	hide()
