@tool
class_name StoryFileLoader extends ResourceFormatLoader


func _exists(path: String) -> bool:
	return StoryFile.is_path(path)


func _get_recognized_extensions() -> PackedStringArray:
	return [StoryFile.EXTENSION]


func _get_resource_script_class(path: String) -> String:
	return "story_file.gd" if StoryFile.is_path(path) else ""


func _get_resource_type(path: String) -> String:
	return "StoryFile" if StoryFile.is_path(path) else ""


func _get_resource_uid(path: String) -> int:
	if StoryFile.is_path(path):
		var root = StoryFile._parse(path)
		if root is Array:
			return StoryFile._get_uid(root)
	return ResourceUID.INVALID_ID


func _handles_type(type: StringName) -> bool:
	return type == "StoryFile"


func _load(path: String, _original_path: String, _use_sub_threads: bool, cache_mode: int) -> Variant:
	if !FileAccess.file_exists(path):
		return Error.ERR_FILE_NOT_FOUND

	if StoryFile.is_path(path):
		print_verbose("StoryFileLoader load path: ", path, " (cache mode ", cache_mode, ")")

		if cache_mode == CACHE_MODE_IGNORE || cache_mode == CACHE_MODE_IGNORE_DEEP:
			var file := StoryFile.new()
			assert(file._open(path) == Error.OK, "failed to open story file %s (cache mode ignore)" % file.resource_path)
			return file

		var cached = ResourceLoader.get_cached_ref(path)
		if cached:
			if cache_mode == CACHE_MODE_REPLACE:
				var file := StoryFile.new()
				assert(file._open(path) == Error.OK, "failed to open story file %s (cache mode replace)" % file.resource_path)
				cached._original = file._original
			return cached

		var file := StoryFile.new()
		file.resource_path = path
		assert(file._open() == Error.OK, "failed to open story file %s (cache mode reuse)" % file.resource_path)
		return file

	return Error.ERR_FILE_UNRECOGNIZED


func _recognize_path(path: String, _type: StringName) -> bool:
	return StoryFile.is_path(path)
