@tool
class_name StoryPartRef extends Object


func _init() -> void:
	push_error("StoryPartRef: do not initialize")


static func by(part: StoryFile.Part, story_file_path: String, part_name: String) -> Resource:
	match part:
		StoryFile.Part.NOTE:
			var ref := StoryNoteRef.new()
			ref.file_path = story_file_path
			ref.note_name = part_name
			return ref

		StoryFile.Part.TALK:
			var ref := StoryTalkRef.new()
			ref.file_path = story_file_path
			ref.talk_name = part_name
			return ref

		_:
			push_error("StoryPartRef.by: unknown part %s" % part)
			return null


static func part_name(part: StoryFile.Part, story_part_ref: Object) -> String:
	match part:
		StoryFile.Part.NOTE:
			return (story_part_ref as StoryNoteRef).note_name

		StoryFile.Part.TALK:
			return (story_part_ref as StoryTalkRef).talk_name

		_:
			push_error("StoryPartRef.part_name: unknown part %s" % part)
			return ""
