@tool
class_name StoryPartSelectorEditor extends EditorProperty

const StoryPartSelectorDialog := preload("story_part_selector_dialog.tscn")

var _part: StoryFile.Part
var _editor: HBoxContainer
var _assign: Button
var _menu: MenuButton
var _dialog: Window


func _init(part: StoryFile.Part) -> void:
	_part = part
	_editor = HBoxContainer.new()
	_editor.size_flags_horizontal = Control.SIZE_EXPAND_FILL
	_editor.size_flags_vertical = Control.SIZE_EXPAND_FILL
	_assign = Button.new()
	_assign.expand_icon = true
	_assign.size_flags_horizontal = Control.SIZE_EXPAND_FILL
	_assign.pressed.connect(_on_assign_click)
	_editor.add_child(_assign)
	_menu = MenuButton.new()
	_menu.icon = _get_editor_icon("GuiTabMenuHl")
	var menu_popup := _menu.get_popup()
	menu_popup.add_icon_item(_get_editor_icon("Clear"), tr("Clear"))
	menu_popup.index_pressed.connect(_menu_index_pressed)
	_editor.add_child(_menu)
	add_child(_editor)
	add_focusable(_assign)
	_dialog = StoryPartSelectorDialog.instantiate()
	_dialog.hide()
	add_child(_dialog)
	_update_property()


func _update_property() -> void:
	var object := get_edited_object()
	var part: Resource = null
	if object != null:
		part = object.get(get_edited_property())
	if part is StoryNoteRef:
		_assign.alignment = HORIZONTAL_ALIGNMENT_LEFT
		_assign.flat = true
		_assign.icon = StoryFile.NoteIcon
		_assign.text = part.note_name
	elif part is StoryTalkRef:
		_assign.alignment = HORIZONTAL_ALIGNMENT_LEFT
		_assign.flat = true
		_assign.icon = StoryFile.TalkIcon
		_assign.text = part.talk_name
	else:
		_assign.alignment = HORIZONTAL_ALIGNMENT_CENTER
		_assign.flat = false
		_assign.icon = null
		_assign.text = tr("Assign...")


func _on_assign_click() -> void:
	var callback := func(story_part_ref: Resource, ok: bool):
		if ok:
			get_edited_object().set(get_edited_property(), story_part_ref)
			emit_changed(get_edited_property(), story_part_ref)
	var preselected: Resource = null
	var value := get_edited_object().get(get_edited_property())
	if value is StoryNoteRef || value is StoryTalkRef:
		preselected = value
	_dialog.popup_assign(_part, preselected, callback)


func _menu_index_pressed(index: int) -> void:
	match index:
		0:
			get_edited_object().set(get_edited_property(), null)
			emit_changed(get_edited_property(), null)


static func _get_editor_icon(name: StringName) -> Texture2D:
	return EditorInterface.get_editor_theme().get_icon(name, "EditorIcons")
