@tool
class_name StoryTalkSelector extends EditorInspectorPlugin


func _can_handle(_object: Object) -> bool:
	return true


func _parse_property(object: Object, type: Variant.Type, name: String, _hint_type: PropertyHint, hint_string: String, _usage_flags: int, _wide: bool) -> bool:
	if type != TYPE_OBJECT:
		return false
	if hint_string != "StoryTalkRef":
		return false
	var editor := StoryPartSelectorEditor.new(StoryFile.Part.TALK)
	editor.set_object_and_property(object, name)
	add_property_editor(name, editor)
	return true
