export default {
  pages: {
    login: {
      accountLogin: '账号登录',
      subTitle: '请使用您的账号密码登录系统',
      usernamePlaceholder: '请输入用户名',
      passwordPlaceholder: '请输入密码',
      rememberMe: '记住我',
      forgotPassword: '忘记密码？',
      loginButton: '登录',
      loginButtonLoading: '登录中...',
      noAccount: '还没有账号？',
      register: '立即注册',
      loginSuccess: '登录成功',
      welcomeBack: '欢迎回来',
      loginFailed: '登录失败',
    },
    system: {
      menu: {
        title: '菜单列表',
        menuTitle: '菜单标题',
        type: '类型',
        path: '路径',
        component: '组件',
        menuType: '菜单类型',
        menuIcon: '菜单图标',
        addMenu: '新增菜单',
        editMenu: '编辑菜单',
        routePath: '路由地址',
        componentPath: '组件地址',
        menuTitleLabel: '菜单标题',
        menuI18nKey: '菜单国际化标题 key',
        linkMode: '外链模式',
        linkAddress: '外链地址',
        menuOrder: '菜单排序',
        hideInMenu: '隐藏菜单',
        hideInTabs: '标签栏中隐藏',
        hideInBreadcrumb: '面包屑中隐藏',
        keepAlive: '缓存组件',
        pageLayout: '页面包含布局',
        embedded: '内嵌',
        externalLink: '外链',
      },
      user: {
        title: '用户列表',
        username: '用户名',
        nickname: '用户昵称',
        nicknameShort: '昵称',
        gender: '性别',
        email: '邮箱',
        phone: '手机号',
        password: '密码',
        role: '所属角色',
        addUser: '新增用户',
        editUser: '编辑用户',
        usernameTooltip: '用户名',
      },
      role: {
        title: '角色列表',
        roleName: '角色名',
        roleCode: '角色编码',
        addRole: '新增角色',
        editRole: '编辑角色',
        roleNameTooltip: '角色名',
        roleCodeTooltip: '角色编码',
      },
    },
    demos: {
      // Wang Editor demo
      wangEditor: {
        title: 'ProWangEditor 富文本编辑器示例',
        subtitle: '展示 ProWangEditor 全局组件的各种用法和配置选项',
        basicUsage: '基本用法',
        editorHeight: '编辑器高度',
        status: '状态',
        disabled: '是否禁用',
        successStatus: '成功状态',
        errorStatus: '错误状态',
        warningStatus: '警告状态',
        usingProForm: '使用 pro-form 校验',
        usingNForm: '使用 n-form 校验',
        richText: '富文本',
        submit: '提交',
        validate: '验证',
        pleaseEnterContent: '请输入内容',
        validateSuccess: '验证成功',
        validateFailed: '验证失败',
        editorCreated: '编辑器创建完成',
        editorDestroyed: '编辑器销毁',
      },
      access: {
        toggle: {
          toggleMode: '切换权限模式',
          toggleAccount: '切换账号',
          frontendControl: '前端权限控制',
          backendControl: '后端权限控制',
          afterToggleCheck: '切换权限模式后查看【左侧菜单->系统管理】',
          afterAccountCheck: '切换账号后查看【左侧菜单->系统管理】',
          superAdmin: '超级管理员',
          admin: '普通管理员',
          user: '普通用户',
        },
      },
      icon: {
        remoteSearch1: '远程搜索-风格1',
        remoteSearch2: '远程搜索-风格2',
        singleIcon: '单选图标',
        multipleIcon: '多选图标',
        remoteSearchTooltip1: '回显时远程搜索 options',
        remoteSearchTooltip2: '回显时合并 options',
      },
      download: {
        title: '文件下载',
        fileDownload: '根据文件地址下载文件',
        imageDownload: '根据地址下载图片',
        textDownload: '文本下载',
        base64Download: 'base64流下载',
        requestDownload: '请求下载',
        fileUrlPlaceholder: '请输入文件URL',
        imageUrlPlaceholder: '请输入图片URL',
        textContentPlaceholder: '请输入要下载的文本内容',
        base64DataPlaceholder: '请输入base64数据',
        requestUrlPlaceholder: '请输入请求URL',
        downloadFile: '下载文件',
        downloadImage: '下载图片',
        downloadText: '下载文本',
        downloadBase64: '下载base64数据',
        getBlob: '获取Blob',
        fetchBlobResponse: '获取Response',
        downloadSuccess: '下载成功',
        downloadFailed: '下载失败',
        getBlobSuccess: '获取Blob成功',
        getBlobFailed: '获取Blob失败',
        getResponseSuccess: '获取Response成功',
        getResponseFailed: '获取Response失败',
        blobSize: '大小',
        responseStatus: '状态',
        // 工具函数相关
        extractFilenameFromUrl: '从URL中提取文件名',
        urlAddress: 'URL地址',
        blobDownload: '通用的Blob下载函数',
        blobObject: 'Blob对象',
        filename: '文件名',
        externalUrl: '外部URL',
        address: '地址',
        downloadFileFailed: '下载文件失败',
        downloadImageFailed: '下载图片失败',
        downloadTextFailed: '下载文本失败',
        downloadBase64Failed: '下载base64数据失败',
        requestUrl: '请求URL',
        requestOptions: '请求选项',
      },
      nested: {
        title: '嵌套路由演示',
        description: '演示嵌套路由功能，包含列表页和详情页',
        goToDetail: '点击跳转详情页',
        detailTitle: '详情页',
        detailDescription: '详情页，它不在菜单中，也可以高亮菜单',
        backToList: '返回列表页',
      },
      keepAlive: {
        basicCache: {
          title: '基础缓存',
          description: '这是一个演示 keep-alive 基础功能的页面',
          inputPlaceholder: '请输入内容测试缓存...',
        },
        conditionalCache: {
          title: '条件缓存',
          description: '只有从多标签页面进入时，才会缓存',
          inputPlaceholder: '请输入内容测试缓存...',
        },
      },
      pageComponent: {
        title: '页面级组件',
        description: '页面级别的 loading 效果，开启 loading 后可以切换布局或折叠查看效果',
        description2: '可以传递丰富的 loading 配置',
        description3: '底部固定 footer，它也是适配布局的',
        itemText: '你好啊，',
        startLoading: '开启 Loading',
        randomNumber: '随机数字',
        currentNumber: '当前数字',
        loadingText: '加载中...',
        loadingTime: '加载时间',
      },
      loading: {
        title: 'v-loading 指令使用示例',
        basicUsage: {
          title: '1. v-loading 基础用法',
          description: '这是一个内容区域',
          description2: '当 loading 激活时，会显示加载遮罩',
          description3: '点击下方按钮可以切换 loading 状态',
          showButton: '开启 Loading',
          hideButton: '关闭 Loading',
        },
        fullscreen: {
          title: '2. v-loading.fullscreen 全屏加载',
          description: '全屏加载示例',
          description2: '使用 .fullscreen 修饰符可以创建全屏加载效果',
          description3: '遮罩会覆盖整个视口',
          showButton: '开启 全屏 Loading',
          hideButton: '关闭 全屏 Loading',
        },
        lock: {
          title: '3. v-loading.lock 锁定滚动',
          description: '锁定滚动示例',
          description2: '使用 .lock 修饰符可以锁定页面滚动',
          description3: '防止用户在加载时滚动页面',
          scrollArea: '这是一个可滚动的区域',
          scrollAreaDesc: '当 loading 激活时，滚动会被锁定',
          showButton: '开启 锁定滚动 Loading',
          hideButton: '关闭 锁定滚动 Loading',
        },
        dynamic: {
          title: '4. v-loading 动态修改描述文字',
          description: '动态描述文字示例',
          description2: '可以在加载过程中动态修改描述文字',
          description3: '提供更好的用户体验',
          showButton: '开始动态加载',
          loadingData: '正在加载数据...',
          processingRequest: '正在处理请求...',
          almostDone: '即将完成...',
        },
        functional: {
          title: '5. 函数式调用',
          description: '函数式调用示例',
          description2: '通过 ProLoading.service() 可以创建函数式 loading',
          description3: '适合在异步操作中使用',
          showButton: '开启 函数式 Loading',
          hideButton: '关闭 函数式 Loading',
          functionalLoading: '函数式加载中...',
        },
        functionalDynamic: {
          title: '6. 函数式动态修改描述文字',
          description: '函数式动态描述文字示例',
          description2: '在函数式调用中也可以动态修改描述文字',
          description3: '通过实例的 description.value 属性修改',
          showButton: '开启 动态函数式 Loading',
          hideButton: '关闭 动态函数式 Loading',
          startLoading: '开始加载...',
          connectingServer: '正在连接服务器...',
          fetchingData: '正在获取数据...',
          processingResult: '正在处理结果...',
          almostComplete: '即将完成...',
        },
      },
      complexForm: {
        title: '复杂表单示例',
        description: '展示大型复杂表单的各种功能和组件使用',
        submit: '提交',
        reset: '重置',
        fillForm: '填充',
        loadingText: '加载中...',
        submitSuccess: '表单提交成功！',
        basicInfo: {
          title: '基本信息',
          username: '用户名',
          email: '邮箱',
          phone: '手机号',
          gender: '性别',
          birthDate: '出生日期',
          status: '状态',
        },
        contentInfo: {
          title: '内容信息',
          contentTitle: '内容标题',
          category: '分类',
          tags: '标签',
          priority: '优先级',
          publishTime: '发布时间',
          content: '内容详情',
          dynamicList: '动态列表',
          itemName: '项目名称',
          itemValue: '项目值',
          // 分类选项
          categoryTech: '技术文档',
          categoryProduct: '产品介绍',
          categoryGuide: '用户指南',
          categoryOther: '其他',
          // 标签选项
          tagVue: 'Vue',
          tagReact: 'React',
          tagJavaScript: 'JavaScript',
          tagTypeScript: 'TypeScript',
          tagCSS: 'CSS',
          tagHTML: 'HTML',
        },
        dataTable: {
          title: '数据管理',
          department: '所属部门',
          departmentPlaceholder: '请选择所属部门',
          departmentTech: '技术部',
          departmentMarketing: '市场部',
          departmentSales: '销售部',
          departmentFinance: '财务部',
          position: '职位',
          positionPlaceholder: '请选择职位',
          positionJunior: '初级工程师',
          positionMid: '中级工程师',
          positionSenior: '高级工程师',
          positionExpert: '技术专家',
          positionManager: '技术经理',
          level: '级别',
          levelPlaceholder: '请选择级别',
          personnelManagement: '人员管理',
          tableTitle: '标题',
          tableTime: '时间',
          actions: '操作',
          edit: '编辑',
          save: '保存',
          delete: '删除',
        },
      },
    },
    home: {
      welcomeBack: '欢迎回来',
      today: '今天是',
      completed: '已完成',
      inProgress: '进行中',
      newMessages: '新消息',
      comparedToLastWeek: '较上周',
      totalVisits: '总访问量',
      totalUsers: '用户总数',
      totalOrders: '订单总数',
      totalRevenue: '总收入',
      activityLog: '活动记录',
      recentUserActivity: '最近用户活动',
      viewAll: '查看全部',
      projectUpdates: '项目动态',
      systemAnnouncementsAndUpdates: '系统公告与更新',
      activities: {
        completedTask: '完成了任务',
        commentedDocument: '评论了文档',
        uploadedFile: '上传了文件',
        createdTask: '创建了任务',
        updatedStatus: '更新了状态',
        solvedProblem: '解决了问题',
        mergedCode: '合并了代码',
        closedIssue: '关闭了问题',
      },
      targets: {
        systemArchitectureDesign: '系统架构设计',
        productRequirements: '产品需求',
        databaseDesign: '数据库设计',
        frontendDevelopment: '前端开发',
        backendDevelopment: '后端开发',
        testingAndDeployment: '测试与部署',
        documentation: '文档编写',
      },
      updates: {
        newVersionRelease: '新版本发布',
        newVersionDesc: 'v2.3.0 版本已成功发布，修复了多个已知问题',
        systemMaintenanceNotice: '系统维护通知',
        systemMaintenanceDesc: '系统将于本周六进行例行维护，预计耗时2小时',
        featureUpdatePreview: '功能更新预告',
        featureUpdateDesc: '下个版本将新增数据分析模块，敬请期待',
        securityUpdateReminder: '安全更新提醒',
        securityUpdateDesc: '请所有用户及时更新密码，增强账户安全性',
        userFeedbackImprovement: '用户反馈改进',
        userFeedbackDesc: '根据用户反馈，优化了界面交互和响应速度',
        newFeatureResearch: '新功能调研',
        newFeatureDesc: '正在调研AI智能分析功能，欢迎提供建议',
      },
      time: {
        minutesAgo: '分钟前',
        hourAgo: '小时前',
        yesterday: '昨天',
        daysAgo: '天前',
        weekAgo: '周前',
        today: '今天',
      },
    },
  },
  common: {
    layout: {
      userAvatar: {
        documentation: '文档',
        documentationForProNaiveUI: '组件库文档',
        logout: '退出登录',
        logoutConfirmTitle: '提示',
        logoutConfirmContent: '确认退出登录吗？',
      },
      tabs: {
        pin: '固定',
        unpin: '取消固定',
        closeLeft: '关闭左侧',
        closeRight: '关闭右侧',
        closeOthers: '关闭其他',
        closeAll: '关闭全部',
        openInNewWindow: '在新窗口打开',
        close: '关闭',
        dynamicTitle: '动态页面',
        tabManagement: '标签页管理',
        tabManagementDesc: '支持动态创建、批量操作和智能拦截',
        dynamicTabs: '动态标签页',
        interceptor: '拦截器',
        dynamicTitleDesc: '创建带时间戳的动态标题，演示一次性拦截器功能',
        createDynamicTitlePage: '创建动态标题页面',
        openCloseTabs: '打开/关闭标签页',
        basic: '基础',
        openCloseTabsDesc: '如果存在则激活已有标签页，否则则打开新标签页',
        openPage: '打开"403"页面',
        closePage: '关闭"403"页面',
        tabOperations: '标签页操作',
        batch: '批量',
        tabOperationsDesc: '用于动态配置标签页',
        closeCurrentTab: '关闭当前标签页',
        closeLeftTabs: '关闭左侧标签页',
        closeRightTabs: '关闭右侧标签页',
        closeOtherTabs: '关闭其他标签页',
        closeAllTabs: '关闭所有标签页',
        fullscreen: '全屏',
        exitFullscreen: '退出全屏',
        refresh: '刷新',
      },
    },
    fallback: {
      403: {
        title: '访问被拒绝',
        description: '您没有权限访问此页面',
      },
      404: {
        title: '页面不存在',
        description: '您访问的页面未找到',
      },
      500: {
        title: '服务器错误',
        description: '服务器开小差了，请稍后再试',
      },
      backHome: '返回首页',
    },
    preference: {
      title: '偏好设置',
      resetConfig: '重置配置',
      restoreConfig: '恢复出厂配置',
      copyConfig: '复制配置',
      other: '其他',
      layout: {
        title: '布局',
        vertical: '垂直布局',
        horizontal: '水平布局',
        mixedTwoColumn: '混合双栏布局',
        sidebar: '侧边栏布局',
        mixedSidebar: '混合侧边栏布局',
        fullContent: '内容全屏布局',
        twoColumn: '双栏布局',
        chrome: '谷歌',
        card: '卡片',
        showLogo: '显示logo',
        layoutMode: '布局模式',
        menuGroup: '菜单分组',
        menuDivider: '菜单分割线',
        header: '顶栏',
        showHeader: '显示顶栏',
        fixedHeader: '固定顶栏',
        headerHeight: '顶栏高度',
        tabbar: '标签栏',
        showTabbar: '显示标签栏',
        fixedTabbar: '固定标签栏',
        tabbarHeight: '标签栏高度',
        showTabbarIcon: '显示标签栏图标',
        tabsMode: '标签栏模式',
        tabsPersist: '持久化标签页',
        resetCacheAfterCloseTab: '关闭标签页后重置缓存',
        showSidebar: '显示侧边栏',
        mixedSidebarFixed: '混合侧边栏固定',
        sidebarCollapsed: '侧边栏折叠',
        sidebarWidth: '侧边栏宽度',
        collapsedWidth: '折叠宽度',
        showSidebarTitle: '显示侧边栏标题',
        showMenuTitle: '折叠后显示菜单名',
        sidebarTitleWidth: '侧边栏标题宽度',
        footer: '底部',
        showFooter: '显示底部',
        fixedFooter: '固定底部',
        footerHeight: '底部高度',
        animationMode: '动画模式',
        none: '无',
        fade: '淡入淡出',
        fadeSlide: '滑动淡入淡出',
        fadeBottom: '底部淡入',
        fadeScale: '缩放淡入',
        zoomFade: '缩放淡出',
        zoomOut: '缩放',
      },
      theme: {
        title: '主题',
        followSystem: '跟随系统',
        light: '浅色',
        dark: '深色',
        themeColor: '主题颜色',
        primaryColor: '主色',
        grayMode: '灰色模式',
        colorWeakness: '色弱模式',
      },
      app: {
        routeTransition: '路由过渡动画',
        fade: '渐变',
        fadeUp: '渐变-向上',
        fadeDown: '渐变-向下',
        fadeSlide: '渐变-向左',
        none: '无',
      },
    },
    status: {
      male: '男',
      female: '女',
      other: '其他',
      directory: '目录',
      menu: '菜单',
      button: '按钮',
      newWindow: '新窗口',
      iframe: 'iframe',
      admin: '管理员',
      user: '普通用户',
      guest: '访客',
      super: '超级管理员',
    },
    often: {
      status: '状态',
      remark: '备注',
      operation: '操作',
      add: '新增',
      edit: '编辑',
      delete: '删除',
      index: '序号',
      deleteConfirm: '确定删除',
      deleteQuestion: '吗？',
      deleteSuccess: '删除成功',
      createTime: '创建时间',
      updateTime: '更新时间',
      cancel: '取消',
      confirm: '确认',
      close: '关闭',
      success: '成功',
      failed: '失败',
      operationSuccess: '操作成功',
      enable: '启用',
      disable: '禁用',
    },
  },
  routes: {
    home: '首页',
    login: '登录',
    demo: '演示',
    system: '系统管理',
    userManagement: '用户管理',
    roleManagement: '角色管理',
    menuManagement: '菜单管理',
    access: '权限',
    accessToggle: '权限切换',
    exception: '异常页',
    richText: '富文本',
    complexForm: '复杂表单',
    externalPage: '外部页面',
    editTable: '编辑表格',
    embedded: '内嵌',
    externalOpenRoute: '外部打开路由',
    noLayout: '无布局',
    menuManagementExternal: '菜单管理',
    baiduIframe: '百度',
    menuManagementIframe: '菜单管理',
    iframeLoadFailed: 'iframe 加载失败',
    externalLink: '外链',
    iconSelector: '图标选择器',
    loading: '加载指令',
    nestedDetail: '嵌套详情页',
    nestedDetail2: '嵌套详情页（2）',
    detail: '详情页',
    detail1: '详情页（1）',
    detail2: '详情页（2）',
    fileDownload: '文件下载',
    pageComponent: '页面级组件',
    tabs: '多标签',
    403: '403',
    404: '404',
    500: '500',
    keepAlive: '缓存路由示例',
    keepAliveDemo1: '基础缓存',
    keepAliveDemo2: '条件缓存',
  },
} as const
