#ifndef __CITICS_HSHLP_H__
#define __CITICS_HSHLP_H__

#ifdef WIN32
#ifdef CITICS_HSHLP_EXPORTS
#define CITICS_HSHLP_API __declspec(dllexport)
#else
#define CITICS_HSHLP_API __declspec(dllimport)
#endif

#define CITICSSTDCALL	__stdcall		/* ensure stcall calling convention on NT */
#else
#define CITICS_HSHLP_API
#define CITICSSTDCALL				    /* leave blank for other systems */
#endif

#define ERROR_MSG_SIZE 512
//////////////////////////////////////////////////////////////////////////

/**
* ͬҵ
* ʹøñʶҵʱϵͳ״ֱ̬ӦϢʱ
*/
#define BIZCALL_SYNC  0

/**
* 첽ҵ
* ʹøñʶҵʱϵͳضȴӦϢ
* ҪQueueGetMsgȡӦϢ 
*/
#define BIZCALL_ASYNC 1

/**
* ϢķϢϢ
* ʶҵΪϢ綩ĳɽݡϵͳ֪ͨϢ
* ҪQueueGetMsgȡĵϢ
*/
#define BIZCALL_SUBSCRIBE 3

typedef void *HSHLPCFGHANDLE;
typedef void *HSHLPHANDLE;
typedef void *HSHLPASYNCMSG;

#pragma pack(1)

/* 첽ͶϢϢ*/
typedef struct
{
	int nFlags;           // λʶϢ0x0:Ϣ, >0:ϵͳ״̬Ϣ
	int nFuncID;          // 첽ܺ
	int nReqNo;           // 첽ţݸź͹ܺŶӦƥ
	int nIssueType;       // Ϣ
	int nErrorNo;         //  
	HSHLPASYNCMSG HAsyncMsg;      // Ϣ
	char szErrorInfo[ERROR_MSG_SIZE+1];     // Ϣ
}MSG_CTRL, *LPMSG_CTRL;

#pragma pack()


#ifdef __cplusplus
extern "C"
{
#endif
	
	// ʼszConfigFileΪʱϵͳĬֵʼhConfigΪ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_InitConfig(HSHLPCFGHANDLE* hConfig, const char* szConfigFile=NULL);

	// ļԼضͬļزͬþͬInitConfig
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_LoadConfig(HSHLPCFGHANDLE* hConfig, const char* szConfigFile);
	
	// ÷ӵַʽip1:port1;ip2:port2;
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_ResetServer(HSHLPCFGHANDLE hConfig, const char* szAddr);

	// þʼһӶ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_Init(HSHLPHANDLE* HlpHandle, HSHLPCFGHANDLE hConfig);
	// ͷӾϵͳԴ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_Exit(HSHLPHANDLE HlpHandle);

	// 
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_ConnectServer(HSHLPHANDLE HlpHandle);
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_DisConnect(HSHLPHANDLE HlpHandle);

	// ύҵszParamΪNULLΪͨSetValueõ 
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_BizCallAndCommit(HSHLPHANDLE HlpHandle, int iFuncID, const char* szParam=NULL, int nBizCallType=BIZCALL_SYNC, LPMSG_CTRL lpMsgCtrl=NULL);

	// ȡ¼СֵΪС
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetRowCount(HSHLPHANDLE HlpHandle, LPMSG_CTRL lpMsgCtrl=NULL);
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetColCount(HSHLPHANDLE HlpHandle, LPMSG_CTRL lpMsgCtrl=NULL);

	// ȡֶƣ0Ϊ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetColName(HSHLPHANDLE HlpHandle, int iColumn, char* szColName, LPMSG_CTRL lpMsgCtrl=NULL);

	// ȡһм¼һεȴ򿪽ѵ0Ϊǰ¼
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetNextRow(HSHLPHANDLE HlpHandle, LPMSG_CTRL lpMsgCtrl=NULL);

	// ֶƣȡֵֶ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetValue(HSHLPHANDLE HlpHandle, const char* szKeyName, char* szValue, LPMSG_CTRL lpMsgCtrl=NULL);

	// ֶŻȡֵֶ0Ϊ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetValueByIndex(HSHLPHANDLE HlpHandle, int iColumn, char* szValue, LPMSG_CTRL lpMsgCtrl=NULL);

	// ȡǰϢ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_GetErrorMsg(HSHLPHANDLE HlpHandle, int* piErrorCode, char* szErrorMsg);


	/************************************************************************/
	// һõķһһá
	// ʼ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_BeginParam(HSHLPHANDLE HlpHandle);
	// ÿֶƺֵ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_SetValue(HSHLPHANDLE HlpHandle, const char* szKeyName, const char* szValue);
	
	
	/************************************************************************/
	// 첽Ϣغ
	
	// ȡ첽ϢеϢ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_QueueMsgCount(HSHLPHANDLE HlpHandle);
	
	// ӶжȡһϢûݣúһֱأֱnWaitTimeʱʱŷء
	// nWaitTime: λ
	//       = 0: أ򷵻MsgreturnֵΪ 0returnֵΪ-5(ʱ)
	//       =-1: ֱݻȡMsg ŷءȴreturnֵΪ 0
	//       = ֵʱʱ䣬أȴtimeʱ󷵻ءreturnֵΪ -5(ʱ)
	// Return:  0: һȡϢɹ
	//         -5: ʱ趨ʱڶûݡ
	// 	:	
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_QueueGetMsg(HSHLPHANDLE HlpHandle, LPMSG_CTRL lpMsgCtrl /*Out*/, int nWaitTime=0);
	
	// ɻ߲ҪϢʱӦʱɾϢϢռôڴ档
	// ɾпÿζGetͬһϢ
	CITICS_HSHLP_API int CITICSSTDCALL CITICs_HsHlp_QueueEraseMsg(HSHLPHANDLE HlpHandle, LPMSG_CTRL lpMsgCtrl /*In*/);
	

#ifdef __cplusplus
}
#endif


#endif 
