#ifndef GOLD_TRADE_API_H
#define GOLD_TRADE_API_H

#ifdef GOLDTRADEAPI_EXPORTS
#define GOLDTRADEAPI_LIB __declspec(dllexport)
#else
#ifdef WIN32
#define GOLDTRADEAPI_LIB __declspec(dllimport)
#else
#define GOLDTRADEAPI_LIB 
#endif
#endif


#include <stdio.h>
#include "APIError.h"
#include "KSUserApiStructEx.h"
class CGoldTradeSpi	//صӿ
{
 public:
	virtual ~CGoldTradeSpi(){};
	 //ӽ֪ͨ
	virtual void OnFrontConnected(){};

	//ӶϿ
	virtual void OnFrontDisconnected(int nReason){};


	///¼Ӧ
	virtual void OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǳӦ
	virtual void OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	//г״̬֪ͨ
	virtual void OnNtyMktStatus(const CThostFtdcMarketStatusField *pfldMktStatus){};

	///ѯԼӦ
	virtual void OnRspQryInstrument(CThostFtdcInstrumentField *pInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};


	///֪ͨ
	virtual void OnRtnDepthMarketData(CThostFtdcDepthMarketDataField *pDepthMarketData) {};

	///¼Ӧ(ϵͳ
	virtual void OnRspOrderInsert(CThostFtdcInputOrderField *pInputOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼ر(
	virtual void OnErrRtnOrderInsert(CThostFtdcInputOrderField *pInputOrder, CThostFtdcRspInfoField *pRspInfo) {};

	///֪ͨ
	virtual void OnRtnOrder(CThostFtdcOrderRtnField *pOrder) {};

	//ǿ֪ͨ
	virtual void OnForceLogout(CThostFtdcUserLogoutField *pLogout) {}; 
	
	//Ӧ
	///Ӧ(ϵͳذ˴ʹϢ)
	virtual void OnRspOrderAction(CThostFtdcInputOrderActionField *pInputOrderAction, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ر()
	virtual void OnErrRtnOrderAction(CThostFtdcOrderActionField *pOrderAction, CThostFtdcRspInfoField *pRspInfo) {};

	///ɽ֪ͨ
	virtual void OnRtnTrade(CThostFtdcTradeField *pTrade) {};

	///ѯʽ˻Ӧ
	virtual void OnRspQryTradingAccount(CThostFtdcTradingAccountField *pTradingAccount, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

  ///ѯӦ
	virtual void OnRspQryOrder(CThostFtdcOrderField *pOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯɽӦ
	virtual void OnRspQryTrade(CThostFtdcTradeField *pTrade, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯͶֲ߳Ӧ
	virtual void OnRspQryInvestorPosition(CThostFtdcInvestorPositionField *pInvestorPosition, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	//ѯͻӦ
	virtual void OnRspQryClientStorage(CThostFtdcStorageField *pStorage, CThostFtdcRspInfoField *pRspInfo,int nRequestID,bool bIsLast){};

	///Ӧ
	virtual void OnRspSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	//virtual void OnRspError(CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

};



class GOLDTRADEAPI_LIB CGoldTradeApi 
{
public: 
	static CGoldTradeApi *CreateGoldTradeApi();
	//ͷŽӿ
	virtual void Release()=0;
	//עǰõַ
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	//עAPIصӿ
	virtual void RegisterSpi(CGoldTradeSpi *pGeneralSpi)=0;	
	//API߳
	virtual int Init(bool logflag=true)=0;	
	//ֹͣAPI߳
	virtual void Join()=0;	


	//û¼
	virtual int ReqUserLogin(CThostFtdcReqUserLoginField *pReqUserLoginField, int nRequestID) = 0;

	//ûǳ
	virtual int ReqUserLogout(CThostFtdcUserLogoutField *pUserLogout, int nRequestID) = 0;

	//
	virtual int ReqUserReLogin() = 0;

	//
	virtual int SubscribeMarketData(char *ppInstrumentID[], int nCount) = 0;

	///˶顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubscribeMarketData(char *ppInstrumentID[], int nCount) = 0;

	//ѯڻԼ
	virtual int ReqQryInstrument(CThostFtdcQryInstrumentField *pQryInstrument, int nRequestID) = 0;

	//µ
	virtual int ReqOrderInsert(CThostFtdcInputOrderField *pInputOrder, int nRequestID) = 0;

	//()
	virtual int ReqOrderAction(CThostFtdcInputOrderActionField *pInputOrderAction, int nRequestID) = 0;

	//ѯֲ
	virtual int ReqQryInvestorPosition(CThostFtdcQryInvestorPositionField *pInvestorPosition, int nRequestID) = 0;

	//ѯʽ
	virtual int ReqQryTradingAccount(CThostFtdcQryTradingAccountField *pQryTradingAccount, int nRequestID) = 0;

	//ɽѯ
	virtual int ReqQryTrade(CThostFtdcQryTradeField *pQryTrade, int nRequestID) = 0;

	//ίвѯ
	virtual int ReqQryOrder(CThostFtdcQryOrderField *pQryOrder, int nRequestID) = 0;

	//ѯͻ
	virtual int ReqQryStorage(CThostFtdcQryStorageField *pfldStorage, int nRequestID)=0;


protected:
	virtual ~CGoldTradeApi();



};




#endif