#ifndef __KSOTPMDAPI_H_INCLUDED_
#define __KSOTPMDAPI_H_INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "KSOTPUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_OTP_MD_API_EXPORT
#define OTP_MD_API_EXPORT __declspec(dllexport)
#else
#define OTP_MD_API_EXPORT __declspec(dllimport)
#endif
#else
#ifdef  WIN32
#define OTP_MD_API_EXPORT 
#else
#define OTP_MD_API_EXPORT __attribute__((visibility("default")))
#endif
#endif

namespace KingstarAPI
{

class CKSOTPMdSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷á󣬿ͻҪ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};	

	///¼Ӧ
	virtual void OnRspUserLogin(CKSOTPRspUserLoginField *pRspUserLogin, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǳӦ
	virtual void OnRspUserLogout(CKSOTPUserLogoutField *pUserLogout, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspError(CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspSubMarketData(CKSOTPSpecificInstrumentField *pSpecificInstrument, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ȡӦ
	virtual void OnRspUnSubMarketData(CKSOTPSpecificInstrumentField *pSpecificInstrument, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspSubForQuoteRsp(CKSOTPSpecificInstrumentField *pSpecificInstrument, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ȡѯӦ
	virtual void OnRspUnSubForQuoteRsp(CKSOTPSpecificInstrumentField *pSpecificInstrument, CKSOTPRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֪ͨ
	virtual void OnRtnDepthMarketData(CKSOTPDepthMarketDataField *pDepthMarketData) {};

	///ѯ֪ͨ
	virtual void OnRtnForQuoteRsp(CKSOTPForQuoteRspField *pForQuoteRsp) {};
};

class OTP_MD_API_EXPORT CKSOTPMdApi
{
public:
	///MdApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@return UserApi
	///modify for udp marketdata
	static CKSOTPMdApi *CreateOTPMdApi(const char *pszFlowPath = "", const bool bIsUsingUdp=false, const bool bIsMulticast=false);
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȡǰ
	///@retrun ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;

	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CKSOTPMdSpi *pSpi) = 0;
	
	///顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int SubscribeMarketData(CKSOTPSpecificInstrumentField *ppInstrumentID[], int nCount) = 0;

	///˶顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubscribeMarketData(CKSOTPSpecificInstrumentField *ppInstrumentID[], int nCount) = 0;
	
	///ѯۡ
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int SubscribeForQuoteRsp(char *ppInstrumentID[], int nCount) = 0;

	///˶ѯۡ
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubscribeForQuoteRsp(char *ppInstrumentID[], int nCount) = 0;

	///û¼
	virtual int ReqUserLogin(CKSOTPReqUserLoginField *pReqUserLoginField, int nRequestID) = 0;
	
	///ǳ
	virtual int ReqUserLogout(CKSOTPUserLogoutField *pUserLogout, int nRequestID) = 0;
protected:
	~CKSOTPMdApi(){};
};

}	// end of namespace KingstarAPI

#endif
