/////////////////////////////////////////////////////////////////////////
///@company shanghai liber information Technology Co.,Ltd
///@file SecurityFtdcL2MDUserApi.h
///@brief ͻ˽ӿ
/////////////////////////////////////////////////////////////////////////

#if !defined(SECURITY_L2MD_FTDCUSERAPI_H)
#define SECURITY_L2MD_FTDCUSERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SecurityFtdcL2MDUserApiStruct.h"

_LTS_NS_BEGIN_
#if defined(L2MD_USERAPI_IS_LIB) && defined(WINDOWS)
#ifdef LIB_L2MD_USER_API_EXPORT
#define L2MD_USER_API_EXPORT __declspec(dllexport)
#else
#define L2MD_USER_API_EXPORT __declspec(dllimport)
#endif
#else
#define L2MD_USER_API_EXPORT 
#endif

class CSecurityFtdcL2MDUserSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
		
	///ʱ
	virtual void OnHeartBeatWarning(int nTimeLapse){};

	///Ӧ
	virtual void OnRspError(CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspUserLogin(CSecurityFtdcUserLoginField *pUserLogin, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǳӦ
	virtual void OnRspUserLogout(CSecurityFtdcUserLogoutField *pUserLogout, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Level2Ӧ
	virtual void OnRspSubL2MarketData(CSecurityFtdcSpecificInstrumentField *pSpecificInstrument, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ȡLevel2Ӧ
	virtual void OnRspUnSubL2MarketData(CSecurityFtdcSpecificInstrumentField *pSpecificInstrument, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Level2ָӦ
	virtual void OnRspSubL2Index(CSecurityFtdcSpecificInstrumentField *pSpecificInstrument, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ȡLevel2ָӦ
	virtual void OnRspUnSubL2Index(CSecurityFtdcSpecificInstrumentField *pSpecificInstrument, CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Level2֪ͨ
	virtual void OnRtnL2MarketData(CSecurityFtdcL2MarketDataField *pL2MarketData) {};

	///Level2ָ֪ͨ
	virtual void OnRtnL2Index(CSecurityFtdcL2IndexField *pL2Index) {};

	///ίмɽӦ
	virtual void OnRspSubL2OrderAndTrade(CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ȡίмɽӦ
	virtual void OnRspUnSubL2OrderAndTrade(CSecurityFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Level2ί֪ͨ
	virtual void OnRtnL2Order(CSecurityFtdcL2OrderField *pL2Order) {};

	///Level2ɽ֪ͨ
	virtual void OnRtnL2Trade(CSecurityFtdcL2TradeField *pL2Trade) {};

	///֪ͨSSEһΪ0ı
	virtual void OnNtfCheckOrderList(TSecurityFtdcInstrumentIDType InstrumentID, TSecurityFtdcFunctionCodeType FunctionCode) {};
};

#ifndef WINDOWS
	#if __GNUC__ >= 4
		#pragma GCC visibility push(default)
	#endif
#endif
class L2MD_USER_API_EXPORT CSecurityFtdcL2MDUserApi
{
public:
	///UserApi
	static CSecurityFtdcL2MDUserApi *CreateFtdcL2MDUserApi(const bool bIsMulticast=false);
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȴӿ߳̽
	virtual int Join() = 0;
	
	///ȡǰ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CSecurityFtdcL2MDUserSpi *pSpi) = 0;
	
	virtual int SubscribeL2MarketData(char *ppInstrumentID[], int nCount, char* pExchageID) = 0;

	virtual int UnSubscribeL2MarketData(char *ppInstrumentID[], int nCount, char* pExchageID) = 0;
	
	virtual int SubscribeL2Index(char *ppInstrumentID[], int nCount, char* pExchageID) = 0;

	virtual int UnSubscribeL2Index(char *ppInstrumentID[], int nCount, char* pExchageID) = 0;	
	
	virtual int SubscribeL2OrderAndTrade() = 0;
	
	virtual int UnSubscribeL2OrderAndTrade() = 0;

	///¼
	virtual int ReqUserLogin(CSecurityFtdcUserLoginField *pUserLogin, int nRequestID) = 0;

	///ǳ
	virtual int ReqUserLogout(CSecurityFtdcUserLogoutField *pUserLogout, int nRequestID) = 0;
protected:
	~CSecurityFtdcL2MDUserApi(){};
};
#ifndef WINDOWS
	#if __GNUC__ >= 4
		#pragma GCC visibility pop
	#endif
#endif
_LTS_NS_END_
#endif
