//˵

//ϵͳ
#include "stdafx.h"
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳
#include <boost/any.hpp>			//еʵ

//API
#include "SgitFtdcMdApi.h"

//ռ
using namespace std;
using namespace boost::python;
using namespace boost;
using namespace fstech;

//
#define ONFRONTCONNECTED 1
#define ONFRONTDISCONNECTED 2
#define ONHEARTBEATWARNING 3
#define ONRSPUSERLOGIN 4
#define ONRSPUSERLOGOUT 5
#define ONRSPERROR 6
#define ONRSPSUBMARKETDATA 7
#define ONRSPUNSUBMARKETDATA 8
#define ONRSPSUBFORQUOTERSP 9
#define ONRSPUNSUBFORQUOTERSP 10
#define ONRTNDEPTHMARKETDATA 11
#define ONRTNFORQUOTERSP 12
#define ONRTNDEFERDELIVERYQUOT 13


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	any task_data;		//ݽṹ
	any task_error;		//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int* value);

//ֵлȡĳֵӦĳֵṹֵ
void getLong(dict d, string key, long* value);

//ֵлȡĳֵӦĶֵṹֵ
void getShort(dict d, string key, short* value);


//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);


//ֵлȡĳֵӦĵֵַṹֵ
void getChar(dict d, string key, char* value);


//ֵлȡĳֵӦֵַṹֵ
void getStr(dict d, string key, char* value);


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public CThostFtdcMdSpi
{
private:
	CThostFtdcMdApi* api;				//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task> task_queue;	//

public:
	MdApi()
	{
		function0<void> f = boost::bind(&MdApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~MdApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected();

	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason);

	///ʱ档ʱδյʱ÷á
	///@param nTimeLapse ϴνձĵʱ
	virtual void OnHeartBeatWarning(int nTimeLapse);

	///¼Ӧ
	virtual void OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///ǳӦ
	virtual void OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///Ӧ
	virtual void OnRspError(CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///Ӧ
	virtual void OnRspSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///ȡӦ
	virtual void OnRspUnSubMarketData(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///ѯӦ
	virtual void OnRspSubForQuoteRsp(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///ȡѯӦ
	virtual void OnRspUnSubForQuoteRsp(CThostFtdcSpecificInstrumentField *pSpecificInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) ;

	///֪ͨ
	virtual void OnRtnDepthMarketData(CThostFtdcDepthMarketDataField *pDepthMarketData) ;

	///ѯ֪ͨ
	virtual void OnRtnForQuoteRsp(CThostFtdcForQuoteRspField *pForQuoteRsp) ;

	///ӽ
	virtual void OnRtnDeferDeliveryQuot(CThostDeferDeliveryQuot* pQuot);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processFrontConnected(Task task);

	void processFrontDisconnected(Task task);

	void processHeartBeatWarning(Task task);

	void processRspUserLogin(Task task);

	void processRspUserLogout(Task task);

	void processRspError(Task task);

	void processRspSubMarketData(Task task);

	void processRspUnSubMarketData(Task task);

	void processRspSubForQuoteRsp(Task task);

	void processRspUnSubForQuoteRsp(Task task);

	void processRtnDepthMarketData(Task task);

	void processRtnForQuoteRsp(Task task);

	void processRtnDeferDeliveryQuot(Task task);


	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onFrontConnected(){};

	virtual void onFrontDisconnected(int reason) {};

	virtual void onHeartBeatWarning(int timeLapse) {};

	virtual void onRspUserLogin(dict data, dict error, int id, bool last) {};

	virtual void onRspUserLogout(dict data, dict error, int id, bool last) {};

	virtual void onRspError(dict error, int id, bool last) {};

	virtual void onRspSubMarketData(dict data, dict error, int id, bool last) {};

	virtual void onRspUnSubMarketData(dict data, dict error, int id, bool last) {};

	virtual void onRspSubForQuoteRsp(dict data, dict error, int id, bool last) {};

	virtual void onRspUnSubForQuoteRsp(dict data, dict error, int id, bool last) {};

	virtual void onRtnDepthMarketData(dict data) {};

	virtual void onRtnForQuoteRsp(dict data) {};

	virtual void onRtnDeferDeliveryQuot(dict data) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createFtdcMdApi(string pszFlowPath);

	string getApiVersion();

	void release();

	void init();

	int join();

	int exit();

	string getTradingDay();

	void registerFront(string pszFrontAddress);

	void registerNameServer(string pszNsAddress);

	int subscribeMarketData(string instrumentID);

	int unSubscribeMarketData(string instrumentID);

	int subscribeForQuoteRsp(string instrumentID);

	int unSubscribeForQuoteRsp(string instrumentID);

	int reqUserLogin(dict req, int nRequestID);

	int reqUserLogout(dict req, int nRequestID);

};
