//˵

//ϵͳ
#include "stdafx.h"
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳
#include <boost/any.hpp>			//еʵ

//API
#include "DFITCTraderApi.h"

//ռ
using namespace std;
using namespace boost::python;
using namespace boost;
using namespace DFITCXSPEEDAPI;

//
#define ONFRONTCONNECTED 1
#define ONFRONTDISCONNECTED 2
#define ONRSPUSERLOGIN 3
#define ONRSPUSERLOGOUT 4
#define ONRSPINSERTORDER 5
#define ONRSPCANCELORDER 6
#define ONRTNERRORMSG 7
#define ONRTNMATCHEDINFO 8
#define ONRTNORDER 9
#define ONRTNCANCELORDER 10
#define ONRSPQRYORDERINFO 11
#define ONRSPQRYMATCHINFO 12
#define ONRSPQRYPOSITION 13
#define ONRSPCUSTOMERCAPITAL 14
#define ONRSPQRYEXCHANGEINSTRUMENT 15
#define ONRSPARBITRAGEINSTRUMENT 16
#define ONRSPQRYSPECIFYINSTRUMENT 17
#define ONRSPQRYPOSITIONDETAIL 18
#define ONRTNTRADINGNOTICE 19
#define ONRSPRESETPASSWORD 20
#define ONRSPQRYTRADECODE 21
#define ONRSPBILLCONFIRM 22
#define ONRSPEQUITYCOMPUTMODE 23
#define ONRSPQRYBILL 24
#define ONRSPCONFIRMPRODUCTINFO 25
#define ONRSPTRADINGDAY 26
#define ONRSPQUOTEINSERT 27
#define ONRTNQUOTEINSERT 28
#define ONRSPQUOTECANCEL 29
#define ONRTNQUOTECANCEL 30
#define ONRTNQUOTEMATCHEDINFO 31
#define ONRSPCANCELALLORDER 32
#define ONRSPQRYQUOTENOTICE 33
#define ONRSPFORQUOTE 34
#define ONRTNFORQUOTE 35
#define ONRSPQRYQUOTEORDERINFO 36
#define ONRSPQRYFORQUOTE 37
#define ONRSPQRYTRANSFERBANK 38
#define ONRSPQRYTRANSFERSERIAL 39
#define ONRSPFROMBANKTOFUTUREBYFUTURE 40
#define ONRSPFROMFUTURETOBANKBYFUTURE 41
#define ONRTNFROMBANKTOFUTUREBYFUTURE 42
#define ONRTNFROMFUTURETOBANKBYFUTURE 43
#define ONRTNREPEALFROMFUTURETOBANKBYBANK 44
#define ONRSPQRYEXCHANGESTATUS 45
#define ONRTNEXCHANGESTATUS 46
#define ONRSPQRYDEPTHMARKETDATA 47

///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	any task_data;		//ݽṹ
	any task_error;		//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int* value);

//ֵлȡĳֵӦĳֵṹֵ
void getLong(dict d, string key, long* value);

//ֵлȡĳֵӦĶֵṹֵ
void getShort(dict d, string key, short* value);


//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);


//ֵлȡĳֵӦĵֵַṹֵ
void getChar(dict d, string key, char* value);


//ֵлȡĳֵӦֵַṹֵ
void getString(dict d, string key, char* value);


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public DFITCTraderSpi
{
private:
	DFITCTraderApi* api;			//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task> task_queue;	//

public:
	TdApi()
	{
		function0<void> f = boost::bind(&TdApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~TdApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	/* Ӧ:ͻ뽻׺̨轨ͨʱδ¼ǰͻAPIԶǰû֮ӣ
	* ãԶӣø÷֪ͨͻˣ ͻ˿ʵָ÷ʱʹʽ˺Žе¼
	*÷ApiǰûӺ󱻵ãõý˵tcpѾɹûҪе¼ܽкҵ
	*  ¼ʧ˷ᱻá
	*/
	virtual void OnFrontConnected();

	/**
	* ӲӦͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	* @param  nReason:ԭ
	*        0x1001 ʧ
	*        0x1002 дʧ
	*        0x2001 ʱ
	*        0x2002 ʧ
	*        0x2003 յ
	*/
	virtual void OnFrontDisconnected(int nReason);
	/**
	* ½Ӧ:û¼ǰûӦʱ˷ᱻã֪ͨû¼Ƿɹ
	* @param pUserLoginInfoRtn:û¼Ϣṹַ
	* @param pErrorInfo:¼ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspUserLogin(struct DFITCUserLoginInfoRtnField * pUserLoginInfoRtn, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ǳӦ:û˳ǰûӦ˷ᱻã֪ͨû˳״̬
	* @param pUserLogoutInfoRtn:û˳Ϣṹַ
	* @param pErrorInfo:ǳʧܣشϢַýṹдϢ
	*/
	virtual void OnRspUserLogout(struct DFITCUserLogoutInfoRtnField * pUserLogoutInfoRtn, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ڻίбӦ:û¼뱨ǰ÷Ӧʱ÷ᱻá
	* @param pOrderRtn:ûµϢṹַ
	* @param pErrorInfo:ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspInsertOrder(struct DFITCOrderRspDataRtnField * pOrderRtn, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ڻίгӦ:ûǰ÷ӦǸ÷ᱻá
	* @param pOrderCanceledRtn:سӦϢṹַ
	* @param pErrorInfo:ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspCancelOrder(struct DFITCOrderRspDataRtnField * pOrderCanceledRtn, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ر
	* @param pErrorInfo:ϢĽṹַ
	*/
	virtual void OnRtnErrorMsg(struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ɽر:ίгɹ׺ηᱻá
	* @param pRtnMatchData:ָɽرĽṹָ롣
	*/
	virtual void OnRtnMatchedInfo(struct DFITCMatchRtnField * pRtnMatchData);

	/**
	* ίлر:µίгɹ󣬴˷ᱻá
	* @param pRtnOrderData:ָίлرַָ롣
	*/
	virtual void OnRtnOrder(struct DFITCOrderRtnField * pRtnOrderData);

	/**
	* ر:ɹ÷ᱻá
	* @param pCancelOrderData:ָ򳷵رṹĵַýṹԼϢ
	*/
	virtual void OnRtnCancelOrder(struct DFITCOrderCanceledRtnField * pCancelOrderData);

	/**
	* ѯίӦ:ûίвѯ󣬸÷ᱻá
	* @param pRtnOrderData:ָίлرṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryOrderInfo(struct DFITCOrderCommRtnField * pRtnOrderData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯճɽӦ:ûɽѯ÷ᱻá
	* @param pRtnMatchData:ָɽرṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryMatchInfo(struct DFITCMatchedRtnField * pRtnMatchData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ֲֲѯӦ:ûֲֲѯָǰ÷Ӧʱ÷ᱻá
	* @param pPositionInfoRtn:سֲϢṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryPosition(struct DFITCPositionInfoRtnField * pPositionInfoRtn, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ͻʽѯӦ:ûʽѯָǰ÷Ӧʱ÷ᱻá
	* @param pCapitalInfoRtn:ʽϢṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspCustomerCapital(struct DFITCCapitalInfoRtnField * pCapitalInfoRtn, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ԼѯӦ:ûԼѯָǰ÷Ӧʱ÷ᱻá
	* @param pInstrumentData:غԼϢṹĵַ
	* @param pErrorInfo:Ϣṹѯ򷵻شϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryExchangeInstrument(struct DFITCExchangeInstrumentRtnField * pInstrumentData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ԼѯӦ:ûԼѯָǰ÷Ӧʱ÷ᱻá
	* @param pAbiInstrumentData:ԼϢṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspArbitrageInstrument(struct DFITCAbiInstrumentRtnField * pAbiInstrumentData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯָԼӦ:ûָԼѯָǰ÷Ӧʱ÷ᱻá
	* @param pInstrument:ָԼϢṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQrySpecifyInstrument(struct DFITCInstrumentRtnField * pInstrument, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯֲϸӦ:ûѯֲϸǰ÷Ӧʱ÷ᱻá
	* @param pPositionDetailRtn:سֲϸṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryPositionDetail(struct DFITCPositionDetailRtnField * pPositionDetailRtn, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ֪ͨӦ:ڽXSPEEDֶָ̨֪֧ͨͻҲ֧ϵͳ㲥
	* @param pTradingNoticeInfo: û¼֪ͨṹĵַ
	*/
	virtual void OnRtnTradingNotice(struct DFITCTradingNoticeInfoField * pTradingNoticeInfo);

	/**
	* ޸Ӧ:޸ʽ˻¼롣
	* @param pResetPassword: ޸Ľṹĵַ
	* @param pErrorInfo:޸ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspResetPassword(struct DFITCResetPwdRspField * pResetPassword, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ױѯӦ:ؽױϢ
	* @param pTradeCode: ؽױѯṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryTradeCode(struct DFITCQryTradeCodeRtnField * pTradeCode, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ˵ȷӦ:ڽտͻ˵ȷ״̬
	* @param pBillConfirm: ˵ȷϽṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	*/
	virtual void OnRspBillConfirm(struct DFITCBillConfirmRspField * pBillConfirm, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ѯͻȨ㷽ʽӦ:ؿͻȨķʽ
	* @param pEquityComputMode: ؿͻȨ㷽ʽṹĵַ
	*/
	virtual void OnRspEquityComputMode(struct DFITCEquityComputModeRtnField * pEquityComputMode);

	/**
	* ͻ˵ѯӦ:˵Ϣ
	* @param pQryBill: ؿͻ˵ѯṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryBill(struct DFITCQryBillRtnField *pQryBill, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* IDȷӦ:ڽճϢ
	* @param pProductRtnData: سIDȷӦṹĵַ
	*/
	virtual void OnRspConfirmProductInfo(struct DFITCProductRtnField * pProductRtnData);


	/**
	* ȷӦ:ڽսϢ
	* @param DFITCTradingDayRtnField: ؽȷӦṹĵַ
	*/
	virtual void OnRspTradingDay(struct DFITCTradingDayRtnField * pTradingDayRtnData);

	/**
	* ̱Ӧ
	* @param pRspQuoteData:ָ̱Ӧַָ롣
	* @param pErrorInfo:ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspQuoteInsert(struct DFITCQuoteRspField * pRspQuoteData, struct DFITCErrorRtnField * pErrorInfo) ;

	/**
	* ̱ر
	* @param pRtnQuoteData:ָ̱رַָ롣
	*/
	virtual void OnRtnQuoteInsert(struct DFITCQuoteRtnField * pRtnQuoteData);

	/**
	* ̳Ӧ
	* @param pRspQuoteCanceledData:ָ̳Ӧַָ롣
	* @param pErrorInfo:ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspQuoteCancel(struct DFITCQuoteRspField * pRspQuoteCanceledData, struct DFITCErrorRtnField * pErrorInfo)  ;

	/**
	* ̳ر
	* @param pRtnQuoteCanceledData:ָ̳رַָ롣
	*/
	virtual void OnRtnQuoteCancel(struct DFITCQuoteCanceledRtnField * pRtnQuoteCanceledData) ;

	/**
	* ̳ɽر
	* @param pRtnQuoteMatchedData:ָ̳ɽرַָ롣
	*/
	virtual void OnRtnQuoteMatchedInfo(struct DFITCQuoteMatchRtnField * pRtnQuoteMatchedData) ;

	/**
	* Ӧ
	* @param pRspStripCancelOrderData:ָӦַָ롣
	* @param pErrorInfo:ʧܣشϢַýṹдϢ
	*/
	virtual void OnRspCancelAllOrder(struct DFITCCancelAllOrderRspField *pRspCancelAllOrderData, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ѯ֪ͨѯӦ
	* @param pRtnQryQuoteNoticeData:ѯѯ֪ͨرṹַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryQuoteNotice(struct DFITCQryQuoteNoticeRtnField * pRtnQryQuoteNoticeData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯӦ
	* @param pRspForQuoteData:ѯӦṹַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	*/
	virtual void OnRspForQuote(struct DFITCForQuoteRspField * pRspForQuoteData, struct DFITCErrorRtnField * pErrorInfo);

	/**
	* ѯۻر
	* @param pRtnForQuoteData:ѯۻرṹַ
	*/
	virtual void OnRtnForQuote(struct DFITCForQuoteRtnField * pRtnForQuoteData);

	/**
	* ѯձίӦ
	* @param pRtnQuoteOrderData:ָ򱨼۲ѯرṹĵַ
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryQuoteOrderInfo(struct DFITCQuoteOrderRtnField * pRtnQuoteOrderData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯίвѯӦ
	* @param pRtnQryForQuoteData:ָѯίвѯӦַָ롣
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryForQuote(struct DFITCQryForQuoteRtnField * pRtnQryForQuoteData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	/**
	* ѯתӦ
	* @param pTransferBank:ָѯתлرַָ롣
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryTransferBank(struct DFITCTransferBankRspField * pTransferBank, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast) ;

	/**
	* ѯתˮӦ
	* @param pTransferSerial:ָѯתˮرַָ롣
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryTransferSerial(struct DFITCTransferSerialRspField * pTransferSerial, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast) ;

	/**
	* ڻʽתڻӦ
	* @param pRspTransfer:ָڻʽתڻӦַָ롣
	* @param pErrorInfo:תʧܣشϢַýṹдϢ
	*/
	virtual void OnRspFromBankToFutureByFuture(struct DFITCTransferRspField * pRspTransfer, struct DFITCErrorRtnField * pErrorInfo) ;

	/**
	* ڻڻʽתӦ
	* @param pRspTransfer:ָڻڻʽתӦַָ롣
	* @param pErrorInfo:תʧܣشϢַýṹдϢ
	*/
	virtual void OnRspFromFutureToBankByFuture(struct DFITCTransferRspField * pRspTransfer, struct DFITCErrorRtnField * pErrorInfo) ;

	/**
	* ڻʽתڻ֪ͨ
	* @param pRtnTransfer:ָڻʽתڻַָ֪ͨ롣
	* @param pErrorInfo:תʧܣشϢַýṹдϢ
	*/
	virtual void OnRtnFromBankToFutureByFuture(DFITCTransferRtnField * pRtnTransfer, struct DFITCErrorRtnField * pErrorInfo) ;

	/**
	* ڻڻʽת֪ͨ
	* @param pRtnTransfer:ָڻڻʽתַָ֪ͨ롣
	* @param pErrorInfo:תʧܣشϢַýṹдϢ
	*/
	virtual void OnRtnFromFutureToBankByFuture(DFITCTransferRtnField * pRtnTransfer, struct DFITCErrorRtnField * pErrorInfo) ;

	/**
	* зڻת֪ͨ
	* @param pRspRepeal:ָڻڻʽתгַָ֪ͨ롣
	*/
	virtual void OnRtnRepealFromFutureToBankByBank(DFITCRepealRtnField * pRspRepeal) ;

	/**
	* ״̬ѯӦ
	* @param pRspExchangeStatusData:ָ״̬ѯӦַָ롣
	*/
	virtual void OnRspQryExchangeStatus(struct DFITCExchangeStatusRspField * pRspExchangeStatusData);

	/**
	* ״̬֪ͨ
	* @param pRtnExchangeStatusData:ָ״ַָ̬֪ͨ롣
	*/
	virtual void OnRtnExchangeStatus(struct DFITCExchangeStatusRtnField * pRtnExchangeStatusData);

	/**
	* ѯӦ
	* @param pDepthMarketData:ָѯӦַָ롣
	* @param pErrorInfo:ѯʧܣشϢַýṹдϢ
	* @param bIsLast:ǷһӦϢ0 -   1 -ǣ
	*/
	virtual void OnRspQryDepthMarketData(struct DFITCDepthMarketDataField * pDepthMarketData, struct DFITCErrorRtnField * pErrorInfo, bool bIsLast);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processFrontConnected(Task task);

	void processFrontDisconnected(Task task);

	void processRspUserLogin(Task task);

	void processRspUserLogout(Task task);

	void processRspInsertOrder(Task task);

	void processRspCancelOrder(Task task);

	void processRtnErrorMsg(Task task);

	void processRtnMatchedInfo(Task task);

	void processRtnOrder(Task task);

	void processRtnCancelOrder(Task task);

	void processRspQryOrderInfo(Task task);

	void processRspQryMatchInfo(Task task);

	void processRspQryPosition(Task task);

	void processRspCustomerCapital(Task task);

	void processRspQryExchangeInstrument(Task task);

	void processRspArbitrageInstrument(Task task);

	void processRspQrySpecifyInstrument(Task task);

	void processRspQryPositionDetail(Task task);

	void processRtnTradingNotice(Task task);

	void processRspResetPassword(Task task);

	void processnRspQryTradeCode(Task task);

	void processRspBillConfirm(Task task);

	void processnRspEquityComputMode(Task task);

	void processRspQryBill(Task task);

	void processRspConfirmProductInfo(Task task);

	void processRspTradingDay(Task task);

	void processRspQuoteInsert(Task task);

	void processRtnQuoteInsert(Task task);

	void processRspQuoteCancel(Task task);

	void processRtnQuoteCancel(Task task);

	void processRtnQuoteMatchedInfo(Task task);

	void processRspCancelAllOrder(Task task);

	void processRspQryQuoteNotice(Task task);

	void processRspForQuote(Task task);

	void processRtnForQuote(Task task);

	void processRspQryQuoteOrderInfo(Task task);

	void processRspQryForQuote(Task task);

	void processRspQryTransferBank(Task task);

	void processRspQryTransferSerial(Task task);

	void processRspFromBankToFutureByFuture(Task task);

	void processRspFromFutureToBankByFuture(Task task);

	void processRtnFromBankToFutureByFuture(Task task);

	void processRtnFromFutureToBankByFuture(Task task);

	void processRtnRepealFromFutureToBankByBank(Task task);

	void processRspQryExchangeStatus(Task task);

	void processRtnExchangeStatus(Task task);

	void processRspQryDepthMarketData(Task task);

	void processRspQryTradeCode(Task task);

	void processRspEquityComputMode(Task task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onFrontConnected(){};

	virtual void onFrontDisconnected(int i){};

	virtual void onRspUserLogin(dict data, dict error) {};

	virtual void onRspUserLogout(dict data, dict error) {};

	virtual void onRspInsertOrder(dict data, dict error) {};

	virtual void onRspCancelOrder(dict data, dict error) {};

	virtual void onRtnErrorMsg(dict data) {};

	virtual void onRtnMatchedInfo(dict data) {};

	virtual void onRtnOrder(dict data) {};

	virtual void onRtnCancelOrder(dict data) {};

	virtual void onRspQryOrderInfo(dict data, dict error, bool last) {};

	virtual void onRspQryMatchInfo(dict data, dict error, bool last) {};

	virtual void onRspQryPosition(dict data, dict error, bool last) {};

	virtual void onRspCustomerCapital(dict data, dict error, bool last) {};

	virtual void onRspQryExchangeInstrument(dict data, dict error, bool last) {};

	virtual void onRspArbitrageInstrument(dict data, dict error, bool last) {};

	virtual void onRspQrySpecifyInstrument(dict data, dict error, bool last) {};

	virtual void onRspQryPositionDetail(dict data, dict error, bool last) {};

	virtual void onRtnTradingNotice(dict data) {};

	virtual void onRspResetPassword(dict data, dict error) {};

	virtual void onnRspQryTradeCode(dict data, dict error, bool last) {};

	virtual void onRspBillConfirm(dict data, dict error) {};

	virtual void onnRspEquityComputMode(dict data, dict error) {};

	virtual void onRspQryBill(dict data, dict error, bool last) {};

	virtual void onRspConfirmProductInfo(dict data, dict error) {};

	virtual void onRspTradingDay(dict data, dict error) {};

	virtual void onRspQuoteInsert(dict data, dict error) {};

	virtual void onRtnQuoteInsert(dict data) {};

	virtual void onRspQuoteCancel(dict data, dict error) {};

	virtual void onRtnQuoteCancel(dict data) {};

	virtual void onRtnQuoteMatchedInfo(dict data) {};

	virtual void onRspCancelAllOrder(dict data, dict error) {};

	virtual void onRspQryQuoteNotice(dict data, dict error, bool last) {};

	virtual void onRspForQuote(dict data, dict error) {};

	virtual void onRtnForQuote(dict data) {};

	virtual void onRspQryQuoteOrderInfo(dict data, dict error, bool last) {};

	virtual void onRspQryForQuote(dict data, dict error, bool last) {};

	virtual void onRspQryTransferBank(dict data, dict error, bool last) {};

	virtual void onRspQryTransferSerial(dict data, dict error, bool last) {};

	virtual void onRspFromBankToFutureByFuture(dict data, dict error) {};

	virtual void onRspFromFutureToBankByFuture(dict data, dict error) {};

	virtual void onRtnFromBankToFutureByFuture(dict data, dict error) {};

	virtual void onRtnFromFutureToBankByFuture(dict data, dict error) {};

	virtual void onRtnRepealFromFutureToBankByBank(dict data) {};

	virtual void onRspQryExchangeStatus(dict data, dict error, bool last) {};

	virtual void onRtnExchangeStatus(dict data) {};

	virtual void onRspQryDepthMarketData(dict data, dict error, bool last) {};

	virtual void onRspQryTradeCode(dict data, dict error, bool last) {};

	virtual void onRspEquityComputMode(dict data) {};


	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createDFITCTraderApi();

	void release();

	void init(string pszSvrAddr);

	int exit();

	int reqUserLogin(dict req);

	int reqUserLogout(dict req);

	int reqInsertOrder(dict req);

	int reqCancelOrder(dict req);

	int reqQryPosition(dict req);

	int reqQryCustomerCapital(dict req);

	int reqQryExchangeInstrument(dict req);

	int reqQryArbitrageInstrument(dict req);

	int reqQryOrderInfo(dict req);

	int reqQryMatchInfo(dict req);

	int reqQrySpecifyInstrument(dict req);

	int reqQryPositionDetail(dict req);

	int reqConfirmProductInfo(dict req);

	int reqResetPassword(dict req);

	int reqBillConfirm(dict req);

	int reqQryTradeCode(dict req);

	int reqEquityComputMode();

	int reqQryBill(dict req);

	int reqTradingDay(dict req);

	int reqQryQuoteNotice(dict req);

	int reqQuoteInsert(dict req);

	int reqQuoteCancel(dict req);

	int reqCancelAllOrder(dict req);

	int reqForQuote(dict req);

	int reqQryForQuote(dict req);

	int reqQryQuoteOrderInfo(dict req);

	int reqQryTransferBank(dict req);

	int reqQryTransferSerial(dict req);

	int reqFromBankToFutureByFuture(dict req);

	int reqFromFutureToBankByFuture(dict req);

	int reqQryExchangeStatus(dict req);

	int reqQryDepthMarketData(dict req);
};
