/////////////////////////////////////////////////////////////////////////
///@author ̩֤ȯɷ޹˾
///@file xtp_api_data_type.h
///@brief ݻ
/////////////////////////////////////////////////////////////////////////
#ifndef _XTP_API_DATA_TYPE_H_
#define _XTP_API_DATA_TYPE_H_

#pragma pack(8)

/// Ű汾ŵַ
#define XTP_VERSION_LEN 16
/// 汾
typedef char XTPVersionType[XTP_VERSION_LEN];
/// ɽַ
#define XTP_TRADING_DAY_LEN 9
/// ֤ȯַ
#define XTP_TICKER_LEN 16
/// ֤ȯƵַ
#define XTP_TICKER_NAME_LEN 64
/// رŵַ
#define XTP_LOCAL_ORDER_LEN         11
/// ŵַ
#define XTP_ORDER_EXCH_LEN          17
/// ɽִбŵַ
#define XTP_EXEC_ID_LEN             18
/// Աַ
#define XTP_BRANCH_PBU_LEN          7
/// ûʽ˻ַ
#define XTP_ACCOUNT_NAME_LEN        16

/////////////////////////////////////////////////////////////////////////
///@enum XTP_LOG_LEVEL ־
/////////////////////////////////////////////////////////////////////////
enum XTP_LOG_LEVEL {
	XTP_LOG_LEVEL_FATAL, ///<ش󼶱
	XTP_LOG_LEVEL_ERROR, ///<󼶱
	XTP_LOG_LEVEL_WARNING, ///<漶
	XTP_LOG_LEVEL_INFO,   ///<info
	XTP_LOG_LEVEL_DEBUG,  ///<debug
	XTP_LOG_LEVEL_TRACE   ///<trace
};

/////////////////////////////////////////////////////////////////////////
///@enum XTP_PROTOCOL_TYPE ͨѶЭ鷽ʽ
/////////////////////////////////////////////////////////////////////////
enum XTP_PROTOCOL_TYPE
{
	XTP_PROTOCOL_TCP = 1,	///<TCPʽ
	XTP_PROTOCOL_UDP		///<UDPʽ䣨Ŀǰδ֧֣
};



/////////////////////////////////////////////////////////////////////////
///@enum XTP_EXCHANGE_TYPE ǽ
/////////////////////////////////////////////////////////////////////////
enum XTP_EXCHANGE_TYPE
{
	XTP_EXCHANGE_SH = 1,	///<֤
	XTP_EXCHANGE_SZ,		///<֤
    XTP_EXCHANGE_UNKNOWN	///<ڵĽ
};

//////////////////////////////////////////////////////////////////////////
///@enum XTP_MARKET_TYPE г
//////////////////////////////////////////////////////////////////////////
enum XTP_MARKET_TYPE
{
    XTP_MKT_INIT = 0,///<ʼֵδ֪
    XTP_MKT_SZ_A = 1,///<A
    XTP_MKT_SH_A,    ///<ϺA
    XTP_MKT_UNKNOWN   ///<δ֪г
};


/////////////////////////////////////////////////////////////////////////
///@enum XTP_PRICE_TYPE Ǽ۸
/////////////////////////////////////////////////////////////////////////
enum XTP_PRICE_TYPE
{
    XTP_PRICE_LIMIT = 1,           ///<޼۵-
    XTP_PRICE_BEST_OR_CANCEL,      ///<ʱɽʣתм۵-
    XTP_PRICE_BEST5_OR_LIMIT,      ///<嵵ʱɽʣת޼ۣм۵-
    XTP_PRICE_BEST5_OR_CANCEL,     ///<5ʱɽʣתм۵-
    XTP_PRICE_ALL_OR_CANCEL,       ///<ȫɽ,м۵-
    XTP_PRICE_FORWARD_BEST,        ///<ţм۵-
    XTP_PRICE_REVERSE_BEST_LIMIT,  ///<Էʣת޼ۣм۵-
    XTP_PRICE_TYPE_UNKNOWN,		   ///<δ֪Ч۸
};



/////////////////////////////////////////////////////////////////////////
///@enum XTP_SIDE_TYPE 
/////////////////////////////////////////////////////////////////////////
enum XTP_SIDE_TYPE
{
	XTP_SIDE_BUY = 1,	///<¹깺ETF깺ȣ
	XTP_SIDE_SELL,		///<ع
	XTP_SIDE_BUY_OPEN,		///<򿪣δ֧֣
	XTP_SIDE_SELL_OPEN,		///<δ֧֣
	XTP_SIDE_BUY_CLOSE,		///<ƽδ֧֣
	XTP_SIDE_SELL_CLOSE,	///<ƽδ֧֣
    XTP_SIDE_UNKNOWN		///<δ֪Ч
};

/////////////////////////////////////////////////////////////////////////
///@enum XTP_ORDER_ACTION_STATUS_TYPE Ǳ״̬
/////////////////////////////////////////////////////////////////////////
enum XTP_ORDER_ACTION_STATUS_TYPE
{
	XTP_ORDER_ACTION_STATUS_SUBMITTED = 1,	///<Ѿύ
	XTP_ORDER_ACTION_STATUS_ACCEPTED,		///<Ѿ
	XTP_ORDER_ACTION_STATUS_REJECTED		///<Ѿܾ
};

/////////////////////////////////////////////////////////////////////////
///@enum XTP_ORDER_STATUS_TYPE Ǳ״̬
/////////////////////////////////////////////////////////////////////////
enum XTP_ORDER_STATUS_TYPE
{
    XTP_ORDER_STATUS_INIT = 0,///<ʼ
    XTP_ORDER_STATUS_ALLTRADED = 1,           ///<ȫɽ
    XTP_ORDER_STATUS_PARTTRADEDQUEUEING,  ///<ֳɽ
    XTP_ORDER_STATUS_PARTTRADEDNOTQUEUEING, ///<ֳ
    XTP_ORDER_STATUS_NOTRADEQUEUEING,   ///<δɽ
    XTP_ORDER_STATUS_CANCELED,  ///<ѳ
    XTP_ORDER_STATUS_REJECTED,  ///<Ѿܾ
    XTP_ORDER_STATUS_UNKNOWN  ///<δ֪״̬
};

/////////////////////////////////////////////////////////////////////////
///@enum XTP_ORDER_SUBMIT_STATUS_TYPE Ǳύ״̬
/////////////////////////////////////////////////////////////////////////
enum XTP_ORDER_SUBMIT_STATUS_TYPE
{
    XTP_ORDER_SUBMIT_STATUS_INSERT_SUBMITTED = 1, ///<Ѿύ
    XTP_ORDER_SUBMIT_STATUS_INSERT_ACCEPTED,///<Ѿ
    XTP_ORDER_SUBMIT_STATUS_INSERT_REJECTED,///<Ѿܾ
    XTP_ORDER_SUBMIT_STATUS_CANCEL_SUBMITTED,///<Ѿύ
    XTP_ORDER_SUBMIT_STATUS_CANCEL_REJECTED,///<Ѿܾ
    XTP_ORDER_SUBMIT_STATUS_CANCEL_ACCEPTED ///<Ѿ
};


/////////////////////////////////////////////////////////////////////////
///@enum XTP_TE_RESUME_TYPE ǹӦɽرشʽ
/////////////////////////////////////////////////////////////////////////
enum XTP_TE_RESUME_TYPE
{
	XTP_TERT_RESTART = 0,	///<ӱտʼش
	XTP_TERT_RESUME,		///<Ӵϴյδ֧֣
	XTP_TERT_QUICK			///<ֻ͵¼Ӧɽر
};



//////////////////////////////////////////////////////////////////////////
///@enum XTP_TICKER_TYPE ֤ȯ
//////////////////////////////////////////////////////////////////////////
enum XTP_TICKER_TYPE
{
	XTP_TICKER_TYPE_STOCK = 0,            ///<ͨƱ
	XTP_TICKER_TYPE_INDEX,                ///<ָ
	XTP_TICKER_TYPE_FUND,                 ///<
	XTP_TICKER_TYPE_UNKNOWN               ///<δ֪
	
};

//////////////////////////////////////////////////////////////////////////
///@enum XTP_BUSINESS_TYPE ֤ȯҵ
//////////////////////////////////////////////////////////////////////////
enum XTP_BUSINESS_TYPE
{
	XTP_BUSINESS_TYPE_CASH = 0,            ///<ͨƱҵ񣨹ƱETFȣ
	XTP_BUSINESS_TYPE_IPOS,                ///<¹깺ҵ
	XTP_BUSINESS_TYPE_REPO,                ///<عҵδ֧֣
	XTP_BUSINESS_TYPE_ETF,                 ///<ETFҵδ֧֣
	XTP_BUSINESS_TYPE_MARGIN,              ///<ȯҵδ֧֣
	XTP_BUSINESS_TYPE_DESIGNATION,         ///<תйܣδ֧֣
	XTP_BUSINESS_TYPE_UNKNOWN              ///<δ֪

};


/////////////////////////////////////////////////////////////////////////
///@enum XTP_FUND_TRANSFER_TYPE ʽת
/////////////////////////////////////////////////////////////////////////
enum XTP_FUND_TRANSFER_TYPE
{
    XTP_FUND_TRANSFER_OUT = 0,		///<ת XTPת̨
    XTP_FUND_TRANSFER_IN,	        ///<ת ӹ̨תXTP
    XTP_FUND_TRANSFER_UNKNOWN
};

/////////////////////////////////////////////////////////////////////////
///@enum XTP_FUND_OPER_STATUS ̨ʽ
/////////////////////////////////////////////////////////////////////////
enum XTP_FUND_OPER_STATUS {
    XTP_FUND_OPER_PROCESSING = 0, ///<XOMSյڴ
    XTP_FUND_OPER_SUCCESS,
    XTP_FUND_OPER_FAILED,
    XTP_FUND_OPER_SUBMITTED, ///<ύй̨
    XTP_FUND_OPER_UNKNOWN
};



/////////////////////////////////////////////////////////////////////////
///TXTPTradeTypeTypeǳɽ
/////////////////////////////////////////////////////////////////////////
typedef char TXTPTradeTypeType;

///ͨɽ
#define XTP_TRDT_Common '0'
///Ȩִ
#define XTP_TRDT_OptionsExecution '1'
///OTCɽ
#define XTP_TRDT_OTC '2'
///תɽ
#define XTP_TRDT_EFPDerived '3'
///ɽ
#define XTP_TRDT_CombinationDerived '4'
///ETF깺
#define XTP_TRDT_EFTPurchase '5'
///ETF
#define XTP_TRDT_EFTRedem '6'

/////////////////////////////////////////////////////////////////////////
///TXTPOrderTypeTypeǱ
/////////////////////////////////////////////////////////////////////////
typedef char TXTPOrderTypeType;

///
#define XTP_ORDT_Normal '0'
///
#define XTP_ORDT_DeriveFromQuote '1'
///
#define XTP_ORDT_DeriveFromCombination '2'
///ϱ
#define XTP_ORDT_Combination '3'
///
#define XTP_ORDT_ConditionalOrder '4'
///
#define XTP_ORDT_Swap '5'


#pragma pack()

#endif
