//˵

//API
#include "xtp_quote_api.h"

//ϵͳ
#ifdef WIN32
#include "stdafx.h"
#endif
#include <string>
#include <queue>

//Boost
#define BOOST_PYTHON_STATIC_LIB
#include <boost/python/module.hpp>	//pythonװ
#include <boost/python/def.hpp>		//pythonװ
#include <boost/python/dict.hpp>	//pythonװ
#include <boost/python/list.hpp>	//pythonװ
#include <boost/python/object.hpp>	//pythonװ
#include <boost/python.hpp>			//pythonװ
#include <boost/thread.hpp>			//е̹߳
#include <boost/bind.hpp>			//е̹߳


//ռ
using namespace std;
using namespace boost::python;
using namespace boost;


//
#define ONDISCONNECTED 1
#define ONERROR 2
#define ONSUBMARKETDATA 3
#define ONUNSUBMARKETDATA 4
#define ONMARKETDATA 5
#define ONSUBORDERBOOK 6
#define ONUNSUBORDERBOOK 7
#define ONORDERBOOK 8
#define ONQUERYALLTICKERS 9


///-------------------------------------------------------------------------------------
///APIеĲ
///-------------------------------------------------------------------------------------

//GILȫ򻯻ȡã
//ڰC++̻߳GILӶֹpython
class PyLock
{
private:
	PyGILState_STATE gil_state;

public:
	//ĳдöʱGIL
	PyLock()
	{
		gil_state = PyGILState_Ensure();
	}

	//ĳɺٸöʱGIL
	~PyLock()
	{
		PyGILState_Release(gil_state);
	}
};


//ṹ
struct Task
{
	int task_name;		//صƶӦĳ
	void *task_data;	//ݽṹ
	void *task_error;	//ṹ
	int task_id;		//id
	bool task_last;		//ǷΪ󷵻
};


///̰߳ȫĶ
template<typename Data>

class ConcurrentQueue
{
private:
	queue<Data> the_queue;								//׼
	mutable mutex the_mutex;							//boost
	condition_variable the_condition_variable;			//boost

public:

	//µ
	void push(Data const& data)
	{
		mutex::scoped_lock lock(the_mutex);				//ȡ
		the_queue.push(data);							//д
		lock.unlock();									//ͷ
		the_condition_variable.notify_one();			//֪ͨȴ߳
	}

	//ǷΪ
	bool empty() const
	{
		mutex::scoped_lock lock(the_mutex);
		return the_queue.empty();
	}

	//ȡ
	Data wait_and_pop()
	{
		mutex::scoped_lock lock(the_mutex);

		while (the_queue.empty())						//Ϊʱ
		{
			the_condition_variable.wait(lock);			//ȴ֪ͨ
		}

		Data popped_value = the_queue.front();			//ȡеһ
		the_queue.pop();								//ɾ
		return popped_value;							//ظ
	}

};


//ֵлȡĳֵӦֵṹֵ
void getInt(dict d, string key, int* value);

//ֵлȡĳֵӦĸֵṹֵ
void getDouble(dict d, string key, double* value);

//ֵлȡĳֵӦֵַṹֵ
void getChar(dict d, string key, char* value);

//ֵлȡĳֵӦֵַṹֵ
void getStr(dict d, string key, char* value);


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class QuoteApi : public XTP::API::QuoteSpi
{
private:
	XTP::API::QuoteApi* api;			//API
	thread *task_thread;				//ָ߳루pythonݣ
	ConcurrentQueue<Task*> task_queue;	//

public:
	QuoteApi()
	{
		function0<void> f = boost::bind(&QuoteApi::processTask, this);
		thread t(f);
		this->task_thread = &t;
	};

	~QuoteApi()
	{
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ̨ͨӶϿʱ÷á
	///@param reason ԭӦ
	///@remark apiԶ߷ʱûѡڴ˺еLoginµ¼עûµ¼Ҫ¶
	virtual void OnDisconnected(int reason);

	///Ӧ
	///@param error_info ӦʱľĴʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark ˺ֻڷʱŻãһû
	virtual void OnError(XTPRI *error_info);

	///Ӧ
	///@param ticker ϸĺԼ
	///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
	virtual void OnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last);

	///ȡӦ
	///@param ticker ϸĺԼȡ
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
	virtual void OnUnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last);

	///֪ͨ
	///@param market_data ݣҪٷأϢʱᴥ
	virtual void OnMarketData(XTPMD *market_data);

	///鶩Ӧ𣨴˺ӿΪӿڣݲ֧֣
	///@param ticker ϸĺԼ
	///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
	virtual void OnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last);

	///ȡ鶩Ӧ𣨴˺ӿΪӿڣݲ֧֣
	///@param ticker ϸĺԼȡ
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
	virtual void OnUnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last);

	///鶩֪ͨ˺ӿΪӿڣݲ֧֣
	///@param order_book 鶩ݣҪٷأϢʱᴥ
	virtual void OnOrderBook(XTPOB *order_book);

	///ѯɽ׺ԼӦ
	///@param ticker_info ɽ׺ԼϢ
	///@param error_info ѯɽ׺ԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴βѯɽ׺ԼһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	virtual void OnQueryAllTickers(XTPQSI* ticker_info, XTPRI *error_info, bool is_last);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processDisconnected(Task *task);

	void processError(Task *task);

	void processSubMarketData(Task *task);

	void processUnSubMarketData(Task *task);

	void processMarketData(Task *task);

	void processSubOrderBook(Task *task);

	void processUnSubOrderBook(Task *task);

	void processOrderBook(Task *task);

	void processQueryAllTickers(Task *task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onDisconnected(int reason) {};

	virtual void onError(dict data) {};

	virtual void onSubMarketData(dict data, dict error, bool last) {};

	virtual void onUnSubMarketData(dict data, dict error, bool last) {};

	virtual void onMarketData(dict data) {};

	virtual void onSubOrderBook(dict data, dict error, bool last) {};

	virtual void onUnSubOrderBook(dict data, dict error, bool last) {};

	virtual void onOrderBook(dict data) {};

	virtual void onQueryAllTickers(dict data, dict error, bool last) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createQuoteApi(int clientid, string path);

	void release();

	int exit();

	string getTradingDay();

	string getApiVersion();

	int subscribeMarketData(string ticker, int exchange);

	int unSubscribeMarketData(string ticker, int exchange);

	int subscribeOrderBook(string ticker, int exchange);

	int unSubscribeOrderBook(string ticker, int exchange);

	int login(string ip, int port, string user, string password, int socktype);

	int logout();

	int queryAllTickers(int exchange);
};
